
/* qddb/Headers/Rows.h
 * General Row definitions.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */


#if !defined(_QDDB_ROWS_H_)
#define _QDDB_ROWS_H_

typedef struct row_list {
    int			Attribute;
    int			Flags;
    struct row_list	*next; /* next one on same row */
    struct row_list	*down; /* next row */
} RowList;

/* Flags */
#define ROWLIST_CONTAINS_TRUE  0x0001
#define ROWLIST_CONTAINS_FALSE 0x0002

Boolean RowListCompareRows _ANSI_ARGS_((InCoreEntry *, RowList *, RowList *, size_t *, size_t));
void    RowListFreeRow _ANSI_ARGS_((RowList *));
int	RowListShouldSkipRow _ANSI_ARGS_((InCoreEntry *, RowList *, size_t *, size_t));
void 	RowListDeleteDuplicateRows _ANSI_ARGS_((InCoreEntry *, RowList *, size_t *, size_t));
RowList *RowListProcessEntry _ANSI_ARGS_((Schema *, InCoreEntry *));
RowList *RowListProcessAttr _ANSI_ARGS_((Schema *, InCoreEntry *, size_t, size_t *, size_t));
RowList *RowListProcessInst _ANSI_ARGS_((Schema *, InCoreEntry *, size_t, size_t *, size_t));
RowList *RowListCopy _ANSI_ARGS_((RowList *));
RowList	*RowListCartesianProduct _ANSI_ARGS_((RowList *, RowList *));
RowList *RowListUnion _ANSI_ARGS_((RowList *, RowList *));
void RowListPruneUntrueRows _ANSI_ARGS_((RowList **));
#if defined(USE_TCL)
int Qddb_RowListQuery _ANSI_ARGS_((Tcl_Interp *, Schema *, KeyList *, char *, char **, size_t *, \
				   size_t, char **, size_t, Boolean, Boolean, Boolean, Boolean, Boolean));
#else
int Qddb_RowListQuery _ANSI_ARGS_((Schema *, KeyList *, char *, char **, size_t *, size_t, \
				   char **, size_t, Boolean, Boolean));
#endif

#endif

