
/* Memory.h -- Definitions for miscellaneous memory functions.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */

#if !defined(_QDDB_MEMORY_H_)
#define _QDDB_MEMORY_H_
#if defined(DEBUG_MALLOC)
#include "/usr/local/include/dmalloc.h"
#undef USE_MALLOC_FUNCTIONS
#else
#define USE_MALLOC_FUNCTIONS
#endif

#if defined(USE_MALLOC_FUNCTIONS)
char 			*Malloc _ANSI_ARGS_((size_t));
char 			*Calloc _ANSI_ARGS_((size_t));
char 			*Realloc _ANSI_ARGS_((void *, size_t));
void			Free _ANSI_ARGS_((void *));
#else
#if defined(USE_TCL)
#define Malloc(x)	malloc(x), qddb_malloc_bytes_used += x
/*void *ckcalloc(size_t);*/
#define Calloc(x)	calloc(x,1), qddb_malloc_bytes_used += x
#define Realloc(x,y)	realloc(x,y)
#define Free(x)		free(x)
#else
#define Malloc(x)	malloc(x), qddb_malloc_bytes_used += x
#define Calloc(x)	calloc(x, 1), qddb_malloc_bytes_used += x
#define Realloc(x,y)	realloc(x,y)
#define Free(x)		free(x)
#endif
#endif

#if !defined(USE_GNU_MALLOC)
extern size_t		qddb_malloc_bytes_used;
#endif

#if defined(USE_GNU_MALLOC)
#include "GNUmalloc.h"
#endif

/* Allocated memory types. 
 */
#define QDDB_TYPE_INCOREENTRY	1
#define QDDB_TYPE_KEYLIST	2
#define QDDB_TYPE_ROWLIST	3
#define QDDB_TYPE_DATATREE	4
#define QDDB_TYPE_SCHEMATREE	5
#define QDDB_TYPE_ENTRY		6
#define QDDB_TYPE_SCHEMA	7
#define QDDB_TYPE_GENERIC	8
#define QDDB_TYPE_DOUBLELIST	9
#define QDDB_TYPE_TABLECALC	10
#define QDDB_TYPE_TABLEREFS	11
#define QDDB_TYPE_WORDLIST	12
#define QDDB_TYPE_ATTRLIST      13

#define QDDB_MIN_MALLOC_SIZE	0x04

void			Qddb_Free _ANSI_ARGS_((int, void *));

#endif




