/* qddb/Headers/Qddb.h
 * General QDDB definitions.
 *
 * Copyright (C) 1993, 1994 Herrin Software Development, Inc.
 * All rights reserved.
 *
 * This file is part of Qddb.
 *
 * Qddb is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2
 * as published by the Free Software Foundation.
 *
 * Qddb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Qddb; see the file LICENSE.  If not, write to:
 *
 *	Herrin Software Development, Inc. 
 *	R&D Division
 *	41 South Highland Ave. 
 *	Prestonsburg, KY 41653 
 */


#if !defined(_QDDB_QDDB_H_)
#define _QDDB_QDDB_H_

#define QDDB_VERSION "1.43 (GNU)"
#define QDDB_MAJORVERSION 1
#define QDDB_MINORVERSION 43
#define QDDB_PATCHLEVEL 0

#if !defined(DEFAULT_DATE_FORMAT)
#define DEFAULT_DATE_FORMAT "%m/%d/%y"
#endif

#define QDDB_DATE_STYLE_US 0
#define QDDB_DATE_STYLE_EUROPEAN 1

#if defined(HAVE_CONFIG_H)
#	include "Qddb_Config.h"
#endif

#if defined(__GNUC__)
#    define alloca __builtin_alloca
#else
#    if HAVE_ALLOCA_H
#        include <alloca.h>
#    else
#        if defined(_AIX)
 #           pragma alloca
#        else
#            if !defined(alloca)
                 void *alloca();
#            endif
#        endif
#    endif
#endif

#ifndef DIAGNOSTIC
#define DIAGNOSTIC
#endif

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#if defined(HAVE_FLOAT_H)
#       include <float.h>
#endif
#if defined(HAVE_SYS_CDEFS_H)
#	include <sys/cdefs.h>
#endif
#if defined(HAVE_FCNTL_H)
#	include <fcntl.h>
#endif
#if defined(HAVE_SYS_FILE_H)
#	include <sys/file.h>
#endif
#if defined(HAVE_ERRNO_H)
#	include <errno.h>
#endif

#if !defined(DEBUG_MALLOC)
#	if defined(HAVE_STDLIB_H)
#		include <stdlib.h>
#	else
#		define _STDLIB_H_
#		define __stdlib_h
#	endif
#else
#	define _STDLIB_H_
#	define __stdlib_h
#	if defined(__STDC__)
            double strtod (const char *, char **);
            long strtol (const char *, char **, int);
            unsigned long strtoul (const char *, char **, int);
            double atof(const char *);
#	else
            double strtod ();
            long strtol ();
            unsigned long strtoul ();
            double atof();
#	endif
#endif

#if defined(TIME_WITH_SYS_TIME)
#	include <time.h>
#	include <sys/time.h>
#	if defined(HAVE_UTIME_H)
#		include <utime.h>
#	endif
#else
#if defined(HAVE_SYS_TIME_H)
#	include <sys/time.h>
#else
#	include <time.h>
#	if defined(HAVE_UTIME_H)
#		include <utime.h>
#	endif
#endif
#endif

#if defined(HAVE_SYS_RESOURCE_H)
#	include <sys/resource.h>
#endif
#if defined(STDC_HEADERS)
#	include <string.h>
#	if defined(HAVE_MEMORY_H)
#		include <memory.h>
#	endif
#	if defined(HAVE_STRCHR)
#		define index strchr
#		define rindex strrchr
#	endif
# 	if defined(HAVE_MEMCPY)
#		define bcopy(src, dst, num) 	memcpy((dst), (src), (num))
#		define bcmp(str1, str2, num) 	memcmp((str1), (str2), (num))
#		define bzero(buf, num)		memset((buf), 0, (num))
#	endif
#else
#	if defined(HAVE_STRING_H)
#		include <string.h>
#		if defined(HAVE_MEMORY_H)
#			include <memory.h>
#		endif
#		if defined(HAVE_STRCHR)
#			define index strchr
#			define rindex strrchr
#		endif
#	 	if defined(HAVE_MEMCPY)
#			define bcopy(src, dst, num) 	memcpy((dst), (src), (num))
#			define bcmp(str1, str2, num) 	memcmp((str1), (str2), (num))
#			define bzero(buf, num)		memset((buf), 0, (num))
#		endif
#	else
#		include <strings.h>
#	endif
#endif
#if defined(HAVE_SYS_WAIT_H)
#	include <sys/wait.h>
#endif
#if defined(HAVE_UNISTD_H)
#	include <unistd.h>
#endif
#if defined(HAVE_DIRENT_H)
#	include <dirent.h>
#	define NLENGTH(dirent) (strlen((dirent)->d_name))
#else
#	define dirent direct
#	define NLENGTH(dirent) ((dirent)->d_namlen)
#	if defined(HAVE_SYS_NDIR_H)
#		include <sys/ndir.h>
#	endif
#	if defined(HAVE_SYS_DIR_H)
#		include <sys/dir.h>
#	endif
#	if defined(HAVE_NDIR_H)
#		include <ndir.h>
#	endif
#endif


#undef _ANSI_ARGS_
#if defined(__STDC__) || defined(__cplusplus)
#   define _ANSI_ARGS_(x)   x
#else
#   define _ANSI_ARGS_(x)   ()
#endif

/* Extra definitions -n- stuff
 */

#if !defined(HAVE_STRTOK)
char *strtok _ANSI_ARGS_((char *, char *));
#endif
#if !defined(HAVE_STRCSPN)
int strcspn _ANSI_ARGS_((char *, char *));
#endif
#if !defined(HAVE_STRSEP)
char *strsep _ANSI_ARGS_((char **, const char *));
#endif

#if !defined(HAVE_STDLIB_H)
char *malloc _ANSI_ARGS_((size_t));
char *calloc _ANSI_ARGS_((size_t, size_t));
char *realloc _ANSI_ARGS_((void *, size_t));
void free _ANSI_ARGS_((void *));
#endif
#if !defined(HAVE_STRTOD)
double strtod _ANSI_ARGS_((const char *, char **));
#endif
#if !defined(HAVE_STRTOUL)
long strtol _ANSI_ARGS_((const char *, char **, int));
#endif
#if !defined(HAVE_STRTOUL)
unsigned long strtoul _ANSI_ARGS_((const char *, char **, int));
#endif
#if defined(_isupper)
#undef _isupper
#endif
#define _isupper( x ) isupper(x)

#if defined(_tolower)
#undef _tolower
#endif
#define _tolower( x )	tolower(x)

#if defined(HAVE_GETCWD)
#	define GETPWD( x )		(void)getcwd(x, sizeof(x))
#else
#	if defined(HAVE_GETWD)
#		define GETPWD( x )	(void)getwd(x)
#	endif
#endif

#if !defined(LOCAL_DEFAULT_EDITOR)
#define LOCAL_DEFAULT_EDITOR "/usr/bin/vi"
#endif

/* NOTE: These really aren't options anymore.   You shouldn't change them.
 *
 * OPTIONS:
 *	RECORDLOCKING - 
 *		      Enable only if your OS can support fcntl (struct flock)
 *		      style locking and you wish to use it.
 *	QDDBDIRS    - Enable if you want the user to be able to specify a list
 *		      of directories in which to search for relations.  
 *		         Example: QDDBDIRS=:/u/eric/databases:/usr/local/dbase:
 *		      Colon separated, like ${PATH}.
 *	DEBUG	    - 'Tons' of debug stuff.
 *	${OSTYPE}   - DON'T CHANGE THIS!!!  Changed by Setup.
 *	BIGMEMORY   - Enable this if you can run processes that are truly HUGE
 *		      comfortably.  Need memory > 16-40 meg for this.  Only
 *		      used if OPTIMALLOC is enabled, otherwise ignored.
 *	DEBUGMALLOC - Print diagnostics about malloc(3) calls.
 *	SQL	    - Enable SQL attribute specific searching; needed if
 *		      you are going to use qsql(1) and/or the qsql(3) routines.
 *		      This does slow down qindex(1) a bit, but searching is
 *		      not affected much.  Basically, this just allows you to
 *		      search for a key in a particular attribute.
 *	ATTRIBUTED_SEARCH -
 *		      This needs to be defined if SQL is defined.  It will
 *		      be removed in a future release.
 *	INSTANCE_QUALIFICATION -
 *		      This allows full row-specific searching.  Recommended
 *		      if SQL is defined.  Slows qindex(1) down a bit more,
 *		      but searching isn't affected much.
 *	V8_REGEXP   - Enable regular expression searching using V8 regexp.
 *	BACKCOMPATIBLE -
 *		      Various checks for old databases.
 */

#define BACKCOMPATIBLE
#if defined(USE_RECORD_LOCKING) && USE_RECORD_LOCKING == 1
#	define RECORDLOCKING 
#endif
#define QDDBDIRS
#define SQL 
#define V8_REGEXP
#define ATTRIBUTED_SEARCH 
#define INSTANCE_QUALIFICATION 
#define QDDB_STAB_STATS

#if !defined(MAXIMUM_MEMORY_USAGE)
#	define MAXIMUM_MEMORY_USAGE (5*1024)	/* default maximum qstall growth */
#endif
#define CONVERT( X )		X
#define SYSTEM_ERROR		-1

#define FILE_ERROR	0x01
#define MEMORY_ERROR	0x02
#define ASCII_LONG_SIZE	10
#define INIT_NUMBER	1

#define CHUNKSIZE	(128*1024)

#if defined(PATH_MAX)
#undef MAXPATHLEN
#define MAXPATHLEN PATH_MAX
#endif
#if !defined(MAXPATHLEN)
#define MAXPATHLEN	1024
#endif
#define MAXFILENAMELEN	MAXPATHLEN

#if !defined(MAX)
#define MAX( x, y )			( (x) > (y)? (x) : (y) )
#endif
#if !defined(MIN)
#define MIN( x, y )			( (x) > (y)? (y) : (x) )
#endif

#define MAXIMUM_NUMBER_OF_INCOREENTRIES	20480
#ifndef MAXIMUM_NUMBER_OF_SCHEMA_LEVELS
#define MAXIMUM_NUMBER_OF_SCHEMA_LEVELS	16
#endif
#define MAX_ATTRIBUTE_SIZE		(20*1024)

#define MAXLEVEL			MAXIMUM_NUMBER_OF_SCHEMA_LEVELS
#define MAXDATA				MAX_ATTRIBUTE_SIZE

#define ATTRSIZ				2048 /* Default Attribute Size */
#define MAXINTEGERLEN			(sizeof(long)*3) /* a little overkill */

#if defined(True) || defined(False) || defined(Inapplicable)
#undef True
#undef False
#undef Inapplicable
#endif

/* For systems that do not have flock() 
 */
#if !defined(LOCK_SH)
#define LOCK_SH 0x01
#endif
#if !defined(LOCK_EX)
#define LOCK_EX 0x02
#endif
#if !defined(LOCK_NB)
#define LOCK_NB 0x04
#endif
#if !defined(LOCK_UN)
#define LOCK_UN 0x08
#endif

typedef enum {
	False = (0==1),
	True  = (1==1),
	Inapplicable = 2
} Boolean;

typedef struct incoreentry {
    int			SequenceNumber;	    /* The unique sequence number of the data */
    int			BytesOfData;	    /* How long is the data? */
    int			Index;		    /* Index in array */
    Boolean		Marked;		    /* This instance is marked by a previous search */
    char		*Data;		    /* The data in the attribute */
    size_t		AttributeNumber;    /* index into Schema */
    size_t		Instance[MAXLEVEL]; /* instance numbers */
} InCoreEntry;

typedef char	**Entry;	/* The database entry as it appears in the
				 * database.
				 */

typedef char	**TCLEntry;     /* The database entry massaged for TCL/TK.
				 */

typedef struct double_list {
    double		val;
    struct double_list	*next;
} Qddb_DoubleList;

#if !defined(M_PI)
#define M_PI            3.14159265358979323846  /* pi */
#endif
#if !defined(M_PI_2)
#define M_PI_2          1.57079632679489661923  /* pi/2 */
#endif
#if !defined(M_PI_4)
#define M_PI_4          0.78539816339744830962  /* pi/4 */
#endif
#if !defined(DBL_MAX)
#define DBL_MAX         1.7976931348623157E+308
#endif

#if defined(USE_TCL)
#include "tcl.h"
#endif

/* All the qddb header files (must be before definition of DataTree)
 */

#include "Qddb_Hash.h"
#include "Qddb_KeyList.h"
#include "Qddb_WordList.h"
#include "Qddb_Schema.h"
#include "Qddb_Index.h"
#include "Regexp.h"
#include "Qddb_Search.h"
#include "Qddb_Rows.h"
#if defined(SQL)
#include "Qddb_Sql.h"
#endif
#include "Qddb_Globals.h"
#include "Qddb_Changes.h"
#include "Qddb_Conversion.h"
#include "Qddb_TCL.h"
#include "Qddb_Memory.h"
#include "Qddb_Utils.h"
#include "Qddb_Sort.h"
#include "Qddb_Tree.h"
#include "Qddb_ReducedAttr.h"
#include "Qddb_Table.h"

void Qddb_Init _ANSI_ARGS_((void));
extern Boolean Qddb_using_TCL;

#endif

