/* This may look like C, but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "finddialog.h"
#include "finddialog.moc"


// --- public member functions -----------------------------------


// --- private member functions ----------------------------------


// --- constructor -----------------------------------------------


/*
 * The constructor sets up the dialog contents.
 */
TFindDialog::TFindDialog(QWidget* parent = 0,
			 const char* name = 0,
			 bool modal = false,
			 WFlags f = 0)
  : QDialog(parent, name, modal, f)
{
  // --- init private data ---------------------------------------  


  // --- set up window -------------------------------------------  

  setMinimumSize(260, 200);

  // --- controls ------------------------------------------------  

  QPushButton *bOk =
    new QPushButton(i18n("OK"), this, "ok_button");
  bOk->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bOk, SIGNAL(clicked()), this, SLOT(ok()) );
  
  QPushButton *bCancel =
    new QPushButton(i18n("Cancel"), this, "cancel_button");
  bCancel->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bCancel, SIGNAL(clicked()), this, SLOT(cancel()) );
  
  // --- layout --------------------------------------------------
  
  QBoxLayout *mainLayout = new QVBoxLayout(this, 6);
  QBoxLayout *topLayout = new QHBoxLayout(6);
  QBoxLayout *bottomLayout = new QHBoxLayout(10);
  
  mainLayout->addLayout(topLayout, 1);
  mainLayout->addLayout(bottomLayout);

  bottomLayout->addStretch(1);
  bottomLayout->addWidget(bOk);
  bottomLayout->addWidget(bCancel);
  bottomLayout->addStretch(1);
}


// --- slots -----------------------------------------------------


/*
 * This method is called when the user presses the OK button.
 * It will check if input is ok and set okPressed accordingly.
 * If something went wrong, the dialog will remain open and an
 * error messages occurs.
 */
void
TFindDialog::ok()
{
  //  if (lbItems->count() > 0) {
  emit done(1);
  //  } else {
  //    QMessageBox::critical
  //      (0, APPNAME, i18n("There has to be at least one field."));
  //  }
}


/*
 * This method is called when the user presses the Cancel button.
 * It will close the window.
 */
void
TFindDialog::cancel()
{
  emit done(0);
}
