/* This may look like C but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __EDITRECDIALOG_H
#define __EDITRECDIALOG_H

// ----------------------------- Qt ------------------------------
#include <qmsgbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlistbox.h>

// ---------------------------- KDE ------------------------------
#include <kapp.h>  // klocale

// -------------------------- My Files ---------------------------
#include "main.h"

// ------------------------ dialog layout ------------------------

#define VSKIP_MAIN_LAYOUT 6
#define VSKIP_EDIT_LAYOUT 4

#define STRETCH_LABELS 1
#define STRETCH_EDIT_FIELDS 4

// ---------------------- Class definition -----------------------

class TEditRecDialog : public QDialog
{
  Q_OBJECT
  
public:
  TEditRecDialog(QStrList* fields, QStrList *record,
		 QWidget* parent = 0, const char* name = 0,
		 bool modal = true, WFlags f = 0);
  ~TEditRecDialog();

  virtual QStrList* strings();

public slots:
  virtual void ok();
  virtual void cancel();

private:
  /*
   * "QList<QLineEdit> leItems;" creates an "Internal compiler error"
   * with g++ 2.7.2.1 and lets g++ 2.8.1 and egcs 1.0.3 produce weird
   * error messages. Any suggestions?
   */
  QList<QLineEdit> *leItems;

  QButton *bReset;
  QButton *bOk;
  QButton *bCancel;
};

#endif /* __EDITRECDIALOG_H */
