/* This may look like C, but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "editrecdialog.h"
#include "editrecdialog.moc"


// --- public member functions -----------------------------------


/*
 *
 */
QStrList* TEditRecDialog::strings()
{
  QStrList *result = new QStrList();

  for (unsigned int i = 0; i < leItems->count(); i++) {
    QLineEdit* lineEdit = leItems->at(i);
    result->append(lineEdit->text());
  }
  return result;
}


// --- constructor -----------------------------------------------


/*
 * Set up window with n labels and n edit fields where n is
 * the number of elements in the record list. This value is
 * assumed to be equal to the number of elements in the fields
 * list.
 */
TEditRecDialog::TEditRecDialog(QStrList* fields,
			       QStrList* record,
			       QWidget* parent = NULL,
			       const char* name = NULL,
			       bool modal = true,
			       WFlags f = 0)
  : QDialog(parent, name, modal, f)
{
  // --- controls ------------------------------------------------  

  leItems = new QList<QLineEdit>;
  QList<QLabel> labelFields;

  for (unsigned int i = 0; i < record->count(); i++) {
    QLineEdit *leItem = new QLineEdit(this, "item_edit");
    QLabel *labelField =
      new QLabel(leItem, fields->at(i), this, "field_label");
    
    leItem->setText(record->at(i));

    labelField->setMinimumHeight(CONTROL_HEIGHT);
    labelField->setMaximumHeight(CONTROL_HEIGHT);
    leItem->setMinimumHeight(CONTROL_HEIGHT);
    leItem->setMaximumHeight(CONTROL_HEIGHT);

    labelFields.append(labelField);
    leItems->append(leItem);
  }

  QPushButton *bOk = new QPushButton(i18n("OK"), this, "ok_button");
  bOk->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  bOk->setDefault(true);
  connect(bOk, SIGNAL(clicked()), this, SLOT(ok()) );
  
  QPushButton *bCancel = new QPushButton(i18n("Cancel"),
					 this, "cancel_button");
  bCancel->setFixedSize(BUTTON_WIDTH, BUTTON_HEIGHT);
  connect(bCancel, SIGNAL(clicked()), this, SLOT(cancel()) );
  
  // --- layout --------------------------------------------------

  QBoxLayout *mainLayout = new QVBoxLayout(this, VSKIP_MAIN_LAYOUT);
  QBoxLayout *topLayout = new QHBoxLayout(6);
  QBoxLayout *bottomLayout = new QHBoxLayout(10);
  QBoxLayout *leftLayout = new QVBoxLayout(VSKIP_EDIT_LAYOUT);
  QBoxLayout *rightLayout = new QVBoxLayout(VSKIP_EDIT_LAYOUT);
  
  mainLayout->addLayout(topLayout, 1);  // stretch the top of the dialog
  mainLayout->addLayout(bottomLayout);  // don't strech the buttons line at all
  topLayout->addLayout(leftLayout, STRETCH_LABELS);
  topLayout->addLayout(rightLayout, STRETCH_EDIT_FIELDS);

  for (unsigned int i = 0; i < leItems->count(); i++) {
    leftLayout->addWidget(labelFields.at(i));
    rightLayout->addWidget(leItems->at(i));
  }

  leftLayout->addStretch(1);
  rightLayout->addStretch(1);

  bottomLayout->addStretch(1);
  bottomLayout->addWidget(bOk);
  bottomLayout->addWidget(bCancel);
  bottomLayout->addStretch(1);
  
  setMinimumSize(260,
    record->count() * (CONTROL_HEIGHT + VSKIP_EDIT_LAYOUT) - VSKIP_EDIT_LAYOUT
	+ BUTTON_HEIGHT + 3 * VSKIP_MAIN_LAYOUT);
}


// --- destructor ------------------------------------------------


/*
 * Remove QEditItem list.
 */
TEditRecDialog::~TEditRecDialog()
{
  delete leItems;
}


// --- slots -----------------------------------------------------


/*
 * Set okPressed flag and close dialog.
 */
void TEditRecDialog::ok()
{
  emit done(1);
}


/*
 * Close dialog without setting okPressed flag.
 * The destructor defaults that flag to false.
 */
void TEditRecDialog::cancel()
{
  emit done(0);
}

