/* This may look like C, but it's really -*- C++ -*- */

/*
    kdb - A Simple but fast database editor for the KDE
    Copyright (C) 1998  Thorsten Niedzwetzki

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __CHARSEPDB_H_
#define __CHARSEPDB_H_

// ------------------ C++ --------------------
#include <fstream.h>
#include <strstream.h>

// ---------------- My Files -----------------
#include "memorydb.h"

#define DEFAULT_ESCAPE_CHAR '\\'
#define DEFAULT_SEPARATOR ':'

/*
 * TCharSepDB is a derivation from TMemoryDB for text file based
 * databases containing one record per line. The record fields are
 * separated with one special character, e.g. a comma, tab or colon. A
 * good example for the latter case is /etc/passwd.
 */
class TCharSepDB : public TMemoryDB
{
public:
  TCharSepDB(char newSeparator = DEFAULT_SEPARATOR,
	     bool newContainsHeader = true,
	     char newEscapeChar = DEFAULT_ESCAPE_CHAR,
	     unsigned int newBufSize = 9999)  /* CHANGE THIS TO OSTRSREAM! */
    : TMemoryDB(),
      separator(newSeparator),
      containsHeader(newContainsHeader),
      escapeChar(newEscapeChar),
      bufSize(newBufSize)
    { }

  /* Set separator and escape characters. It is assumed, that these
   * characters differ. */
  virtual void setSeparator(char newSeparator, char newEscapeChar = 0);

  virtual void setContainsHeader(bool newContainsHeader)
    { containsHeader = newContainsHeader; }

  virtual bool loadFromFile(const char *fileName);
  virtual bool writeToFile(const char *fileName);

private:
  char separator;
  bool containsHeader;
  char escapeChar;
  unsigned int bufSize;

protected:
  void saveEscaped(ostream out, char* s);
};

#endif /* __CHARSEPDB_H_ */
