#!/bin/sh
if [ -f ldbf.zip -o -f ldbf1.zip ]; then
  echo "Copyright (c) 1996 Nadezhda Company & Vlad Seriakov"
  echo "LDBF package is installing,please wait..."
  echo "Extracting ldbf1.zip..."
  ./unzip -x ldbf.zip > install.log
  echo "Extracting ldbf.zip..."
  ./unzip -x ldbf1.zip > install.log
  if [ -f etc/ldbf.conf ]; then
    echo "Replacing LDBF home and host name in ldbf.conf file..."
    pwd > .tmp
    sed 's/\//\\\//g' < .tmp > .tmp1
    pw=`cat .tmp1`
    machine=`uname -a | awk '{ print $1 }'`
    host=`uname -a | awk '{ print $2 }'`
    if [ "X${machine}" = "XLinux" ]; then
      host=`hostname -f`
    fi
    user=`whoami`
    cat >> ldbf.sed <<!
    s/LDBFHOST/$host/g
    s/LDBFUSER/$user/g
    s/LDBFHOME/$pw/g
!
    mv etc/ldbf.conf ldbf.conf.tmp
    sed -f ldbf.sed ldbf.conf.tmp > etc/ldbf.conf
    rm ldbf.sed ldbf.conf.tmp .tmp .tmp1
    rm ldbf.zip ldbf1.zip unzip install.sh install.log
    echo "Setting permissions..."
    chmod 770 log etc stored
    chmod 660 etc/ldbf.conf etc/ldbf.sl
    echo 
    echo "LDBF package has been installed."
    echo
    echo "If you have license for more than one simultaneous connected users, you"
    echo "have to run 'ldbfsetup' program."
    echo
  else
    echo
    echo "There is problem installing LDBF package.Check permissions on directory."
    echo
  fi
else
  echo "Archives ldbf.zip and ldbf1.zip MUST BE in current directory.Exiting..."
  exit 1;
fi

