/***************************************************************************
**	ldbf.h	- LDBF Widgets library
**      Copyright (c) 1995 Nadezhda Company, 
**         Software group, Vlad Seriakov
****************************************************************************/
#ifndef _LDBF_WIDGET_
#define _LDBF_WIDGET_

#ifdef WINDOWS
#define LD_FUNCTION FAR pascal _export
#define LD_PTR      FAR
#else
#define LD_FUNCTION 
#define LD_PTR      
#endif

/* structure for connecting elements to double-linked list */
typedef struct _link_list {
   struct _link_list *next;
   struct _link_list *prev;
   int no;                    /* sequenced number */
} link_list;

/* list's elements container */
typedef struct {
   link_list *last ;           /* The last Link */
   void  *selected ;
   int     n_link ;            /* The number of links in the list */
} ldbfList;

#define  LINKPTR(p)  ((link_list *)p)

#ifdef __cplusplus
  extern "C" {
#endif

#if !defined(WINDOWS) && !defined(msdos)

/* definition of various borders */
#define GC_PSEUDO  "-|++--++++* "    /* Emulate graphic chars */
#ifndef KOI8
#define GC_SINGLE  "ĳô "
#define GC_DOUBLE  "ͺ̹Ȼ "
#define GC_PANEL   " "
#define GC_POPUP   "ͳƵԸ "
#else
#define GC_SINGLE  GC_PSEUDO
#define GC_DOUBLE  GC_PSEUDO
#define GC_PANEL   GC_PSEUDO
#endif

/* Defintiton of palettes */
#define WINDOW_TITLE_PALETTE    1
#define WINDOW_TITLE_PALETTE1   2    
#define WINDOW_BACKGROUND_PALETTE   3
#define TEXT_WIDGET_PALETTE     4
#define TEXT_WIDGET_PALETTE1    5
#define INPUT_WIDGET_PALETTE    10
#define INPUT_WIDGET_PALETTE1   11
#define LIST_WIDGET_PALETTE     12
#define LIST_WIDGET_PALETTE1    13
#define BUTTON_WIDGET_PALETTE   14
#define BUTTON_WIDGET_PALETTE1  15
#define SELECTED_PALETTE        16
#define SELECTED_PALETTE1       17
#define MENU_WIDGET_PALETTE     18
#define MENU_WIDGET_PALETTE1    19
#define CHECK_WIDGET_PALETTE    20
#define CHECK_WIDGET_PALETTE1   21
#define RADIO_WIDGET_PALETTE    22
#define RADIO_WIDGET_PALETTE1   23
#define MENUBAR_WIDGET_PALETTE  24
#define MENUBAR_WIDGET_PALETTE1 25
#define DESKTOP_TITLE_PALETTE   26
#define DESKTOP_TITLE_PALETTE1  27
#define DESKTOP_BACKGROUND_PALETTE   28
#define WAIT_WINDOW_PALETTE     29
#define DISABLED_PALETTE        30

/* Definition of event types */
#define E_KEY      1       /* key was pressed */
#define E_MESSAGE  2       /* message */
#define E_MOUSE    3       /* mouse */
#define E_COMMAND  4       /* special command */
#define E_FAIL     5       /* reply failure */
#define E_TIMEOUT  6       /* timeout from keyboard */
#define E_EMPTY    7       /* field must not be empty */
#define E_REFRESH  8       /* refreshes screen */

/* Reserved comands */
#define CM_ACTIVATE           10    /* before activating form */
#define CM_DEACTIVATE         11    /* before deactivating form */
#define CM_WIDGET             12    /* widget specific action */
#define CM_WHEN               13    /* before activating widget */
#define CM_VALID              14    /* before deactivating widget */
#define CM_NEXT_FORM          15    /* activate next form */
#define CM_PREV_FORM          16    /* activate prev form */
#define CM_NEXT               17    /* activate next widget */
#define CM_PREV               18    /* activate prev widget */
#define CM_CLOSE              19    /* close form */
#define CM_DISABLE            20    /* disable widget */
#define CM_ENABLE             22    /* enable widget */
#define CM_QUIT               23    /* quit application */
#define CM_SELECTED           24    /* when item selected in the listbox */
#define CM_TAGGED             25    /* when item is tagged in the listbox */
#define CM_DRAW               26    /* draw widget */
#define CM_EXIT               27    /* generic exit */
#define CM_FREE		      28    /* equal to CM_CLOSE but form will be freed */
#define CM_SELECT             29    /* sent to widget before it become active */
#define CM_OK                 30    /* exit dialog form without free */
         
/* Definititon of event structure */
typedef struct {
   link_list link;
   signed char Event;       /* type of event */
   int Parm1,Parm2;         /* parameters of event */
   void *Data;              /* pointer on event's data */
} ldbfEvent;

/*  Widget types */
#define WT_INPUT_WIDGET  1     /* input line  */
#define WT_BUTTON_WIDGET 2     /* button      */
#define WT_LIST_WIDGET   3     /* listbox     */
#define WT_TEXT_WIDGET   4     /* static test */
#define WT_MENU_WIDGET   5     /* menubar     */
#define WT_CHECK_WIDGET  6     /* checkbox    */
#define WT_RADIO_WIDGET  7     /* radiobutton */
#define WT_POPUP_WIDGET  8     /* popup box   */
#define WT_MEMO_WIDGET   9     /* editor */
#define WT_BOX_WIDGET    10    /* rectangle */

/* Widget options */
#define WO_DISABLED     1
#define WO_NUMERIC      2     /* for INPUT widgets, only digits allowed */
#define WO_ADVANCE      4     /* for INPUT widgets, jump to next field 
                                when input full                         */
#define WO_LIST_AS_MENU 8     /* for using listbox as menubox           */
#define WO_VERTICAL     16    /* vertical position of widget            */
#define WO_HORIZONTAL   32    /* horizontal position of widget          */
#define WO_NOTEMPTY     64    /* input widget must not be empty         */
#define WO_REVERSE      128   /* widget is shown with reverse color     */
#define WO_SCROLL       256   /* scrollable text,input,list             */
#define WO_NOFILE       512   /* no file operations in memo widget      */
#define WO_SPACES       1024  /* spaces between check or radio buttons  */
#define WO_BOX          2048  /* widget is text that draws rectangle    */
#define WO_ALLOC        4096  /* widget's data will be allocated        */
#define WO_NOTAB	8192  /* in memo widget Tab causes pass control to next widget */
#define WO_ALPHA	16384 /* do not permit numbers in input widget */	

/* Form options */
#define FO_MODAL      1     /* form will be executed in modal mode */
#define FO_NOBORDER   2     /* form has not border */
#define FO_FREE       4     /* upon exit form will be deallocated */

/* Definition for no_free element of ldbfItem structure */
#define FREE_STRING  1
#define FREE_DATA    2
#define FREE_ALL     3
#define FREE_NOTHING 0

/* Definition of items for list widget */
typedef struct {
  link_list link;
  char *DrawString,no_free;         /* no_free == FREE_STRING frees DrawString */
  long Number;                      /* no_free == FREE_DATA frees Data       */
  void *Data;                       /* no_free == FREE_ALL frees Data && DrawString */
} ldbfItem;                         /* no_free == FREE_NOTHING frees nothing  */

/* Definition of items for menubar */
typedef struct ldbfMenuItem_s {
  struct ldbfMenuItem_s *prev,*next;
  char *MenuString;
  long Command;
  struct ldbfMenuItem_s *SubMenu;
} ldbfMenuItem;

/* Definition of widget */
typedef struct {
   link_list link;
   void *Owner;
   unsigned char x,y,h,w,Type;
   char *WidgetName;
   char *Data;
   void *Misc;
   ldbfList *Items;
   int Options,Palette;
   int (*eventproc)();
} ldbfWidget;

/* Internal structure for Input Widget */
typedef struct {
  char *Prompt,changed,must_free,*picture;
  int Pos,Start_Pos;
} ldbfInput_Stru;

/* Internal structure for List Widget */
typedef struct {
  void *top;         /* top visible item */
  int Start_Pos;     /* start of visible part of item */
} ldbfList_Stru;

/* Border types for form */
#define FB_DOUBLE 0         /* border's char  */
#define FB_SINGLE 1         /* border's char  */
#define FB_PANEL  2         /* border's char  */
#define FB_DUMB   3         /* emulates border via |,-,+ */

/* definition of event handler for specific event */
typedef struct {
  int Event,Command;
  char *WidgetName;
  int (*eventproc)();
} ldbfEventTable;

#define BEGIN_EVENTS(name) ldbfEventTable name[] = {
#define DEFINE_EVENT(e,c,wn,ep) {e,c,wn,ep},
#define END_EVENTS {0,0,0,0} };

/* Definition of form */
typedef struct _window {
  link_list link;
  char *FormName;
  ldbfList Widgets;
  unsigned char x,y,h,w;
  int Options,Palette;
  unsigned char Border[13],Pad;
  char *Title,*Footer;
  char *Data;                   /* you may attach any data to form */
  int (*eventproc)();           /* main procedure */
  ldbfEventTable *eventtab;     /* table of events */
  int *Screen_Buf;
} ldbfForm;

#define CTRL(x)     (x - 64)
/* Predefined keys */
#define  K_F1               1000
#define  K_F2               1010
#define  K_F3               1020
#define  K_F4               1030
#define  K_F5               1040
#define  K_F6               1050
#define  K_F7               1060
#define  K_F8               1070
#define  K_F9               1080
#define  K_F10              1090
#define  K_F11              1100
#define  K_F12              1110
#define  K_UP               1120
#define  K_DOWN             1130
#define  K_LEFT             1140
#define  K_RIGHT            1150
#define  K_PGUP             1160
#define  K_PGDN             1170
#define  K_HOME             1180
#define  K_END              1200
#define  K_DEL              1210
#define  K_INS              1220
#define  K_CTRL_Q           CTRL('Q')
#define  K_CTRL_W           CTRL('W')
#define  K_CTRL_E           CTRL('E')
#define  K_CTRL_R           CTRL('R')
#define  K_CTRL_T           CTRL('T')
#define  K_CTRL_Y           CTRL('Y')
#define  K_CTRL_U           CTRL('U')
#define  K_CTRL_I           CTRL('I')
#define  K_CTRL_O           CTRL('O')
#define  K_CTRL_P           CTRL('P')
#define  K_CTRL_A           CTRL('A')
#define  K_CTRL_S           CTRL('S')
#define  K_CTRL_F           CTRL('F')
#define  K_CTRL_D           CTRL('D')
#define  K_CTRL_G           CTRL('G')
#define  K_CTRL_H           CTRL('H')
#define  K_CTRL_J           CTRL('J')
#define  K_CTRL_K           CTRL('K')
#define  K_CTRL_L           CTRL('L')
#define  K_CTRL_Z           CTRL('Z')
#define  K_CTRL_X           CTRL('X')
#define  K_CTRL_C           CTRL('C')
#define  K_CTRL_V           CTRL('V')
#define  K_CTRL_B           CTRL('B')
#define  K_CTRL_N           CTRL('N')
#define  K_CTRL_M           CTRL('M')
#define  K_BACKSPACE        8
#define  K_TAB              9
#define  K_ENTER            13

/* The graph charset is accessed and hidden by the following macros     */
#define GC_HB(x)   (x[0])    /* Horizontal bar                       */
#define GC_VB(x)   (x[1])    /* Vertical bar                         */
#define GC_LT(x)   (x[2])    /* Left tee                             */
#define GC_RT(x)   (x[3])    /* Right tee                            */
#define GC_TT(x)   (x[4])    /* Top tee                              */
#define GC_BT(x)   (x[5])    /* Bottom tee                           */
#define GC_UL(x)   (x[6])    /* Upper left corner                    */
#define GC_LL(x)   (x[7])    /* Lower left corner                    */
#define GC_UR(x)   (x[8])    /* Upper right corner                   */
#define GC_LR(x)   (x[9])    /* Lower right corner                   */
#define GC_TG(x)   (x[10])   /* Tag sign                             */
#define GC_BOX(x)  (x[11])   /* Title's box                          */

/* if non-zero it specifies number of seconds that may be allowed
   for keyboard inactivity.After expiration of this time "timeout"
   event will be generated */
extern int ldbfWaitKey;

/* Default event handlers */
int Widget_Input_Event_Proc(ldbfWidget *widget,ldbfEvent *event);
int Widget_Button_Event_Proc(ldbfWidget *widget,ldbfEvent *event);
int Widget_List_Event_Proc(ldbfWidget *widget,ldbfEvent *event);
int Widget_Menu_Event_Proc(ldbfWidget *widget,ldbfEvent *event);
int Widget_RadioCheck_Event_Proc(ldbfWidget *widget,ldbfEvent *event);

/* default event procedure, works with system event table defined 
   by ldbfDefineFormEventTable or ldbfDefineSystemEventTable */
int ldbfSystem_Event_Proc(ldbfForm *form,ldbfEvent *event);

/* defines new form event table. Returns old event table */
ldbfEventTable *ldbfDefineSystemEventTable(ldbfEventTable *table);

/* defines new form event table. Returns old event table */
ldbfEventTable *ldbfDefineFormEventTable(ldbfForm *form,ldbfEventTable *table);

/* This function msut be called before any widget or form routine */
/* UseColors    == 1 for use Ansi terminal */
/* DumbTerminal == 1 if your terminal does not understand colors */
int ldbfInitForms(int UseColors,int DumbTerminal);

/* This function restores tty to original state */
int ldbfResetForms();

/* Reads next char from keyboard */
int ldbfGetKey();

/* Clear event structure */
void ldbfClearEvent(ldbfEvent *event);

/* Sends event to specified form */
int ldbfSendEvent(char *TargetForm,ldbfEvent *event);

/* Stores event into event queue */
void ldbfPutEvent(ldbfEvent *event);

/* Reads next available event from queue */
int ldbfGetEvent(ldbfEvent *Event);

/* Frees form and all their widgets */
void ldbfDestroyForm(ldbfForm *form);

/* Inserts form into application queue and set this form current */
void ldbfInsertForm(ldbfForm *form);

/* This is main application loop */
int ldbfRunApplication();

/* Executes form in modal mode and returns command that caused exit */
int ldbfExecForm(ldbfForm *form);

/* Creates form definition */
ldbfForm *ldbfCreateForm(char *Name,int x,int y,int w,int h,char *title,
             char *footer,int border,int options,int (*event_proc)());

/* Creates widget defintion. This is low-level function */
ldbfWidget *ldbfCreateWidget(int Type,char *Name,int x,int y,int w,int h,
                   char *data,void *misc,ldbfList *Items,int options,int palette);

/*  Returns pointer to active form */
ldbfForm *ldbfGetForm(char *form);

/* Draws vertical line */
void ldbfDrawVline(int x,int y,int len,char c);

/* Draws title of the form */
int ldbfDrawFormTitle(ldbfForm *form,int active);

/* Draws border around the form */
int ldbfDrawFormBorder(ldbfForm *form);

/* Inserts widget into form */
int ldbfInsertWidget(ldbfForm *form,ldbfWidget *widget);

/* Defines menubar of the form */
int ldbfInsertMenu(ldbfForm *form,ldbfMenuItem *items);

/* Defines DeskTop */
void ldbfCreateDesktop(int (*event_proc)(),ldbfMenuItem *items);

/* Creates text widget */
ldbfWidget *ldbfCreateTextWidget(char *Name,int x,int y,char *text,int flags);

/* Creates inputline widget */
ldbfWidget *ldbfCreateInputWidget(char *Name,int x,int y,int max,
                           char *prompt,char *data,char *picture,int options);

/* Creates listbox widget */ 
ldbfWidget *ldbfCreateListWidget(char *Name,int x,int y,int w,int h,
                       char *title,ldbfList *list);

/* Creates popup widget */ 
ldbfWidget *ldbfCreatePopupWidget(char *Name,int x,int y,int w,ldbfList *list);

/* Creates pushbutton widget */
ldbfWidget *ldbfCreateButtonWidget(char *Name,int x,int y,char *text,int comand);

/* Creates memo widget */
ldbfWidget *ldbfCreateMemoWidget(char *Name,int x,int y,int w,int h,
                           char *data,int options);

/* Fills memo buffer with data */
void ldbfPutMemoData(ldbfWidget *widget,char *data);

/* Returns size of memo buffer */
int ldbfMemoSize(ldbfWidget *widget);

/* Fills user buffer with memo buffer */
void ldbfGetMemoData(ldbfWidget *widget,char *data);

/* Returns 1 if memo was changed */
int ldbfIsMemoChanged(ldbfWidget *widget);

/* Sets memo as changed */
void ldbfSetMemoChanged(ldbfWidget *widget,int change);

/* Sets up memo display procedure */
void ldbfSetMemoLineProc(ldbfWidget *memo,void (*line)());

/* Reads data form file into memo buffer */
void ldbfMemoReadFile(ldbfWidget *widget,char *name);

/* Writes memo bufer into file */
void ldbfMemoWriteFile(ldbfWidget *widget,char *name);

/* Writes selected block into file */
void ldbfMemoWriteBlock(ldbfWidget *widget,char *name);

/* Creates rectangle widget */
ldbfWidget *ldbfCreateBoxWidget(char *Name,int x,int y,int w,int h,
                           char *border,int options);

/* Frees up widget */
int ldbfDestroyWidget(ldbfWidget *widget);

/* Redraws widget */
int ldbfDrawWidget(ldbfWidget *widget,int Selected);

/* Draws box */
void ldbfDrawBox(char *Border,int y,int x,int h,int w);

/* Draws frame around widget */
void ldbfDrawFrameList(ldbfWidget *wid,int palette,int draw);

/* Redraws widget */
void ldbfRedrawWidget(ldbfWidget *widget);

/* Redraws form */
int ldbfRedrawForm(ldbfForm *form,int OnlyWidgets);

/* Process menubar */
void ldbfProcessMenuBox(ldbfForm *form,ldbfMenuItem *items,int x,int y,int popup);

/* Creates new item definititon */
ldbfItem *ldbfNewStringItem(char *string,ldbfItem *next);

/* Creates separator line in the menu */
ldbfMenuItem *ldbfNewSeparator(ldbfMenuItem *next);

/* Creates menu item definititon */
ldbfMenuItem *ldbfNewMenuItem(char *string,int command,ldbfMenuItem *next);

/* Creates submenu definition */
ldbfMenuItem *ldbfNewSubMenu(char *string,ldbfMenuItem *item,ldbfMenuItem *next);

/* Creates new item for list widget */
ldbfItem *ldbfNewListItem(char *string,int num,void *data);

/* Creates new item for list widget with more control */
ldbfItem *ldbfNewListItemPro(char *string,int num,void *data,int how_free);

/* Creates checkbox widget */
ldbfWidget *ldbfCreateCheckWidget(char *Name,int x,int y,int position,ldbfItem *items);

/* Creates radiobutton widget */
ldbfWidget *ldbfCreateRadioWidget(char *Name,int x,int y,int position,ldbfItem *items);

/* Check out is n'th item of checkbox or radiobutton selected */
int ldbfIsCheckedItem(ldbfWidget *widget,int num);

/* Sets n'th item of checkbox or radiobutton as selected */
void ldbfSetCheckedItem(ldbfWidget *widget,int num);

/* Sets n'th item of checkbox as not selected */
void ldbfClearCheckedItem(ldbfWidget *widget,int num);

/* Returns number of selected item of radiobutton */
int ldbfSelectedItem(ldbfWidget *widget);

/* Sets specified ldbfItem as current in the list widget */
void ldbfSetCurrentListItem(ldbfWidget *widget,ldbfItem *itm);

/* Refresh all forms on the screen */
void ldbfRefreshScreen();

/* Frees ldbfList object and all items */
void ldbfFreeList(ldbfList *list);

/* Make physical screen equal internal screen  */
void ldbfRefresh();

/* Go into position with r row and c column */
void ldbfGotorc(int r,int c);

/* Write string into current position */
void ldbfWriteString(char *str);

/* Write char into current position */
void ldbfWriteChar(char c);

/* Clear screen */
void ldbfCls();

/* Select palette */
void ldbfSetPalette(int pal);

/* Makes next widget current */
void ldbfSelectNext(ldbfForm *form);

/* Makes widget current by name */
void ldbfSetCurrent(ldbfForm *form,char *widname);

/* Returns pointer to widget's data */
char *ldbfGetData(ldbfForm *form,char *widgetname);

/* Returns pointer to widget */
ldbfWidget *ldbfGetWidget(ldbfForm *form,char *widgetname);

/* Returns current widget in the form */
ldbfWidget *ldbfGetCurrent(ldbfForm *form);

/* Sets various widget options */
void ldbfSetOptions(ldbfForm *form,char *widname,int opt,int istrue);

/* Set video in normal mode */
void ldbfNormVideo();

/* Set video in reverse mode */
void ldbfRevVideo();

/* Make palette and set its colors */
void ldbfMakePalette(int pal_no,char *fore,char *back);

/* Defines sequence that generates specified command */
void ldbfDefineKey(char *sequence,int command);

/* Returns 1 if input widget was changed */
int ldbfInputChanged(ldbfWidget *input);

/* Displays message box and returns number of button pressed */
int ldbfMessageBox(char *title,char *msg,char *buttons);

/* Displays form with input line */
int ldbfInputBox(char *title,char *prompt,char *data,char *picture,int maxlen,int flags);

/* Clears all input widgets in the form */
void ldbfClearForm(ldbfForm *form);

/* Toggle element of menu to disable or enable state */
void ldbfToggleMenuItem(ldbfForm *form,int command,int disable);

/* Defines dialog for selecting file.Path will contain selected file,
   filter specified file pattern and language specified in what language
   write messages(0 - English,1 - Russian 866, 2 - Russian KOI8 */
ldbfForm *ldbfDefineDirDialog(char *path,char *filter,int language,int options);

/* Makes silly sound */
void ldbfBeep();

#endif

/* first element of list */
void LD_PTR* LD_FUNCTION list_first(ldbfList *lst);

/*last element of list */
void LD_PTR * LD_FUNCTION list_last(ldbfList *lst);

/* next element */
void LD_PTR * LD_FUNCTION list_next(ldbfList *lst,void *link);

/* prev element */
void LD_PTR * LD_FUNCTION list_prev(ldbfList *lst,void *link);

/* removes element from list */
void LD_FUNCTION list_remove(ldbfList *lst,void *link);

/* returns true if item is contained in the list */
int LD_FUNCTION list_seek(ldbfList *lst,void *link);

/* adds element to list */
void LD_FUNCTION list_add(ldbfList *lst,void *link);
void LD_FUNCTION list_add_after(ldbfList *lst,void *anchor,void *link);
void LD_FUNCTION list_add_before(ldbfList *lst,void *anchor,void *link);

/* frees list */
void LD_FUNCTION list_free(ldbfList *lst);

/* removes top element */
void *LD_FUNCTION list_pop(ldbfList *lst);

/* sets sequenced number for list's items */
void LD_FUNCTION list_set_no(ldbfList *list);

/* Delete leading and trailing trash characters from s */
char LD_PTR * LD_FUNCTION trim(char *s);

/* Returns number of words in s delimited with set of char in delim */
int LD_FUNCTION wordcnt(char *s,char *delim);

/* Returns position of n'th word */
int LD_FUNCTION wordpos(int n, char *s,char *delim);

/* Return n'th word from s and puts it into buf */
char LD_PTR * LD_FUNCTION getword(int n,char *s,char *delim,char *buf);

/*  Converts a string to a double */
double LD_FUNCTION ldbfatod( char *str, int len_str );

/* Converts a string to a integer */
int LD_FUNCTION ldbfatoi( char *str, int len_str );

/* Converts a string to a long */
long LD_FUNCTION ldbfatol( char *str, int len_str );

/* - formats a double to a string */
void LD_FUNCTION ldbfdtoa( double doub_val, char *out_buffer, int len, int dec);

/*  Converts a long to a string.  Fill with '0's rather than blanks if
    'num' is less than zero.*/
void  LD_FUNCTION ldbfltoa( long l_val, char *ptr, int num);

/*  - From CCYYMMDD to CCYY.MM.DD
    ldbfencode( to, from, "CCYY.MM.DD", "CCYYMMDD" ) ;*/
void  LD_FUNCTION ldbfencode( char *to, char *from, char *t_to, char *t_from);

/* Make all chars in the string in lower case */
void LD_FUNCTION ldbflower( char *str );
void LD_FUNCTION ldbflowerKOI( char *str );
void LD_FUNCTION ldbflowerWIN( char *str );

/* Make all chars in the string in upper case */
void  LD_FUNCTION ldbfupper( char *str );
void  LD_FUNCTION ldbfupperKOI( char *str );
void  LD_FUNCTION ldbfupperWIN( char *str );

/* converts from 866 codepage into koi8 mapping */
void LD_FUNCTION ldbfalt2koi(char *s);
/* converts from koi8 codepage into 866 codepage */
void LD_FUNCTION ldbfkoi2alt(char *s);
/* converts from koi8 codepage into Windows codepage */
void LD_FUNCTION ldbfkoi2win(char *s);
/* converts from Windows codepage into koi8 codepage */
void LD_FUNCTION ldbfwin2koi(char *s);

/* Returns 0 if str does not macth regular expression specified by pat */
int LD_FUNCTION ldbfregexp_match (char *str, char *pat);

void LD_PTR* LD_FUNCTION ldbfAlloc(long n);

void LD_FUNCTION ldbfFree(void *ptr);

#ifdef __cplusplus
  }
#endif

#endif
