import java.lang.*;
import java.applet.*;
import java.awt.*;
import java.io.*;
import java.util.StringTokenizer;
import java.util.Hashtable;
import java.util.Enumeration;
import ldbf.*;

public class Monitor extends Applet {
    public void init() {
        new ldbfMonitor();
    }

    public static void main(String args[]) {
        Monitor visualtest = new Monitor();
        visualtest.init();
	visualtest.start();
    }
}


class ldbfMonitor extends Frame
{
    boolean in_modal = false;
    MenuBar mbar = new MenuBar();
    Window current = null;
    ldbfJava ldbf = null;
    Hashtable tables = null;

        // The constructor where we initialize data
        public ldbfMonitor()
	{
                super("ldbfMonitor");
                setBackground(Color.lightGray);
                setLayout(new BorderLayout());
                resize(600,400);
                MenuItem i;
                Menu m = new Menu("Server");
                m.add(new MenuItem("Connect"));
                m.add(i = new MenuItem("Disconnect"));
                i.disable();
                m.addSeparator();
                m.add(new MenuItem("Quit"));
                mbar.add(m);
                m = new Menu("Table");
                m.add(i = new MenuItem("Structure"));
                i.disable();
                m.add(i = new MenuItem("Browse"));
                i.disable();
                mbar.add(m);
                m = new Menu("Help");
                m.add(new MenuItem("About"));
                mbar.add(m);
                setMenuBar(mbar);
                show();
	}

        void shuts()
        {
          try {
           if(ldbf != null) ldbf.Shutdown();
          } catch (Exception e) {
          }
        }

	// Handle events that have occurred
        public boolean handleEvent(Event evt)
	{
                if(in_modal) {
                  if(current != null) current.toFront();
                  return true;
                }
		switch(evt.id) {
			case Event.WINDOW_DESTROY:
			{
                           shuts();
                           dispose();
                           System.exit(0);
                           return true;
			}
			// This can be handled
			case Event.ACTION_EVENT:
			{
			  String label = evt.arg.toString();
                          if(evt.target instanceof MenuItem) {
                            if (label.equals("Connect")) {
                               ConnectDialog(this);
			       return true;
                            } else if (label.equals("Disconnect")) {
                               shuts();
                               Menu m = mbar.getMenu(0);
                               m.getItem(1).disable();        // Disconnect
                               m = mbar.getMenu(1);
                               int i;
                               for(i = 0;i < m.countItems();i++) // Table
                                  m.getItem(i).disable();
                            } else if (label.equals("Structure")) {
                               StructureDialog(this);
			       return true;
                            } else if (label.equals("Browse")) {
                               BrowseDialog(this);
			       return true;
			    } else if(label.equals("Quit")) {
                               QuitDialog(this);
                               return true;
                            } else if(label.equals("About")) {
                               MsgDialog(this,"LDBF monitor","Copyrigth (c) Nadezhda Company");
			       return true;
			    }
			}
		}
		  default:
		    return false;
		}
	}

    public void MsgDialog (ldbfMonitor parent,String msg,String msg1)
    {
        FontMetrics fnt;
        Font font = new Font("TimesRoman", Font.BOLD,14);
        fnt = getToolkit().getFontMetrics(font);
        ldbfDialog dlg = new ldbfDialog(parent," Message ",0);
        int max;
        dlg.setBackground(Color.lightGray);
        if(msg.length() > msg1.length()) 
          max = fnt.stringWidth(msg); else max = fnt.stringWidth(msg1);
        dlg.reshape(parent.bounds().x+100,parent.bounds().y+100,max+30,150);
        dlg.setLayout(new GridLayout(0,1));
        Label l = new Label (msg, Label.CENTER);
        l.setForeground (Color.red);
        l.setFont (font);
        dlg.add (l);
        l = new Label (msg1, Label.CENTER);
        l.setForeground (Color.blue);
        l.setFont (new Font ("Helvetica", Font.ITALIC, 10));
        dlg.add (l);
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        p.add("Center",new Button("OK"));
        dlg.add(p);
        dlg.show();
    } 

    public void QuitDialog (ldbfMonitor parent)
    {
        ldbfDialog dlg = new ldbfDialog(parent," Quit ",3);
        dlg.setBackground(Color.gray);
        dlg.reshape(parent.bounds().x + 200,parent.bounds().y+100,200,150);
        /* create and add to dialog labels */
        Label l = new Label ("Do you want really quit?", Label.CENTER);
        dlg.add ("Center",l);
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        p.add (new Button ("Yes"));
        p.add (new Button ("No"));
        dlg.add("South",p);
        dlg.show();
    } 

    public void StructureDialog(ldbfMonitor parent)
    {
        ldbfDialog dlg = new ldbfDialog(parent," Structure ",1);
        dlg.setBackground(Color.gray);
        dlg.reshape(parent.bounds().x + 50,parent.bounds().y+50,450,350);
        dlg.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.setLayout(new FlowLayout(0));
        Label l;
        p.add(l = new Label ("Table:"));
        dlg.tables = new List(15,false);
        if(dlg.papa.ldbf != null) {
         for(Enumeration e = dlg.papa.tables.elements();e.hasMoreElements();)
          dlg.tables.addItem((String)e.nextElement());
        }
        p.add(dlg.tables);
        dlg.add("West",p);
        p = new Panel();
        p.setLayout(new FlowLayout(0));
        p.add(l = new Label ("Structure :"));
        dlg.list = new List(15,false);
        dlg.list.setFont (new Font ("Fixed", Font.PLAIN, 15));
        dlg.list.addItem("NAME            LEN TYPE DEC");
        p.add(dlg.list);
        dlg.add("Center",p);
        p = new Panel ();
        p.setLayout(new FlowLayout());
        p.add (new Button ("OK"));
        p.add (new Button ("Cancel"));
        dlg.add("South",p);
        dlg.show();
    }

    public void UpdateDialog(ldbfMonitor parent,ldbfDialog dial)
    {
        ldbfDialog dlg = new ldbfDialog(parent," Update ",7);
        dlg.setBackground(Color.gray);
        dlg.reshape(parent.bounds().x + 50,parent.bounds().y+50,650,350);
        dlg.setLayout(new BorderLayout());
        dlg.Alias = dial.Alias; 
        dlg.dialog = dial;
        Panel p = new Panel();
        p.setLayout(new FlowLayout(0));
        Label l;
        p.add(l = new Label ("Structure :"));
        dlg.list = new List(15,false);
        dlg.list.setFont (new Font ("Fixed", Font.PLAIN, 15));
        dlg.list.addItem("NAME            LEN TYPE DEC");
        String info;
        for(int i = 1;i <= dlg.papa.ldbf.Fields(dlg.Alias.trim());i++) {
          info = dlg.papa.ldbf.FieldInfo(dlg.Alias.trim(),i);
          if(info != null)
            dlg.list.addItem(dlg.papa.ldbf.FieldInfo(dlg.Alias.trim(),i));
        }
        p.add(dlg.list);
        p.add(new Label("Field value:"));
        p.add(dlg.user = new TextField(30));
        dlg.add("Center",p);
        p = new Panel ();
        p.setLayout(new FlowLayout());
        p.add (dlg.ok = new Button ("Update"));
        p.add (dlg.upd = new Button ("Replace field"));
        p.add (new Button ("Cancel"));
        dlg.add("South",p);
        dlg.show();
    }

    public void SeekDialog(ldbfMonitor parent,String table,ldbfDialog dial)
    {
        ldbfDialog dlg = new ldbfDialog(parent," Seek ",6);
        StringTokenizer alist;
        String tbl;
        dlg.dialog = dial;
        dlg.Alias = new String(table);
        dlg.setBackground(Color.gray);
        dlg.reshape(parent.bounds().x + 60,parent.bounds().y+80,550,200);
        dlg.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.setLayout(new FlowLayout(0));
        Label l;
        p.add(l = new Label ("Tags:"));
        dlg.list = new List(5,false);
        p.add(dlg.list);
        try { 
          alist = new StringTokenizer(dlg.papa.ldbf.TagInfo(table),",",false);
          while(alist.hasMoreTokens()) {
            tbl = alist.nextToken();
            if(tbl.trim().length() > 0)
             dlg.list.addItem(tbl.trim());
          }
        } catch (Exception exp) {
        }
        p.add(l = new Label ("Seek value :"));
        p.add(dlg.user = new TextField(30));
        dlg.add("North",p);
        p = new Panel ();
        p.setLayout(new FlowLayout());
        p.add (dlg.ok = new Button ("OK"));
        dlg.ok.disable();
        p.add (new Button ("Cancel"));
        dlg.add("South",p);
        dlg.show();
    }

    public void BrowseDialog(ldbfMonitor parent)
    {
        ldbfDialog dlg = new ldbfDialog(parent," Browse ",5);
        StringTokenizer alist;
        String tbl;
        Button b;
        dlg.setBackground(Color.gray);
        dlg.reshape(parent.bounds().x + 20,parent.bounds().y+20,600,500);
        dlg.setLayout(new BorderLayout());
        dlg.add("North",dlg.Text = new Label(" Tables                     Record contents"));
        dlg.tables = new List(5,false);
        dlg.tables.setFont (new Font ("TimesRoman", Font.ITALIC, 15));
        for(Enumeration e = dlg.papa.tables.elements();e.hasMoreElements();)
          dlg.tables.addItem((String)e.nextElement());
        dlg.add("West",dlg.tables);
        dlg.list = new List(15,false);
        dlg.list.setFont (new Font ("Fixed", Font.PLAIN, 17));
        dlg.add("Center",dlg.list);
        Panel p = new Panel ();
        p.setLayout(new FlowLayout());
        p.add (new Button ("Browse"));
        p.add (dlg.np = new Button ("NextPage"));
        dlg.np.disable();
        p.add (dlg.pp = new Button ("PrevPage"));
        dlg.pp.disable();
        p.add (dlg.seek = new Button ("Seek"));
        dlg.seek.disable();
        p.add (dlg.app = new Button ("Append"));
        dlg.app.disable();
        p.add (dlg.upd = new Button ("Update"));
        dlg.upd.disable();
        p.add (new Button ("Cancel"));
        dlg.add("South",p);
        dlg.show();
    }

    public void ConnectDialog (ldbfMonitor parent)
    {
        ldbfDialog dlg = new ldbfDialog(parent,"Connect",2);
        dlg.setBackground(Color.gray);
        dlg.reshape(parent.bounds().x + 200,parent.bounds().y+100,400,350);
        dlg.setLayout(new GridLayout(0,1));
        Panel p = new Panel ();
        p.setLayout(new FlowLayout(0));
        Label l = new Label ("Server   :");
        p.add(l);
        p.add(dlg.server = new TextField (30));
        dlg.add(p);
        p = new Panel ();
        p.setLayout(new FlowLayout(0));
        p.add(l = new Label ("User     :"));
        p.add(dlg.user = new TextField (30));
        dlg.add(p);
        p = new Panel ();
        p.setLayout(new FlowLayout(0));
        p.add(l = new Label ("Port     :",Label.LEFT));
        Choice c = new Choice();
        c.addItem("Default port");
        c.addItem("Other port");
        p.add(c);
        p.add(dlg.port = new TextField (5));
        dlg.port.setText("4343");
        dlg.port.disable();
        dlg.add(p);
        p = new Panel ();
        p.setLayout(new FlowLayout(0));
        p.add(l = new Label ("Pasword:"));
        p.add(dlg.passwd = new TextField (30));
        dlg.add(p);
        p = new Panel ();
        p.setLayout(new FlowLayout());
        p.add (dlg.ok = new Button ("OK"));
        dlg.ok.disable();
        p.add(dlg.upd = new Button("Default user"));
        p.add (new Button ("Cancel"));
        dlg.add (p);
        dlg.show();
    } 


}

class ldbfDialog extends Frame
{
  int dialogType = 0;
  ldbfMonitor papa;
  ldbfDialog dialog;
  TextField   server,user,passwd,port;
  Button ok,np,pp,app,upd,seek;
  List list,tables;
  int records[];
  Label Text;
  String Alias;
  Choice choice;

    public ldbfDialog (ldbfMonitor parent,String title,int type)
    {
        super(title);
        papa = parent;
        dialogType = type;
        papa.in_modal = true;
        papa.current = this;
    }

    public void close()
    {
      papa.in_modal = false;
      papa.current = null;
      dispose();
    }

    /* For Browse dialog */
    public void UpdateButtons()
    {
     if(list.countItems() > 0) {
       Integer f = new Integer(records[0]),l = new Integer(records[list.countItems()-1]),r;
       try { 
         r = new Integer(papa.ldbf.Reccount(Alias));
       } catch (Exception exp) {
         r = new Integer(0);
       }
       Text.setText(" Tables                     Record contents: From:"+f.toString()+" To:"+l.toString()+"    Reccount:" + r.toString()+"    Current tag:"+papa.ldbf.CurrentTag(Alias));
       pp.enable();np.enable();seek.enable();
       upd.enable();app.enable();
     } else {
       Text.setText(" Tables                     Record contents");
       pp.disable();np.disable();seek.disable();
       upd.disable();app.disable();
     }
    }

    public boolean handleEvent (Event e)
    {
      String label;
      if(e.id == Event.WINDOW_DESTROY) {
         close();
         return true;
      }
      switch(dialogType) {
       case 0:  // MsgDialog
        if(e.target instanceof Button ||
           e.id == Event.KEY_PRESS ||
           e.id == Event.KEY_ACTION) {
          close();
        }
        break;
       case 2:  // ConnectDialog
        if(server.getText().length() > 0 && user.getText().length() > 0
           && port.getText().length() > 0) 
          ok.enable(); else ok.disable();
        repaint();
        switch(e.id) {
         case Event.ACTION_EVENT:
          label = e.arg.toString();
          if (e.target instanceof Choice) {
            if(label.equals("Other port")) port.enable();
            else {
              port.setText("4343");
              port.disable();
            }
            repaint();
            return true;
          }
          if (e.target instanceof Button) {
           if(label.equals("Default user")) {
             user.setText(System.getProperty("user.name"));
             user.disable();
             passwd.setText("");
             passwd.disable();
             upd.setLabel("New user");
             return true;
           } else
           if(label.equals("New user")) {
             user.setText("");
             user.disable();
             passwd.setText("");
             passwd.disable();
             upd.setLabel("New user");
             return true;
           } else
           if (label.equals ("OK")) {
               Integer code = new Integer(port.getText());
               if("Default user".equals(upd.getLabel()))
                 papa.ldbf = new ldbfJava(user.getText(),passwd.getText()); else
                 papa.ldbf = new ldbfJava();
               try {
                 if(papa.ldbf.Connect(server.getText(),code.intValue()) != -1) {
                   Menu m = papa.mbar.getMenu(0);
                   m.getItem(1).enable();            // Disconnect
                   m = papa.mbar.getMenu(1);
                   int i;
                   for(i = 0;i < m.countItems();i++) // Table
                     m.getItem(i).enable();     
                   StringTokenizer alist = new StringTokenizer(papa.ldbf.AliasList(),",",false);
                   papa.tables = new Hashtable();
                   while(alist.hasMoreTokens()) {
                    label = alist.nextToken();
                    if(label.trim().length() > 0)
                      papa.tables.put(label.trim(),label.trim());
                   }
                 } else {
                    code = new Integer(papa.ldbf.ldbfErrno);
                    papa.ldbf = null;
                 }
               } catch (Exception exp) {
                  code = new Integer(-1009);
                  papa.ldbf = null;
               }
               if(papa.ldbf == null) 
                 papa.MsgDialog(papa,"Cannot connect to host:"+server.getText(),
                    code.toString());
               close();
           }
            else if (label.equals ("Cancel")) close();
          }
        }
        break;
       case 3:  // QuitDialog
        if (e.target instanceof Button) {
         label = e.arg.toString();
         if(label.equals ("Yes")) {
           close();
           papa.shuts();
           papa.dispose();
           System.exit(0);
         }
         if(label.equals ("No")) {
           close();
         }
        }
        break;
       case 6:  // SeekDialog
        if(user.getText().length() > 0) ok.enable(); else ok.disable(); 
        if (e.target instanceof Button) {
         label = e.arg.toString();
         if(label.equals ("Cancel")) {
           close();
         }
         if(label.equals ("OK")) {
           try {
             papa.ldbf.SetTag(Alias,list.getSelectedItem());
             if(papa.ldbf.Seek(Alias,user.getText())) 
               dialog.deliverEvent(new Event(new String("Reread"),0,
                  new String(Integer.toString(papa.ldbf.Recno(Alias)))));
           } catch (Exception exp) {
           }
           close();
         }
        }
        break;
       case 7:  // UpdateDialog
        if (e.target instanceof List && e.target == list &&
          list.getSelectedIndex() > 0) {
          StringTokenizer field = new StringTokenizer(list.getSelectedItem()," ");
          String fld = (String)field.nextToken();
          user.setText(papa.ldbf.Value(Alias,fld.trim()));
          repaint();
          return true;   
        } else
        if (e.target instanceof Button) {
         label = e.arg.toString();
         if(label.equals ("Cancel")) {
           close();
         } else
         if(label.equals ("Replace field")) {
           try {
            StringTokenizer field = new StringTokenizer(list.getSelectedItem()," ");
            String fld = (String)field.nextToken();
            papa.ldbf.Replace(Alias,fld.trim(),user.getText());
            dialog.list.replaceItem(papa.ldbf.RecordBuffer(Alias),dialog.list.getSelectedIndex());
           } catch (Exception exp) {
           }
           repaint();
           return true;
         } else
         if(label.equals ("Update")) {
           try {
            papa.ldbf.Update(Alias);
           } catch (Exception exp) {
           }
           close();
         }
        }
        break;
       case 1:  // StructureDialog
          if (e.target instanceof List && e.target == tables) {
            String info,alias = ((List)e.target).getSelectedItem();
            if(alias == null) return true;
            alias = alias.replace('_',' ');
            if(list.countItems() > 0) {
              list.clear();
              list.addItem("NAME            LEN TYPE DEC");
            }
            try {
              for(int i = 1;i <= papa.ldbf.Fields(alias.trim());i++) {
                info = papa.ldbf.FieldInfo(alias.trim(),i);
                if(info != null)
                  list.addItem(papa.ldbf.FieldInfo(alias.trim(),i));
              }
            } catch(Exception exp) {
             System.out.println(exp.toString());
             list.clear();
             list.addItem("NAME            LEN TYPE DEC");
            }
            repaint();
            return true;
          }
          if (e.target instanceof Button && e.arg != null) {
           label = e.arg.toString();
           if (label.equals ("OK")) {
             close();
            } else if (label.equals ("Cancel")) close();
          }
       case 5:  // BrowseDialog
          if (e.target instanceof List && e.target == tables) {
            String info,alias = ((List)e.target).getSelectedItem();
            if(alias == null) return true;
            alias = alias.replace('_',' ');
            return true;
          }
          if (e.target instanceof String && ((String)e.target).equals("Reread")) {
             int i = 0;
             Integer rec = new Integer((String)e.arg);
             try {  
               papa.ldbf.Go(Alias,rec.intValue());
               if(papa.ldbf.ldbfErrno != 0) return true;
               records = new int[15];
               if(list.countItems() > 0) list.clear();
               while(papa.ldbf.ldbfErrno == 0 && i++ < 15) {
                 records[i-1] = papa.ldbf.Recno(Alias);
                 list.addItem(papa.ldbf.RecordBuffer(Alias));
                 papa.ldbf.Skip(Alias,1);
               }
             } catch (Exception exp) { 
               System.out.println(exp.toString());
             }
             UpdateButtons();
             repaint();
          } else
          if (e.target instanceof Button && e.arg != null) {
           label = e.arg.toString();
           if (label.equals ("Cancel")) close(); else
           if (label.equals ("Seek") && tables.getSelectedItem() != null) {
            papa.SeekDialog(papa,Alias,this);
            return true;
           } else
           if (label.equals ("Browse") && tables.getSelectedItem() != null) {
             Alias = tables.getSelectedItem();
             if(list.countItems() > 0) list.clear();
             try {
               papa.ldbf.Top(Alias);
               records = new int[15];
               int i = 0;
               while(papa.ldbf.ldbfErrno == 0 && i++ < 15) {
                 records[i-1] = papa.ldbf.Recno(Alias);
                 list.addItem(papa.ldbf.RecordBuffer(Alias));
                 papa.ldbf.Skip(Alias,1);
               }
             } catch (Exception exp) { 
               System.out.println(exp.toString());
             }
             UpdateButtons();
             repaint();
           } else if (label.equals("NextPage")) {
             try {
               papa.ldbf.Go(Alias,records[list.countItems()-1]);
               papa.ldbf.Skip(Alias,1);
               if(papa.ldbf.ldbfErrno != 0) return true;
               int i = 0;
               while(papa.ldbf.ldbfErrno == 0 && i++ < 15) {
                 for(int j = 1;j < 15;j++) records[j-1] = records[j];
                 records[list.countItems()-1] = papa.ldbf.Recno(Alias);
                 if(list.countItems() == 15) list.delItem(0);
                 list.addItem(papa.ldbf.RecordBuffer(Alias));
                 papa.ldbf.Skip(Alias,1);
               }
             } catch (Exception exp) { 
               System.out.println(exp.toString());
             }
             UpdateButtons();
             repaint();
           } else if(label.equals("PrevPage")) {
             try {
               papa.ldbf.Go(Alias,records[0]);
               papa.ldbf.Skip(Alias,-1);
               if(papa.ldbf.ldbfErrno != 0) return true;
               int i = 0;
               while(papa.ldbf.ldbfErrno == 0 && i++ < 15) {
                 for(int j = 14;j > 0;j--) records[j] = records[j-1];
                 records[0] = papa.ldbf.Recno(Alias);
                 if(list.countItems() == 15) list.delItem(list.countItems()-1);
                 list.addItem(papa.ldbf.RecordBuffer(Alias),0);
                 papa.ldbf.Skip(Alias,-1);
               }
             } catch (Exception exp) { 
               System.out.println(exp.toString());
             }
             UpdateButtons();
             repaint();
           } else if(label.equals("Append")) {
              try {
                papa.ldbf.Blank(Alias);
                papa.ldbf.Append(Alias);
                if(papa.ldbf.ldbfErrno == 0) {
                  if(list.countItems() >0) list.clear();
                  records[0] = papa.ldbf.Recno(Alias); 
                  list.addItem(papa.ldbf.RecordBuffer(Alias),0);
                }
              } catch(Exception exp) {
                System.out.println(exp.toString());
              }
              UpdateButtons();
           } else if(label.equals("Update") && list.getSelectedItem() != null) {
              try {
                papa.ldbf.Go(Alias,records[list.getSelectedIndex()]);
                if(papa.ldbf.ldbfErrno == 0) 
                  papa.UpdateDialog(papa,this);
              } catch (Exception exp) {
              }
              return true;
           }
          }
      }
      return super.handleEvent(e);
    }
}


