import java.awt.*;
import java.applet.*;
import ldbf.*;
import java.io.*;

public class CityCodes extends Applet
{
	Panel infobar;
        Choice where;
	TextField name;
        List codes;

	public void init()
	{
		setLayout(new BorderLayout());
		setBackground(Color.gray);
		setFont(new Font("Helvetica", Font.BOLD, 12));
                resize(600,400);
	}

	public void start()
	{
		Panel p = new Panel();
		p.setLayout(new BorderLayout());
                where  = new Choice();
                where.addItem("exUSSR");
                where.addItem("Over the world");

                p.add("North",new Label("           This database of city codes is offered by KharkovTelecom."));
                p.add("West",new Label("Find what:"));
		p.add("Center",name = new TextField("", 35));
                p.add("East",where);
                p.add("South",new Label(" Code     City"));

                add("North",p);

		add("Center",codes = new List());

		infobar = new Panel();
		infobar.add(new Button("Search by city"));
		infobar.add(new Button("Search by code"));
		infobar.add(new Button("Clear"));
		add("South", infobar);
	}

	public boolean action(Event evt, Object arg) 
	{
		if("Search by code".equals(arg) || "Search by city".equals(arg))
		{
                        if(codes.countItems() > 0) codes.clear();
			showStatus("Waiting ...");
                        try {
                          ldbfJava conn = new ldbfJava();
                          if(conn.Connect("localhost") != -1) {
                            String tag,db;
                            String tmp = new String(name.getText());
                            if(where.getSelectedIndex() == 0) db = new String("sng"); else
                               db = new String("foren");
                            if("Search by code".equals(arg)) tag = new String("kod"); 
                                else tag = new String("city");
                            conn.SetTag(db,tag);
                            conn.Seek(db,tmp);
                            while(conn.ldbfErrno == 0) {
                              if(!tmp.regionMatches(0,conn.Value(db,tag),0,tmp.length())) break;
                              codes.addItem(conn.Value(db,"kod")+"  " +conn.Value(db,"city"));
                              conn.Skip(db,1);
                            }
                            conn.Shutdown();
                            showStatus("Records received:" + Integer.toString(codes.countItems()));
                          } else showStatus("Cannot connect to LDBF server!");
                        } catch (Exception e) {
                           showStatus("Network error!");
                           return true;
                        }
			return true;
		}
		else if("Clear".equals(arg))
		{
			name.setText("");
                        if(codes.countItems() > 0) codes.clear();
			return true;
		}
		return false;		
	}

}
