#include <stdio.h>
#include "ldbf.h"

/*
   Structure of example 'sng' table
    kod  C 6  0       - code of city
    city C 30 0       - name of city
    state C 30 0      - country
*/

main()
{
  int sock;
  ldbfDB *sng;
  if((sock = ldbfConnect("localhost")) == -1) {
    printf("Cannot connect:%d\n",ldbf_errno);
    exit(0);
  }
  sng = ldbfOpen(sock,"sng",0);
  if(!sng) {
   printf("Cannot open sng:%d\n",ldbf_errno);
   ldbfShutdown(sock);
   exit(0);
  }
  /* we want to update field 'state' in all records */

  /* sets on top of table */
  ldbfTop(sng);
  /* scan thru all records */
  while(!ldbf_errno) {
    /* print contents of fields */
    printf("%s",ldbfValue("sng","kod"));
    printf("%s \n",ldbfValue("sng","city"));

    ldbfReplace("sng","state","Ukraine");
    ldbfUpdate(sng);

/* alternatively, this may be done also with ldbfModify function */
/*  ldbfModify(sock,"sng","state","Ukraine"); */

    /* Pass to next record, if we did not reach end of table  */
    if(ldbfSkip(sng,1) == -1) break;
  }
  ldbfShutdown(sock);
}
