#include <stdio.h>
#include <stdlib.h>
#include "ldbf.h"

extern		ldbf_errno;

void main ()
{
	int		ldbfsock = 0;
	ldbfDB		*dbase = NULL;
	ldbfFIELDINFO	field_info[] = {
				{"CONTRACT", 'C', 10, 0},
				{"CUSTOMER", 'C', 40, 2},
				{"CATEGORY", 'N', 1, 0}, /* 1=VIP(MICEX),2=PARTNER,3=OTHER */
				{"ORDERNUM", 'C', 10, 0},
					/* Address Part */
				{"POSTIDX", 'N', 6, 0},
				{"CITY", 'C', 20, 0},
				{"STREET", 'C', 40, 0},
				{"HOUSE", 'C', 5, 0},
				{"OFFICE", 'C', 30, 0},
				{"CT_TECH", 'C', 30, 0},
				{"CT_CMRC", 'C', 30, 0},
					/* Accounts Payable Part */
				{"PAY_CONT", 'C', 40, 0},
				{"PAY_PHONE", 'C', 20, 0},
				{"PAY_ADDR", 'C', 40, 0},
				{"PAY_CURR", 'C', 20, 0},
				{"BANK", 'C', 40, 0},
				{"BANK_ADDR", 'C', 40, 0},
				{"CRED_CARD", 'C', 40, 0},
				{"TYPE", 'C', 40, 0},
				{"EXPIRATION", 'D', 8, 0},
					/* Service Ordering Part */
				{"GDC_TYPE", 'N', 1, 0}, /* 1=IPoverX25, 2=SyncPort, 3=AsyncPort, 4=FrameDelay */
				{"LINE_TYPE", 'N', 1, 0}, /* 1=Sync, 2=Async */
				{"LINE_SPEED", 'N', 5, 1}, /* In KiloBits */
				{"LINE_PROTO", 'N', 1, 0}, 
				{"LINE_PROV", 'N', 1, 0}, /* 1=Copper, 2=GL, 3=MacomNet, 4=ComCor */
					/* Channel Equipment */
				{"CH_EQUIP", 'N', 1, 0}, /* 1=IDNX, 2=FCD24, 3=FCD2, 4=SRM, 5=DialUp, 6=CSU/DSU */
					/* Customer's Equipment */
				{"CUST_EQUIP", 'C', 20, 0},
					/* Routing */
				{"ROUTING", 'N', 1, 0}, /* 1=Static, 2=BGP */
				{"ASNUM", 'N', 5, 0},
				{"CONNECTIV", 'N', 1, 0}, /* 1=RoSprint, 2=CIS, 3=Intl */
					/* Additional Services */
				{"DNS", 'N', 1, 0}, /* 0=No, 1=Primary, 2=Secondary */
				{"DOMAIN", 'C', 20, 0},
				{"REVERSE", 'C', 20, 0},
				{"SPARE_DOM", 'C', 20, 0},
				{"USENET", 'N', 1, 0}, /* 0=No, 1=Yes */
				{"NEWSSERV", 'C', 15, 0}, /* IP Addr */
				{"FEED", 'N', 1, 0}, /* 1=Full Feed, 2=Partial Feed */
				
				{ NULL }
			};
	ldbfTAGINFO		tag_info[] = {
				{ NULL }
			};
	

	if ((ldbfsock = ldbfConnect ("localhost")) == -1) {
		fprintf (stderr, "can't connect to server. error code = %d\n", ldbf_errno);
		exit (1);
	}
	if (!(dbase = ldbfCreate (ldbfsock, "db", field_info, tag_info))) {
		fprintf (stderr, "can't create table. error code = %d\n", ldbf_errno);
                ldbfShutdown(ldbfsock); 
		exit (1);
	}
	ldbfCloseall (ldbfsock);
	ldbfShutdown (ldbfsock);
	exit (0);
}
