#include <stdio.h>     
#include <signal.h>
#include "ldbf.h"
#include <fcntl.h>
#include  <sys/types.h>
#include  <sys/stat.h>
static int sock=-1;
extern int ldbf_errno;
int _stklen = 16384;

long filelength( int hand )
{
  struct stat   str_stat ;
  if (fstat( hand, &str_stat ) ) return -1;
  return( (long) str_stat.st_size ) ;
}

void sigHandler(int sig)
{
   printf("Received signal %d on socket %d\n",sig,sock);
   ldbfShutdown(sock);
   ldbfNetShut();
   exit(0);
}

void event_proc(char *event,char *data)
{
   printf("\nEvent %s : %s was received\n",event,data);
}

void resultfunc(long count)
{
  ldbfRESULT *res;
  ldbfDB *tbl;
  if(!count) printf("Not result\n");
  while((res = ldbfFetchResult())) {
   if(!strlen(res->alias)) 
    printf("Just data:%s\n",res->data); else {
    tbl = ldbfTableByName(res->alias);
     printf("Table %s, record %ld %s\n",tbl ? tbl->alias : "not opened",
     res->recno,res->data);
   }
  }
}

main(argc,argv)
	int	argc;
	char	*argv[];
{
	int	count,ok=0,i;
	char	buf[60],ss[50],comm[30],dbname[50],*memobuf,*host;
        ldbfDB      *data = 0;
        ldbfTAGINFO *taginfo;

   signal(SIGINT,sigHandler);
   memset(dbname,0,sizeof(dbname));
   ldbfEventHandler(event_proc);
   while(strcmp("quit",ss) != 0) { 
     ldbfCheckEvent(sock); 
     printf("\nStatus:%d:%d %s\n",ok,ldbf_errno,ldbfErr_Text(ldbf_errno));
     ok = ldbf_errno = 0; 
     memset(ss,0,sizeof(ss));
     memset(comm,0,sizeof(comm));
     memset(buf,0,sizeof(buf));
     printf("ldbf>");gets(ss);
     getword(1,ss," ",comm); 
     trim(comm);
     if(!strcmp(ss,"help") || !strcmp(ss,"?")) {
      printf("Available commands:\n");
      printf(" port tcpport  - set port server listen on \n\
 user name - set username\n\
 passwd psw - set password\n\
 connect host - connect to ldbf server on host \n\
 open databasename [EXCL] - open database \n\
 list - get list of available databases\n\
 print - print content of current record  \
 append  - add new empty record at \n\
           the end of database           close - close database\n\
 call - call server kept procedure       stru - show structure of database\n\
 taginfo - show all index tags           tag tagname - select active tag\n\
 top - top of the table                  bottom - bottom of the table\n\
 goto recnumber- go to specified record  seek value - seek record using \n\
                                                    current active tag\n\
 delete - delete current record          recall - undelete current record \n\
 replace field value - replace field of\n\
                        current record\n\
 skip recnumber - skip specified number of records \n\
 status - print status of database   update - update changed record\n\
 lock - locks current record         unlock - unlocks current record\n\
 flock - locks entire database       funlock - unlocks database\n\
 zap - zaps database                 begin - start transaction\n\
 abort - abort transaction           commit - commit transaction\n\
 register - register for receiving event  raise - raise event\n\
 setdelete - set deleted on|off\n\
 position - get position              setpos - set position\n\
 exchange - exchange database file\n\
 getmemo - reads memo contents to file memo.txt \n\
 setmemo - reads memo contents from file\n\
 quit - quit from LldbfDBF client\n");
       continue;
     }
     if(!data && strcmp(comm,"open") && strcmp(comm,"quit") &&
       strcmp(comm,"call") && strcmp(comm,"port") && strcmp(comm,"user") &&
       strcmp(comm,"passwd") &&
       strcmp(comm,"connect") && strcmp(comm,"list")) {
       printf("Database must be opened before\n");
       continue;
     }
     if(!strcmp(comm,"port")) {
        if(wordcnt(ss," ") < 2) {
          printf("Enter port number:");
          gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        ldbfPort(atol(buf));
        continue;
     }
     if(!strcmp(comm,"user")) {
        if(wordcnt(ss," ") < 2) {
          printf("Enter user name:");
          gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        ldbfUserName(buf);
        continue;
     }
     if(!strcmp(comm,"passwd")) {
        if(wordcnt(ss," ") < 2) {
          printf("Enter user password:");
          gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        ldbfPassword(buf,0);
        continue;
     }

     if(!strcmp(comm,"connect")) {
        if(wordcnt(ss," ") < 2) {
          printf("Enter host name :");
          gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(!strcmp(buf,"0")) host = 0; else host = buf;        
        sock = ldbfConnect(host);
        continue;
     } 
     if(strcmp(comm,"list") == 0) {
       printf("%s\n",ldbfAliasList(sock));
       printf("\n '-' before alias means read-only access\n");
       continue;
     }
     if(strcmp(comm,"open") == 0 && !data) {
        if(wordcnt(ss," ") < 2) {
          printf("Enter name of database:");
          gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(strstr(ss,"EXCL")) i = O_EXCL; else i = 0; 
        data = ldbfOpen(sock,buf,i);
        if(data) {
          strcpy(dbname,buf);
          if(i == O_EXCL) printf("%s opened in exclusive mode\n",dbname);
        }
        continue;
     }
     if(strcmp(comm,"replace") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter name of field to replace:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        } 
        if(wordcnt(ss," ") < 3) {
           printf("Enter new value of field:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        }
        getword(2,ss," ",buf);
        getword(3,ss," ",comm);
        trim(buf); 
        ldbfReplace(dbname,buf,comm);
        continue;
    }
     if(strcmp(comm,"getmemo") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter name of memo field:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        } 
        getword(2,ss," ",buf);
        trim(buf); 
        if((memobuf = ldbfMemoValue(data,buf,&i)) != 0) {
          FILE *memof = fopen("memo.txt","w");
          fwrite(memobuf,i,1,memof);
          fclose(memof);
        }
        continue;
    }
     if(strcmp(comm,"setmemo") == 0) {
        int memof;
        char *memobuf;  
        if(wordcnt(ss," ") < 2) {
           printf("Enter name of memo field:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        } 
        if(wordcnt(ss," ") < 3) {
           printf("Enter name of file:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        } 
        getword(2,ss," ",buf);
        getword(3,ss," ",comm);
        trim(buf);trim(comm);
        memof = open(comm,O_RDONLY);
        if(memof) {
          i = filelength(memof);
          memobuf = (char*)calloc(1,i+1);
          read(memof,memobuf,i);
          close(memof);
          ldbfReplaceMemo(data,buf,memobuf,i);
          free(memobuf);
        } else printf("File %s cannot be opened\n",comm);
        continue;
     }
     if(strcmp(comm,"exchange") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter alias:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        } 
        if(wordcnt(ss," ") < 3) {
           printf("Enter path:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        }
        getword(2,ss," ",buf);
        getword(3,ss," ",comm);
        trim(buf); 
        ldbfExchange(sock,buf,comm);
        continue;
    }
     if(strcmp(comm,"setdelete") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter on or off:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        ldbfSetOnOff(sock,SET_DELETED,!strcmp(buf,"on")?1:0);
        continue;
    }
   if(strcmp(comm,"setpos") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter position:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        ldbfPositionSet(data,atoi(buf));
        continue;
    }
     if(strcmp(comm,"skip") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter number of records to skip:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(atol(buf) == 0) continue;
        ok = ldbfSkip(data,atol(buf));
        continue;
    }
     if(strcmp(comm,"top") == 0) {
        ok = ldbfTop(data);
        continue;
    }
     if(strcmp(comm,"bottom") == 0) {
        ok = ldbfBottom(data);
        continue;
    }
     if(strcmp(comm,"register") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter event to register:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(strlen(buf) == 0) continue;
        ldbfRegisterEvent(sock,buf);
        continue;
    }
     if(strcmp(comm,"raise") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter event to raise:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(strlen(buf) == 0) continue;
        ldbfRaiseEvent(sock,buf,0);
        continue;
    }
     if(strcmp(comm,"tag") == 0) {
        if(wordcnt(ss," ") < 2) {
          printf("Enter name of tag to select:");
          gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        strcpy(data->tag,buf);
        continue;
     }
     if(strcmp(comm,"lock") == 0) {
        ok = ldbfLock(data,data->recno);
        continue;
    }
    if(strcmp(comm,"flock") == 0) {
        ok = ldbfFlock(data);
        continue;
    }
    if(strcmp(comm,"close") == 0) {
        ldbfClose(data);
        data = 0;
        continue;
    }
     if(strcmp(comm,"goto") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter number of record:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        if(atol(buf) <= 0) continue;
        ok = ldbfGo(data,atol(buf));
        continue;
    }
     if(strcmp(comm,"call") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter procedure name:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        } 
        comm[0] = '\0';
        if(wordcnt(ss," ") < 3) {
           printf("Enter parameters:");
           gets(buf);
           strcat(ss," ");strcat(ss,buf);memset(buf,0,sizeof(buf));         
        }
        getword(2,ss," ",buf);
        getword(3,ss," ",comm);
        if(strlen(buf) == 0) continue;
        ok = ldbfCall(sock,buf,comm,resultfunc);
        continue;
    }
     if(strcmp(comm,"seek") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter data for seek:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        ok = ldbfSeek(data,buf);
        continue;
     }
     if(strcmp(comm,"append") == 0) {
        ok = ldbfAppend(data);
        continue;
     }
     if(strcmp(comm,"unlock") == 0) {
        ldbfUnlock(data,data->recno);
        continue;
     }
     if(strcmp(comm,"zap") == 0) {
        ldbfZap(data);
        continue;
     }
     if(strcmp(comm,"funlock") == 0) {
        ldbfFunlock(data);
        continue;
     }
     if(strcmp(comm,"delete") == 0) {
        ok = ldbfDelete(data);
        continue;
     }
     if(strcmp(comm,"update") == 0) {
        ok = ldbfUpdate(data);
        continue;
     }
     if(strcmp(comm,"recall") == 0) {
        ok = ldbfRecall(data,data->recno);
        continue;
     }
     if(strcmp(comm,"double") == 0) {
        if(wordcnt(ss," ") < 2) {
           printf("Enter field:");
           gets(buf);
        } else {
          getword(2,ss," ",buf);
          trim(buf); 
        }
        printf("Double:%10.1.f\n",ldbfDoubleValue(dbname,buf));
        continue;
     }
     if(strcmp(comm,"begin") == 0) {
        ldbfBegin(sock);
        continue;
     }
     if(strcmp(comm,"abort") == 0) {
        ldbfAbort(sock);
        continue;
     }
     if(strcmp(comm,"commit") == 0) {
        ok = ldbfCommit(sock);
        continue;
     }
     if(strcmp(comm,"print") == 0) {
        printf("\n%s\n",data->record);
        continue;
     }
     if(strcmp(comm,"position") == 0) {
        printf("\nCurrent position:%d\n",ldbfPosition(data));
        continue;
     }
     if(strcmp(comm,"status") == 0) {
       printf("%s current:%ld reccount:%ld\n",dbname,data->recno,data->reccount);
       continue;
     }
     if(strcmp(comm,"stru") == 0) {
        printf("alias:%s record width:%ld reccount:%ld\n",
                  dbname,data->record_width,data->reccount);
        printf(" NAME          TYPE   LEN   DEC   OFFSET\n"); 
        printf("-----------------------------------------------------------------------\n");
        for(i=0;i<data->n_fields;i++) {
         printf("%-11s    %c    %3d     %3d   %3d\n",data->fields[i].name,
                 data->fields[i].type,
                 data->fields[i].len,data->fields[i].dec,data->fields[i].offset);
        }
        printf("NAME        EXPRESSION         FILTER        UNIQUE   DESCENDING\n");
        printf("----------------------------------------------------------------------\n");
        taginfo = (ldbfTAGINFO *)data->tags;
        if(!taginfo) taginfo = ldbfTaginfo(data);
        if(taginfo)
        for(i=0;i<data->n_tags;i++) {
         printf("%s  %s  %s  %2d %2d\n",taginfo[i].name,taginfo[i].expression, 
                taginfo[i].filter,taginfo[i].unique,taginfo[i].descending);
        }
        continue;
     }
     if(strcmp(comm,"taginfo") == 0) {
        printf("NAME        EXPRESSION         FILTER        UNIQUE   DESCENDING\n");
        printf("----------------------------------------------------------------------\n");
        taginfo = (ldbfTAGINFO *)data->tags;
        if(!taginfo) taginfo = ldbfTaginfo(data);
        if(taginfo)
        for(i=0;i<data->n_tags;i++) {
         printf("%s  %s  %s  %2d %2d\n",taginfo[i].name,taginfo[i].expression, 
                taginfo[i].filter,taginfo[i].unique,taginfo[i].descending);
        }
        continue;
     }
   }
   if(strcmp(comm,"quit") == 0) {
     ldbfCloseall(sock);
     ldbfShutdown(sock);
   }
   ldbfNetShut();
   exit(0);
}

