variable db,recno,oper,mfile,str,reccount,
         field,field_list,tag,html,values_list;

% function for seek for record
% this is user function
% i use subsequent scan, but you may implement it using index
define FindRecord(field_list)
{
   variable name,email;
   name = getword(1,field_list,",");    % get name
   email = getword(2,field_list,",");   % get email or URL
   if(recno == 0) ldbfTop(db,tag);
   while(ldbferrno == 0) {
     if( (strlen(name)) and (is_substr(ldbfStr(db,"name"),name)) or
         (strlen(email)) and (is_substr(ldbfStr(db,"email"),email))) break;
     ldbfSkip(db,tag,1);
   }  
   if(ldbferrno == 0) recno = ldbfRecno(db);
}

ldbfPort(7979);                   %  use port server waits on
ldbfServerID(0);                  %  set server's ID
if(ldbfConnect("localhost") > 0) {
  ldbfSetOnOff(2,1);                           % do not show deleted records
  oper = ldbfGetCGIValue("action");            % get operation
  tag = ldbfGetCGIValue("tag");                % get current tag
  db = "visit";                                % set database
  html = "/usr/local/httpd/htdocs/visit.html"; % set path to html page
  recno = integer(ldbfGetCGIValue("recno"));   % get current record
  if(recno > 0) ldbfGo(db,recno);              % goto current record
  reccount = ldbfReccount(db);
  if(ldbferrno) {
    ldbfPuts("<H1>Error occured during navigation</H1>\n");
    ldbfPuts(Sprintf("<H2>%d:%s:%s</H2>\n",ldbferrno,db,ldbfErr_Text(ldbferrno),3));
    ldbfExit();
  }
  field_list = ldbfGetFieldList(db);           % get list of fields 
  values_list = ldbfConstructValues(db);       % get list of values
  switch(oper)                                 % check out operation
  { not(strcmp((),"Add")):
       ldbfInsert(db,field_list,values_list);
  }
  { not(strcmp((),"Update")):    % empty fields won't be changed
       if(recno > 0) ldbfUpdate(db,field_list,values_list);
  }
  { not(strcmp((),"Next")):
        if(recno > 0) ldbfSkip(db,tag,1);
  }
  { not(strcmp((),"First")):
        if(reccount > 0) ldbfTop(db,tag);
  }
  { not(strcmp((),"Last")):
        if(reccount > 0) ldbfBottom(db,tag);
  }
  { not(strcmp((),"Prev")):
        if(recno > 0) ldbfSkip(db,tag,-1);
  }
  { not(strcmp((),"Find")):
       if(reccount > 0) FindRecord(ldbfConstructValues(db));
  }
  { not(strcmp((),"Delete")):
       if(recno > 0) {
         ldbfDelete(db);
         ldbfSkip(db,tag,1);
         if(ldbferrno) ldbfSkip(db,tag,-1);
       }
  }
  { pop():
       ldbfPuts(Sprintf("<H1>Unknown command %s %s</H1>\n",oper,db,2));
       ldbfExit();
  }
  if(ldbferrno == 0) 
    recno = ldbfRecno(db);                   % save new record position
  else {
   ldbfPuts("<H1>Cannot execute command</H1>\n");
   ldbfPuts(Sprintf("<H2>%d:%s</H2>\n",ldbferrno,ldbfErr_Text(ldbferrno),2));
   ldbfExit();
  }
  % Reconstruct html page inluding new record position and record contents
  mfile = fopen(html,"r");
  if(mfile) {
    while(fgets(mfile) > 0) {
      =str;
      field = ldbfGetHTMLValue(str,"NAME",field_list);
      if(is_substr(str,"line3.gif"))       % insert number of records
       ldbfPuts(Sprintf("<B>There are (%d) visitors in our database.</B><BR>\n%s\n",reccount,str,2)); 
      else if(strlen(field))        % set record contents for this field
       ldbfPuts(ldbfReplaceHTMLValue(str,"VALUE",ldbfStr(db,field)));
      else
      if(strlen(ldbfGetHTMLValue(str,"NAME","recno")))   % change current record
       ldbfPuts(ldbfReplaceHTMLValue(str,"VALUE",string(recno)));
      else if(is_substr(ldbfStr(db,"email"),"http://")) {
        if(is_substr(str,"HREF=\"visit.html\""))  % replace visitor's URL if exists
          ldbfPuts(ldbfReplaceHTMLValue(str,"HREF",ldbfStr(db,"email"))); 
          else ldbfPuts(str);
      } else
        ldbfPuts(str);
    }
    fclose(mfile);pop();
  } else ldbfPuts("<H1>Cannot process html file</H1>\n");
} else {
  ldbfPuts("<H1>Cannot connect to LDBF server</H1><BR>\n\n\n");
  ldbfPuts(ldbfErr_Text(ldbferrno));
}

