proc widgetResizeEnter { w } {
	global sld
	set sld(savedCursor) [lindex [$w config -cursor] 4]
}
		
proc widgetResizeLeave { w } {
	global sld
	$w config -cursor $sld(savedCursor)
}
		
proc widgetResizeStart { w x y} {
	global sld
#	snap x y
	if {$y > ([winfo height $w]-10) } {
		if {$x > ([winfo width $w]-10) } {
			$w config -cursor sizing
			set sld(rsizOp) 1
			return
		}
	}
	$w config -cursor $sld(savedCursor)
	set sld(rsizOp) 0
}
		
proc widgetResizeMove { w x y X Y } {
	global sld
#	snap x y
	snap X Y  
	if {$sld(rsizOp) == 0} { 
		.c move $sld(obj) [expr $X-$sld(x0)] [expr $Y-$sld(y0)]
		set sld(x0) $X
		set sld(y0) $Y
	} {
		set fnt [lindex [$w config -font] 4]
		$w config -width [expr $x/[font measure $fnt n]]
	}
}
		
proc widgetResizeEnd { w x y X Y } {
	global sld
	snap x y
	snap X Y  
	if {$sld(rsizOp) == 0} {
		.c move $sld(obj) [expr $X-$sld(x0)] [expr $Y-$sld(y0)]
 	} {
		widgetResizeMove $w $x $y 0 0
		$w config -cursor $sld(savedCursor)
	}
}
		
proc widgetMoveStart { w X Y } {
	global sld
	snap X Y  
	set sld(x0) $X
	set sld(y0) $Y
	set sld(obj) $w
	if {$sld(rsizOp) == 0} {
		$w config -cursor fleur 
	}
}

proc insertWidgetDone { typ x y } {
	global sld
	snap x y
	set t [.msg.e get]
	if {$t == ""} { destroy .msg; return }
	switch $typ {
		entry {
			entry .c.$t -fg $sld(foreground) -bg $sld(fillcolor)
		}
		button {
			button .c.$t -text $t -cursor hand2\
				-fg $sld(foreground) -bg $sld(fillcolor)
		}
	}
	set fnt [lindex [.c.$t configure -font] 4]
	.c.$t config -width [expr ($x - $sld(x0))/[font measure $fnt n]]
	set sld(obj) [.c create window $sld(x0) $sld(y0) \
			-anchor nw -window .c.$t -tags .c.$t]
	setWidgetBindings .c.$t
	destroy .msg
}

proc insertWidgetEnd { typ x1 y1 } {
	.c delete rubberband
	toplevel .msg
	wm transient .msg .
	label .msg.l -text "Escolha um nome para este widget:"
	entry .msg.e -width 30
	pack .msg.l .msg.e -side top
	centerWindow .msg
	raise .msg
	focus .msg.e
	bind .msg.e <Return> "insertWidgetDone $typ $x1 $y1"
}

proc insertWidgetMove { typ x y } {
	global sld
	snap x y
	.c delete rubberband
	set y1 [expr $sld(y0) + $sld(fontsize)]
	.c create rectangle $sld(x0) $sld(y0) $x $y1 -outline $sld(foreground) \
		-width 1 -tags rubberband
}

proc objectResize { x y } {
	global sld
	snap x y
	set obj [.c find closest $x $y]
	set xy [.c coords $obj]
	set dx [expr [lindex $xy 2] - 10]
	set dy [expr [lindex $xy 3] - 10]
	if {([llength $xy] == 4) && ($y > $dy) && ($x > $dx)} {
		.c config -cursor sizing
		set sld(Resizing) 1
	} {
		.c config -cursor left_ptr
		set sld(Resizing) 0
	}
}

proc objectMove {x y} {
	global sld
	snap x y
	set xy [.c coords $sld(obj)]
	if {($sld(Resizing) == 0) || ([llength $xy] != 4)} {
		.c move $sld(obj) [expr $x - $sld(x0)] [expr $y - $sld(y0)]
		set sld(x0) $x
		set sld(y0) $y
	} {
		.c coords $sld(obj) [lindex $xy 0] [lindex $xy 1] $x $y
	}
}

proc objectStartMove {x y} {
	global sld
	snap x y
	set sld(x0) $x
	set sld(y0) $y
	set sld(obj) [.c find closest $x $y]
	set sld(savedCursor) [lindex [.c config -cursor] 4]
	.c config -cursor fleur
	.c bind $sld(obj) <B2-Motion> {objectMove %x %y} 
}

proc objectSelectAdd {x y} {
	global sld
	snap x y
	set e [.c find closest $x $y]
	set n 0
	foreach i $sld(group) {
		if {$i == $e} {
			set list1 [lrange $sld(group) 0 [expr $n-1]]
			set list2 [lrange $sld(group) [expr $n+1] end]
			set sld(group) [concat $list1 $list2] 
			return
		}
		incr n		
	} 
	lappend sld(group) [.c find closest $x $y]
}

proc insertTextdone {x y} {
	global sld boxedtext
	snap x y
	set t [.text get]
	if {$boxedtext} {
		set sld(obj) [.c create text $x $y -anchor nw -text $t -font \
			[list $sld(fontfamily) $sld(fontsize)] \
			-fill $sld(foreground) -width $sld(textwidth) \
			-justify $sld(txtalign)]
	} {
		set sld(obj) [.c create text $x $y -anchor sw -text $t -font \
			[list $sld(fontfamily) $sld(fontsize)] \
			-fill $sld(foreground) -justify $sld(txtalign)]
	}
	destroy .text
}

proc insertText {x y} {
	global sld
	snap x y
	entry .text
	bind .text <Return> "insertTextdone $x $y" 
	pack .text -side bottom -after .c -fill x -expand 1
	focus .text
	bind .text <Leave> {destroy .text}
}

proc insertTextMark {x y} {
	global sld boxedtext
	snap x y
	set sld(x0) $x
	set sld(y0) $y
	if {$boxedtext == 0} {
		insertText $x $y
	}
}

proc insertTextDrag {x y} {
	global sld boxedtext
	snap x y
	if {$boxedtext} {
		.c delete rubberband
		.c create rectangle $sld(x0) $sld(y0) $x $y -outline $sld(foreground) \
			-tags rubberband
	}
}

proc insertTextLimit {x y} {
	global sld boxedtext
	snap x y
	if {$boxedtext} {
		.c delete rubberband
		set sld(textwidth) [expr $x - $sld(x0)]
		insertText $sld(x0) $sld(y0)
	}
}

proc insertLineEnd {x y} {
	global sld
	snap x y
	.c delete rubberband
	set sld(obj) [.c create line $sld(x0) $sld(y0) \
		$x $y -fill $sld(foreground) \
		-width $sld(lwidth)]
}

proc insertLineMove {x y} {
	global sld
	snap x y
	.c delete rubberband
	.c create line $sld(x0) $sld(y0) $x $y -fill $sld(foreground) \
		-width $sld(lwidth) -tags rubberband
}

proc insertLine {x y} {
	global sld
	snap x y
	.c config -cursor lr_angle
	set sld(x0) $x
	set sld(y0) $y
}

proc insertBoxEnd {x y} {
	global sld fillbox
	snap x y
	.c delete rubberband
	if {$fillbox} {
		set sld(obj) [.c create rectangle $sld(x0) $sld(y0) \
			$x $y -outline $sld(foreground) \
			-fill $sld(fillcolor) -width $sld(lwidth)]
	} {
		set sld(obj) [.c create rectangle $sld(x0) $sld(y0) \
			$x $y -outline $sld(foreground) \
			-width $sld(lwidth)]
	}
}

proc insertBoxMove {x y} {
	global sld
	snap x y
	.c delete rubberband
	.c create rectangle $sld(x0) $sld(y0) $x $y -outline $sld(foreground) \
		-width $sld(lwidth) -tags rubberband
}

proc groupObjects {} {
	global sld
}

proc ungroupObjects {} {
	global sld
}

proc setCursor {c} {
	global sld
	set sld(cursor) $c
	.c config -cursor $c
}

