proc copyObject {} {
	global sld
	set i $sld(obj)
	set sld(cutbuffer) [describeObj $i]
}

proc pasteObject {} {
	global sld
	eval $sld(cutbuffer)
}

proc cutObject {} {
	global sld
	if {[.c type $sld(obj)] == "window"} {
		destroy [.c itemcget $sld(obj) -window]
	} {
		copyObject
	}
	catch {.c delete $sld(obj)}
}

proc frontObject {} {
	global sld
	.c raise $sld(obj)
}

proc backObject {} {
	global sld
	.c lower $sld(obj)
}

proc fileNew {} {
	global frm frmv rel relvar qry
	catch {unset frm}
	catch {unset frmv}
	catch {unset rel}
	catch {unset relvar}
	catch {unset qry}
	.c delete all 
	foreach w [winfo children .c] {
		destroy $w
	}
}

proc fileSave {} {
	global frm frmv sld rel base qry
	set fd [open [tk_getSaveFile] w]
	puts $fd "dbConnect $sld(db)"
	if {[info exists base]} {
		puts $fd "set base $base" 
	}
	foreach i [array names frm] {
		puts $fd "set frm($i) [list $frm($i)]"
	}
	foreach i [array names frmv] {
		puts $fd "set frmv($i) [list $frmv($i)]"
	}
	foreach i [array names rel] {
		puts $fd "set rel($i) [list $rel($i)]"
	}
	foreach i [array names qry] {
		puts $fd "set qry($i) [list $qry($i)]"
	}
	foreach w [winfo children .c] {
		set type [string tolower [winfo class $w]]
		set opts ""
		foreach opt [$w config] {
			if {([llength $opt] < 5) ||
				([lindex $opt 4] == [lindex $opt 3]) ||
				[option get $w [lindex $opt 1] [lindex $opt 2]] \
				== [lindex $opt 4]} {
					continue
			} 
			append opts \  [lindex $opt 0] \ \{[lindex $opt end]\}
		} 
		puts $fd "$type $w $opts"
	}
	foreach i [.c find all] {
		puts $fd [describeObj $i]
	}
	close $fd
}

proc fileLoad {} {
	global sld frm frmv rel base qry
	foreach w [winfo children .c] {
		destroy $w
	}
	source [tk_getOpenFile]
	foreach w [winfo children .c] {
		setWidgetBindings $w
	}	
	set sld(ntuplas) 0
}

proc filePrint {} {
	global sld frm pr
	foreach w [array names frm] {
		.c create text [winfo x $w] [winfo y $w] \
			-anchor nw \
			-fill [lindex [$w config -fg] 4] \
			-text [$w get] -justify [lindex [$w config -justify] 4] \
			-font [lindex [$w config -font] 4] \
			-tags print -width 0  
	}
	getPrintOptions
}

proc fileExport {} {
	toplevel .exp
	wm transient .exp .
	frame .exp.f
	radiobutton .exp.f.eps -text "Encapsulated PostScript" \
		-variable fmt -value eps
	radiobutton .exp.f.xfig -text XFig -variable fmt -value xfig \
		-state disabled
	radiobutton .exp.f.xpm -text xpm -variable fmt -value xpm \
		-state disabled
	.exp.f.eps invoke
	pack .exp.f.eps .exp.f.xfig .exp.f.xpm -side left
	frame .exp.f1
	checkbutton .exp.f1.z -text gzipped -variable gzipped
	entry .exp.f1.fn -width 40
	pack .exp.f1.z .exp.f1.fn -side left
	frame .exp.f2
	button .exp.f2.export -text export -command {
		set fd [open [.exp.f1.fn get] w]
		puts $fd [.c postscript]
		close $fd
		destroy .exp
	} 
	button .exp.f2.cancel -text cancel -command {destroy .exp}
	button .exp.f2.browse -text browse -command {
		.exp.f1.fn delete 0 end; .exp.f1.fn insert end [tk_getSaveFile]}
	pack .exp.f2.export .exp.f2.cancel .exp.f2.browse \
		-side left -anchor c
	pack .exp.f .exp.f1 .exp.f2 -side top
	centerWindow .exp
	raise .exp
}

proc describeObj {i} {
	set xy [join [.c coords $i]]
	switch [.c type $i] {
		text {
			set dsc ".c create text \
				$xy -anchor [.c itemcget $i -anchor] \
				-text \{[.c itemcget $i -text]\} \
				-font \{[.c itemcget $i -font]\} \
				-fill [.c itemcget $i -fill] \
				-justify [.c itemcget $i -justify] \
				-width [.c itemcget $i -width]"
		} 
		line {
			set dsc ".c create line \
			$xy -fill [.c itemcget $i -fill] \
			-width [.c itemcget $i -width]"  
		}
		rectangle {
			set dsc ".c create rectangle \
			$xy -outline [.c itemcget $i -outline] \
			-width [.c itemcget $i -width]"
			if {[string length [.c itemcget $i -fill]] > 0} {	
				append dsc " -fill [.c itemcget $i -fill]"
			}  
		}
		oval {
			set dsc ".c create oval \
			$xy -outline [.c itemcget $i -outline] \
			-width [.c itemcget $i -width]"
			if {[string length [.c itemcget $i -fill]] > 0} {	
				append dsc " -fill [.c itemcget $i -fill]"
			} 
		}
		window {
			set dsc ".c create window $xy -anchor nw \
				-window [.c itemcget $i -window] \
				-tags [.c itemcget $i -tags]"
		}
	}
	set dsc
}

proc saveConfig {} {
	global sld
	set fd [open ~/.sqlformsrc w]
	catch {pg_disconnect $sld(conn)}
	catch {unset sld(conn)}
	catch {unset sld(db)}
	catch {unset sld(obj)}
	foreach i [array names sld] {
		puts $fd "set sld($i) \{$sld($i)\}"
	}
	close $fd
}
