proc doQuery { q } {
	global sld qry
	toplevel .qry
	wm transient .qry .
	frame .qry.f	
	text .qry.f.t -width 60 -height 18 -yscrollcommand {.qry.f.sb set} \
		-xscrollcommand {.qry.sbh set} -wrap none
	scrollbar .qry.f.sb -orient vertical  -command {.qry.f.t yview}
	scrollbar .qry.sbh -orient horizontal -command {.qry.f.t xview}
	button .qry.b -text close -command {destroy .qry}
	pack .qry.f.t .qry.f.sb -side left -fill both -expand 1
	pack .qry.f .qry.sbh .qry.b -side top -fill x -expand 1
	centerWindow .qry
	set consulta [pg_exec $sld(conn) $qry($q)]
	set ntuplas [pg_result $consulta -numTuples]
	if {$ntuplas < 1} { 
		.qry.f.t insert end "\n*** empty result ***\n"
	}
	.qry.f.t tag configure g -background PaleGreen
	.qry.f.t tag configure w -background white
	for {set i 0} {$i < $ntuplas} {incr i} {
		if {$i % 2} {
			foreach s [pg_result $consulta -getTuple $i] {
				.qry.f.t insert end "$s | " g
			}
		} else {
			foreach s [pg_result $consulta -getTuple $i] {
				.qry.f.t insert end "$s | " w
			}
		}
		.qry.f.t insert end "\n"
	}
	raise .qry
	focus .qry
	grab .qry	
}

#
# Para as rotinas dbXxxxx a varivel lclass  nula para
# acesso global (todos os campos do formulrio) ou
#  o valor da classe que deve ser usada como filtro
# para o acesso aos campos do formulrio
#
proc dbRetrieve { {lclass {}} } {
	global sld frm rel base
	set sld(iconsulta) 0
	set qry ""
	set classes [dbClassesUsed]
	if {$lclass == {}} {
		set oidclass $base
	} {
		set oidclass $lclass
	}
	forclass w $lclass 0 {
		if {$qry == ""} {
			set qry "select c[lsearch $classes $oidclass].oid, \
c[lsearch $classes [lindex $frm($w) 0]].[lindex $frm($w) 1]"
		} else {
			append qry ", \
c[lsearch $classes [lindex $frm($w) 0]].[lindex $frm($w) 1]"
		}
	}
	forrelation att oatt oclass $oidclass {
		append qry ", \
c[lsearch $classes [lindex $oidclass 0]].$att"
	}
	set tmp ""
	if {$oidclass == $base} {
		foreach c $classes { 
			if {$tmp == ""} {
				append tmp "\n from $c c[lsearch $classes $c]"
			} {
				append tmp ", $c c[lsearch $classes $c]"
			} 
		}
	} else {
		append tmp "\n from $lclass c0"
	}
	append qry $tmp
	set where_used 0
	set order ""
#### colocar where clause para o primeiro campo preenchido, tambem ordenando
	forclass w $lclass 0 {
		if {[string length [$w get]] > 0} {
			set where_used 1
			append qry "\n where \
c[lsearch $classes [lindex $frm($w) 0]].[lindex $frm($w) 1] ~*"
			if {$sld(searchBegin)} { 
				append qry " '^[$w get]'"
			} {
				append qry " '[$w get]'"
			}
			set order "\n order by \
c[lsearch $classes [lindex $frm($w) 0]].[lindex $frm($w) 1]"
			break
		}
	}
#### colocar where clause dos relacionamentos
	if {$oidclass == $base} {
		foreach i [array names rel] {
			if {!$where_used} {
				append qry "\n where "
				set where_used 1
			} else {
				append qry "\n   and "
			}
			set r1 [lindex $rel($i) 0]
			set r2 [lindex $rel($i) 1]
			append qry "c[lsearch $classes [lindex $r1 0]].[lindex $r1 1]"
			append qry " = c[lsearch $classes [lindex $r2 0]].[lindex $r2 1]"
		}
	}
	append qry $order
##### executa a query
puts $qry
	set sld(consulta) [pg_exec $sld(conn) $qry]
	set sld(ntuplas) [pg_result $sld(consulta) -numTuples]
	if {$sld(ntuplas) < 1} { 
		return 
	}
	set tupla [pg_result $sld(consulta) -getTuple $sld(iconsulta)]
	preencheForm $tupla $lclass
}

proc dbNext { {lclass {}} } {
	global sld frm
	if {$sld(iconsulta) < [expr $sld(ntuplas)-1]} {
		incr sld(iconsulta)
		set tupla [pg_result $sld(consulta) -getTuple $sld(iconsulta)]
		preencheForm $tupla $lclass
	}
}

proc dbPrev { {lclass {}} } {
	global sld frm
	if {$sld(iconsulta) > 0} {
		incr sld(iconsulta) -1
		set tupla [pg_result $sld(consulta) -getTuple $sld(iconsulta)]
		preencheForm $tupla $lclass
	}
}

proc dbFirst { {lclass {}} } {
	global sld frm
	set sld(iconsulta) 0
	set tupla [pg_result $sld(consulta) -getTuple $sld(iconsulta)]
	preencheForm $tupla $lclass
}

proc dbLast { {lclass {}} } {
	global sld frm
	if {$sld(ntuplas) > 0} {
		set sld(iconsulta) [expr $sld(ntuplas) - 1]
	} {
		set sld(iconsulta) 0
	}
	set tupla [pg_result $sld(consulta) -getTuple $sld(iconsulta)]
	preencheForm $tupla $lclass
}

proc dbRecord { {lclass {}} } {
	global sld frm base relvar
### salva para usar no reposicionamento
	set iconsulta $sld(iconsulta)
	if {$lclass == {}} {
		set uclass $base
	} {
		set uclass $lclass
	}
	if {$sld(ntuplas) == 0} {
		set qry ""
		forclass w $uclass 1 {
			if {$qry == ""} {
				set qry "insert into $uclass ([lindex $frm($w) 1]"
			} else {
				append qry ",[lindex $frm($w) 1]"
			}
		}
		forrelation att oatt oclass $uclass {
			append qry ", $att"
		}
		append qry ") values ("
		set values ""
		forclass w $uclass 1 {
			if {$values == ""} {
				set values "'[$w get]'"
			} else {
				append values ",'[$w get]'"
			}
		}
		forrelation att oatt oclass $uclass {
			append values ", $relvar($uclass.$att)"
		}
		append qry "$values )"
puts $qry
		pg_exec $sld(conn) $qry
		dbClean
	} else {
		set qry ""
		forclass w $uclass 1 {
			if {$qry == ""} {
				set qry "update $uclass set 
					[lindex $frm($w) 1] = '[$w get]'"
			} else {
				append qry ",[lindex $frm($w) 1] = '[$w get]'"
			}
		}
		forrelation att oatt oclass $uclass {
			append qry ", $att = $relvar($uclass.$att)"
		}
		append qry " where oid = $sld(oid,$uclass)"
puts $qry
		pg_exec $sld(conn) $qry
		dbClean
	}	
}

proc dbDelete { {lclass {}} } {
	global frm sld base
	set qry ""
	if {$lclass == {}} {
		set uclass $base
	} {
		set uclass $lclass
	}
	set qry "delete from $uclass"
	append qry " where oid = $sld(oid,$uclass)"
	pg_exec $sld(conn) $qry
	dbClean
}

proc dbClean { {lclass {}} } {
	global frm frmv sld
	forclass w $lclass 0 {
		$w delete 0 end
	}
	foreach w [array names frmv] {
		$w delete 0 end
	}
	set sld(ntuplas) 0
}
