proc setWidgetBindings { w } {
	bind $w <Enter> {widgetResizeEnter %W}
	bind $w <Leave> {widgetResizeLeave %W}
	bind $w <Motion> {widgetResizeStart %W %x %y}
	bind $w <2>	{widgetMoveStart %W %X %Y}
	bind $w <B2-Motion> {widgetResizeMove %W %x %y %X %Y}
	bind $w <ButtonRelease-2> {widgetResizeEnd %W %x %y %X %Y}
	bind $w <Double-2> {widgetOptions %W %x %y}
}

proc doBindings {t} {
	global fillbox boxedtext
	switch $t {
	none {
		setCursor left_ptr
		bind .c <1> {}
		bind .c <B1-Motion> {}
		bind .c <ButtonRelease-1> {}
	}
	line {
		setCursor tcross
	 	bind .c <1> {insertLine %x %y} 
		bind .c <B1-Motion> {insertLineMove %x %y} 
		bind .c <ButtonRelease-1> {insertLineEnd %x %y}
	}
	frame { 
		setCursor ul_angle
		set fillbox 0
		bind .c <1> {insertLine %x %y} 
		bind .c <ButtonRelease-1> {insertBoxEnd %x %y} 
		bind .c <B1-Motion> {insertBoxMove %x %y}
	}
	box {
		setCursor ul_angle
		set fillbox 1
		bind .c <1> {insertLine %x %y} 
		bind .c <ButtonRelease-1> {insertBoxEnd %x %y} 
		bind .c <B1-Motion> {insertBoxMove %x %y}
	}
	text {
		setCursor xterm
		set boxedtext 0
		bind .c <1> {insertTextMark %x %y}
		bind .c <ButtonRelease-1> {insertTextLimit %x %y}
		bind .c <B1-Motion> {insertTextDrag %x %y}
	}
	btext {
		setCursor xterm
		set boxedtext 1
		bind .c <1> {insertTextMark %x %y}
		bind .c <ButtonRelease-1> {insertTextLimit %x %y}
		bind .c <B1-Motion> {insertTextDrag %x %y}
	}
	entry {
		setCursor ul_angle
		bind .c <1> {insertLine %x %y} 
		bind .c <ButtonRelease-1> {insertWidgetEnd entry %x %y} 
		bind .c <B1-Motion> {insertWidgetMove entry %x %y}
	}
	button {
		setCursor ul_angle
		bind .c <1> {insertLine %x %y} 
		bind .c <ButtonRelease-1> {insertWidgetEnd button %x %y} 
		bind .c <B1-Motion> {insertWidgetMove button %x %y}
	}
	}
}

proc canvasBind {} {

#### binding for object motion
	.c bind all <2> {objectStartMove %x %y}
	.c bind all <B2-Motion> {objectMove %x %y}
	.c bind all <Motion> {objectResize %x %y}
	.c bind all <Leave> {.c config -cursor $sld(cursor)}
	.c bind all <ButtonRelease-2> {.c config -cursor $sld(savedCursor)}
	.c bind all <Double-2> {objectOptions %x %y}

#### keyboard accelerators
	bind . <Control-n> fileNew
	bind . <Control-s> fileSave
	bind . <Control-l> fileLoad
	bind . <Control-q> "saveConfig; exit"
	bind . <Control-v> pasteObject
	bind . <Control-c> copyObject
	bind . <Control-d> cutObject
	bind . <Control-f> frontObject
	bind . <Control-b> backObject
	bind . <Alt-Key-Right> dbNext
	bind . <Alt-Key-Left> dbPrev
	bind . <Alt-Key-Down> dbLast
	bind . <Alt-Key-Up> dbFirst
	bind . <Alt-Key-Home> dbRetrieve
	bind . <Alt-Key-Delete> dbDelete
	bind . <Alt-Key-Insert> dbRecord
	bind . <Alt-Key-End> dbClean
}
