%{// -*- awk  -*-
#include "y.tab.h"

#define debug  1
#define YY_INPUT(buf,result,max_size) {result = readblock (buf, max_size);}
					    
%}


DIGIT   [0-9]
INTEGER DIGIT{1,10}
SEP	[]

%%

complete	{return COMPLETE;}
drop		{return DROP;}
create		{return CREATE;}
search		{return SEARCH;}
search_list	{return SEARCH_LIST;}
select		{return SELECT;}
forget		{return FORGET;}
quit		{return QUIT;}
save		{return SAVE;}


\"[^\"]*\"		{
#if debug
  printf ("lex: name: %d %s\n",yyleng, yytext);
#endif
  yylval.string=malloc(yyleng-1);
  strncpy (yylval.string, yytext+1,(yyleng-2));
  yylval.string[yyleng-2]=0;
#if debug
  printf ("lex: name: %s\n", yylval.string);
#endif
  return NAME;
}


[ \t]+		{  /*putchar ('');*/ }
		      
[\n]		{}  



{DIGIT}{1,10}|{INTEGER}		{
  yylval.num=atoi (yytext);
  return NUMBER;
}



[()]	{
#if debug > 1
  putchar ('$');
#endif
  return (yytext[0]);}



.	{
#if debug > 1
  putchar ('');
#endif
}


<<EOF>>		{
  yyterminate();
}

%%

yywrap ()
{}



#ifdef   TEST
main()
{
  while (yylex()!=0){}
}
#endif
