#include "ios.h"
#define debug 2




// OPEN & ADVERTISE
SOCKET::SOCKET()
{
  sockaddr_in s_in;
  int one = 1;
  cache.size=0;
  cache.cap=CACHE_SIZE;



  /* get an internet domain socket */
  if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
    perror("socket"); exit(1);
  }
#if debug >0
  cerr <<"socket: allocated\n";
#endif




  /* complete the socket structure */
  memset(&s_in, 0, sizeof(s_in));
  s_in.sin_family = AF_INET;
  s_in.sin_addr.s_addr = INADDR_ANY;
  s_in.sin_port = htons(PORT);
  //  strncpy(sin.sa_data,"./caratter_socket",14);

  memcpy (&sin,&s_in,sizeof (s_in));



  setsockopt (sd, SOL_SOCKET, SO_REUSEADDR, (char *) &one, sizeof(one) );
#if debug >0
  cerr <<"socket: re-usage enabled\n";
#endif



  /* bind the socket to the port number */
  if (bind(sd, &sin, sizeof(sin)) == -1) {
    perror("bind"); exit(1);
  }
#if debug >0
  cerr <<"socket: port bound\n";
#endif




  /* show that we are willing to listen */
  if (listen(sd, MAX_CONNECTIONS) == -1) {
    perror("listen"); exit(1);
  }
#if debug >0
  cerr <<"socket: port listened to\n";
#endif

  connections=0;
}







// wait for the first client
SOCKET::establish ()
{
  int addrlen;
  int fd;
  if ((fd = accept(sd, &pin, &addrlen)) == -1) {
    perror("accept"); exit(1);
  }
  fds[connections]=fd;
#if debug >0
  cerr <<"socket: connection established" << fds[connections] <<"\n";
#endif
  connections++;
}



int
SOCKET::select ()
{
  int max, i, res;
  max=sd;



  do
    {
      FD_ZERO(&rfds);
      FD_SET(sd, &rfds);
      for (i=0;i<connections;i++)
	{
	  FD_SET (fds[i], &rfds);
	  if (fds[i]>max)  max=fds[i];
	}
      cerr <<"calling select:" << connections <<" connections open by now\n";
      res=::select(max+1, &rfds, NULL, NULL, NULL); // Block
      cerr <<"select returned:" << res <<"\n";

      if (res<0)
	perror ("select failed");
      if (res==0)
	cerr <<"time ???";


      if ( FD_ISSET(sd, &rfds) )
	{
	  establish ();		// RE-select !!!!
	  res--;
	}
    }while (res<1);

  // Now find some and execute
  for (i=0;i<connections;i++)
    {
      if (FD_ISSET (fds[i], &rfds))
	{
	  current=i;
	  cerr << "The winner is " << i << "\n";
	  break;
	}
    }
  cerr << "The winner is " << current << "\n";
  return current;
}







//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

#if 0
int SOCKET::read ()
{
  return (this->read (MAX_LINE));
}
#endif


int SOCKET::read (int max)
{
  int q;
  cerr << "reading from " << current  << fds[current] <<"\n";
  /* get a message from the client  */
  if (max>MAX_LINE)
    max=MAX_LINE;
  bzero(in_cache, max);

  if ((q=recv(fds[current], in_cache, max, 0)) == -1) 
    {
      perror("recv");
      exit(1);
    }

#if debug >0
  //cerr <<"socket: request read: \n";
  cerr << in_cache << "\n";
#endif
  return q;
}




SOCKET::write (string what)
{
  this->write (what.c_str (), what.length ());
}

SOCKET::write (char* what)
{
  unsigned int len=strlen (what);
  write (what,len);
}

SOCKET::write (const char* what, unsigned int len)
{
  int l;
  //	cerr << what;
  l=(cache.size+len)-cache.cap;
  if (l>0)
    {
      //      cerr << "cutting \n";
      memcpy (cache.data+cache.size,what, cache.cap-cache.size);
      ::write (fds[current], cache.data, cache.cap);

#if debug >1		
      cerr <<"socket: writing \n";
#endif
      memcpy (cache.data,what+(cache.cap-cache.size),l);
      cache.size=l;
    }	
  else
    {
      memcpy (cache.data+cache.size,what, len);
      cache.size+=len;
    }
}

int SOCKET::flush ()
{
  //     send the rest in cache.
  if (cache.size>0)
    {
#if debug >1
      cerr <<"socket: flushing  the socket-cache\n";      
#endif
      //      write (1,cache.data,cache.size); 
      //      cerr <<"<\n";      
      ::write (fds[current],cache.data,cache.size);
      cache.size=0;
    }
}




SOCKET::~SOCKET()
{
#if debug >0
  cerr <<"socket: closing in-socket\n";
#endif
  close (sd);
}




fstream updates;
fstream restores;
