#include <libpq++.h>
#include <set.h>
#include <map.h>

#include "ios.h"

#define DATABASE  "maruska"

/* The structure of a term-directory*/
/* The store for term-directories */

class assoc
{
private:
  typedef set<string,less<string> >  SET;
  SET::iterator  min ,max ,i;
  int users;			// How many users
public:
  SET M;
  assoc(string);
  //	~assoc();
  range (string S, int mode, SOCKET* SOC);
};





//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

//  read-in strings
assoc::assoc (string query)
{
  PgDatabase	PG(DATABASE);
  int 	i;

  cerr << "QUERY is" <<query <<"\n";

  PG.Exec (query.c_str ());
  for (i=0;i<PG.Tuples();i++)
    {
      //		cout <<PG.GetValue (i,0) <<"\n";
      M.insert(PG.GetValue (i,0));
    }
};



string common_prefix (string A, string B)
{
  int i=0;
  register int  max=A.length();
  if (max>B.length())
    max=B.length();
  cerr << "common prefix: " << A <<" " << B <<"\n";
	
  while ((i<max) 
	 && (A[i]==B[i]))
    i++;
  cerr << i << "\n";
  return (A.substr (0,i));
}


/* output a range/CP (Common Prefix) to a socket ??
   
   if mode=prefix	->		P
   if mode=all  	->		(setq TCP-completeL (list  X1 X2 ... Xn))
   
 */
assoc::range (string S, int mode, SOCKET* SOC)
{	
  min=M.lower_bound (S);	// 1st not less
  max=M.upper_bound (S+'\255'+'\255'); // 1st greater
	
  cerr << "range: " << S <<" " << mode <<"\n";
  if (mode==0) // only CP
    {
      // Nothing
      if (min==max)
	{
	  // Write nil
	  if (S=="")
	    SOC->write ("nil",3);
	  else
	    SOC->write (S);
	}
      else
	{
	  max--;
	  SOC->write (common_prefix (*min, *max));
	}
      SOC->flush ();// I hope it is united
    }
  else
    {
      SOC->write ("(setq TCP-completeL (list ",26);
      while (min!=max)
	{
	  SOC->write ("\"",1);
	  SOC->write(*(min++));
	  SOC->write ("\" ",2);
	}
      SOC->write ("))",2);
      SOC->flush ();
    }
}



typedef map <string, assoc*, less<string> > t_cache;
t_cache  CACHE;








//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

extern "C" {
  int complete (char* name, char* prefix, int mode);
  int create (char* name, char* query);
  int drop (char* name);
	   }

extern SOCKET S;

int complete (char* name, char* prefix, int mode)
{
  cerr << "completer: in " <<name << " for "<< prefix <<"in mode " << mode <<"\n";
  CACHE[name]->range (prefix, mode, &S);
}

int create (char* name, char* query)
{
  CACHE[name]=new assoc(query);
}

int drop (char* name)
{
  delete CACHE[name];
}




/*	cout << "in the cache is \n";
	cout << CACHE[name]->M.size () <<"\n";
	CACHE[name]->range ("via");
	CACHE[name]->range ("Mor");
*/

