;;; MM-form-example.el --- ex.  of a description of a MM-form

;;; Copyright:
;; Author: Michal Maruka <mmaruska@tin.it>
;; Keywords: widgets, 

;; This file is part of postgreSQL-emacs-forms.

;; postgreSQL-emacs-forms is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; postgreSQL-emacs-forms is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with postgreSQL-emacs-forms; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:
;; The _complete_ description of possible constructs is contained in the code of  MM-generate-widgets
;; here I explain the basic types:

;; Description of a form is a list, made of descriptors of objects called widgets.
;; every descriptor contains an identificator of type and options.
;; So as not to repeat :size :help-echo and other common combinations ... I prepared "fixed" types



;; ** MM-field: options are:  name  tag lenght help domain value
;; where:
;; name   is used to generate a symbol containing the widget, necessary to access its value;
;; tag    is displayed .. see widgets info document !!
;; ...
;; domain is a string-identification  of a domain for the server --- MM-complete (usually bound to
;; M-TAB) 
;; not-implemented: history


;; ** MM-menu: options are:  name  tag lenght help list-of-possibilities
;; where list-of-possibilities indicates what items are acceptable

;; ** MM-integer options are: name  tag lenght help value

;; anything else is just passed to widget-create
;;; Code:

;; As I modify some widget faces I
(require 'wid-edit)

;; this is strictly 'person' specific
(require 'foto)
(require 'MM-field)
(require 'MM-contatti)
(define-widget-keywords :data-from :data-to :status)

(setq person-widlist
      (list
       '("face-def"  widget-button-face "black" "gold")
       '("face-def"  widget-field-face "black" "Aquamarine" )
       '("face-def"  widget-inactive-face "black" "Aquamarine")
       '("const" "Maruska, agenzia matrimoniale.\n\n")
       '(MM-field "nome" "nome"  22 "nome, (tab,  )" "nome" "")
       '(MM-field "cognome" "cognome" 22  "cognome,  (tab, )" "cognome" "")
       '(MM-menu  "sex" "sex"  1 "sex (read-only)" 
		  ("f" "m" "s" "e")
		  )
       '(MM-integer "numero"  "numero" 5  "numero (read-only)" "" )

       '("title" " INDIRIZZO:")
       '(MM-field "via" "via" 22  "via solo il nome !!!" "via" "")
       '(MM-field "citta" "citta" 22  "citta solo il nome !!!" "citta" "")
       '(MM-string "cap" "cap" 15  "codice postale" "")
       '(MM-field "stato" "stato" 15  "stato" "stato" "")
       '("const" "\n")       
       '(MM-string "telefono" "telefono" 50  "telefono, per ora senza struttura" "")

       '("title" " MISURE FISICHE:")
       '(MM-integer "altezza"  "altezza" 3 "altezza in cm" "")
       '(MM-integer "peso"  "peso" 3  "peso in kg" "")
       '(MM-integer "eta"  "et" 3 "et in anni" "")
       '(MM-string "d_nascita" "data di nascita" 1  "format dd/mm/yy" "")

       '("title" "SITUAZIONE FAMILIARE:")
       '(MM-string "stato_civile" "stato civile" 1  "v=vedova d=divorzioto, c/n" "")
       '(MM-integer "figli" "numero figli" 1  "numbero totale di figli" "")
       '(MM-integer "figli_con" "figli conviventi" 1  "numbero totale di figli conviventi" "")
       '(MM-integer "figli_trans" "figli trans" 1  "numbero totale di figli che si trasferrirebero" "")
       '(MM-string "figli_eta" "figli eta" 1  "numbero totale di figli che si trasferrirebero" "")


       '("title" "CARRIERA:")
       '(MM-string "lavoro" "professione" 2  " " "")
       '(MM-string "istruzione" "istruzione" 1  " " "")

       '(MM-string "guida" "guida" 1  "s/n" "")



       '("title" "CARATTERE:")
       '(MM-field "nazionalita" "nazionalit" 8 "nazionalit" "nazionalita" "") 
       '(MM-integer "voto" "voto" 2  "voto di bellezza" "")
       '(MM-string "fuma" "fumo" 1  "s/n" "")
       '(MM-string "chiesa" "chiesa" 1  "s/m/n" "")


       '("title" "AMMINISTRATIVA:")
       '(MM-string "d_iniz" "data di 1` contatto" 8  "formato dd/mm/yy" "")
       '(MM-string "questionario" "questionario" 1  "s/n" "")
       '(MM-string "foto" "foto" 1  "s/n" "")
       '(MM-string "gif" "gif" 1  "s/n" "")
       '(MM-string "film" "film" 1  "s/n" "")
       '(MM-string "lingua_cor" "lingua di corrispondenza" 2  " " "")
       '(MM-string "fare_foglio" "fare_foglio" 1  "s/n" "")
       '(MM-string "spedire_quest" "spedire_quest" 1  "s/n" "")

       
       '("title" "PARTNER:")
       '(MM-integer "eta_min" "eta minima" 2  "" "")
       '(MM-integer "eta_max" "eta massima" 2  "" "")
       '(MM-integer "alt_min" "altezza minima" 2  "" "")
       '(MM-integer "alt_max" "altezza massima" 2  "" "")
       '(MM-integer "p_max_figli" "massimo di figli (trasfer)" 2  "" "")
       '(MM-string "p_fumo" "fumo" 1  "s/n" "")
       '(MM-string "p_istruzione" "istruzione" 1  "s/n" "")

       '("title" "CONTATTI:")
       '(contatti-button  ""  :tag "demo" :value "306"
			  )
       '(contatti-button  ""  :tag "pes da spedire" :value "202"
			  )
       '(contatti-button  ""  :tag "Pes da spedire" :value "204"
			  )
       '(contatti-button  ""  :tag "pes spedito" :value "201"
			  )
       '(contatti-button  ""  :tag "Pes spedito" :value "205"
			  )

       '(contatti-button  ""  :tag "pes rifiutato" :value "211"
			  )
       '(contatti-button  ""  :tag "proposta non spedita" :value "212"
			  )
       '(contatti-button  ""  :tag "proposta" :value "203"
			  )
       '(contatti-button  ""  :tag "proposta spedita" :value "200"
			  )
       '(contatti-button  ""  :tag "proposta accetata" :value "204"
			  )
       '(contatti-button  ""  :tag "sposata" :value "201"
			  )
       '("const" "\n")
       '(push-button "" :tag "foto" 
		     :action (lambda (&rest widget)
			       (let (
				     (id (format "%s%s" (MM-value-get "sex") (MM-value-get "numero")) )
				     )
				 (message id)
				 (show-foto id)
				 ))
		     )
       
       )
      )


;setq books-widlist
(setq libri-widlist
      (list
       '("const" "Books on Mathematics.\n\n")
       '(MM-field "author" "author-s" 20 "Insert author name, please" "surname"  "")
       '(MM-string "title" "Title" 20  "Title of the book" " ")
       '(MM-integer "year" "Year"  4 "year of the issue")
       '(MM-integer "pages" "No Pages"  4 "approx. number of pages of the edition")
       '(MM-menu "category" "category"  10 "Select the category, which suits best"
		 ("Algebra" "Groups" "Galois" "Commutative algebra" "General topology" "Algebraic
topology" "Set theory" "Analysis measure theory" "Analysis potential theory" "Analysis differential
equations" "Analysis functional" "Analysis complex" "Analysis real" "Topology" "Number theory"
"Combinatorics" "Categories")
		 )
       )
      )

(provide 'MM-descriptions)

;;; possible  usage (for debugging only)
;;(MM-form "person")
;;
;;(progn
;;  (switch-to-buffer "libri-new")
;;  (MM-form "libri")
;;  )

;;; MM-form-example.el ends here
