/***************************************************************************
                          toplevel.h  -  Main application class
                             -------------------
    begin                : Wed Apr 7 1999
    copyright            : (C) 1999 by Mutiny Bay Software
                           (C) 1998 by Jochen Wilhelmy (kwrite portions)
    email                : info@mutinybaysoftware.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _TOPLEVEL_H_
#define _TOPLEVEL_H_

#include <qlist.h>
#include <qstring.h>
#include <qpopmenu.h>
#include <qmenubar.h>
#include <qapp.h>

#include <kapp.h>
#include <kconfig.h>
#include <ktoolbar.h>
#include <kstatusbar.h>
#include <knewpanner.h>
#include <keditcl.h>

#include <ktmainwindow.h>

#include "kwview.h"
#include "kwdoc.h"
#include "kresultwindow.h"
#include "dbaccess.h"

class TopLevel : public KTMainWindow {
    Q_OBJECT
    friend class DBAccess;
  public:

    TopLevel(KWriteDoc * = 0);
    ~TopLevel();
    void init(); //initialize caption, status and show

    virtual bool queryClose();
    virtual bool queryExit();

    void loadURL(const char *url, int flags = 0);

  protected:
    void setupEditWidget(KWriteDoc *);
    void setupMenuBar();
    void setupToolBars();
    void setupStatusBar();
    void doEvents();

    DBAccess *connection;

    KNewPanner *splitter;
    KWrite *kWrite;
    KResultWindow *results;

    int menuUndo, menuRedo;
    int menuExecute, menuCancel;
    int menuShowTB, menuShowTBSql, menuShowSB;
    int menuFile, menuEdit, menuView, menuOptions, menuHelp;

    KMenuBar *menubar;
    QPopupMenu *file, *edit, *options, *query, *view, *help;
    QPopupMenu *recentPopup, *hlPopup, *popup, *resultPopup;
    QStrList recentFiles;

    bool hideToolBar;
    bool hideToolBarSql;
    bool hideStatusBar;

    QTimer *statusbarTimer;

  public slots:
    void openRecent(int);
    void newWindow();
    void closeWindow();
    void quitEditor();

    void toggleStatusBar();
    void toggleToolBar();
    void toggleToolBarSql();
    void toggleQueryState();

    void helpSelected();

    void newCurPos();
    void newStatus();
    void statusMsg(const char *);
    void timeout();
    void newCaption();
    void newUndo();
    void newConnection();
    void executeQuery();
    void cancelQuery();
    void setOutputOptions();
    void setSpoolFile();
    void cut();
    void copy();
    void print();
    void about();

    void dropAction(KDNDDropZone *);

    void showHighlight();

    //config file functions
  public:
    //common config
    void readConfig(KConfig *);
    void writeConfig(KConfig *);
    //config file
    void readConfig();
  public slots:
    void writeConfig();
    //session management
  public:
    void restore(KConfig *,int);
  protected:
    virtual void readProperties(KConfig *);
    virtual void saveProperties(KConfig *);
    virtual void saveData(KConfig *);
};

#endif //TOPLEVEL_H













































