/***************************************************************************
                          outputdialog.cpp  -  result window config dialog
                             -------------------
    begin                : Wed Apr 7 1999
    copyright            : (C) 1999 by Mutiny Bay Software
    email                : info@mutinybaysoftware.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include "outputdialog.h"

#define Inherited OutputDialogData

OutputDialog::OutputDialog(OptionStruct *opt, QWidget* parent,
                           const char* name):Inherited( parent, name ){

  optNone->setText(i18n("&None"));
  optSpace->setText(i18n("&Space"));
  optTab->setText(i18n("Ta&b"));
  optOther->setText(i18n("Othe&r:"));
  txtOther->setMaxLength(1);

  optAligned->setText(i18n("&Aligned"));
  optStandard->setText(i18n("Stan&dard"));
  optExpanded->setText(i18n("E&xpanded"));

  optText->setText(i18n("&Text"));
  optHtml->setText(i18n("&HTML"));

  chkShowHeadings->setText(i18n("Sho&w Column Headings"));
  chkEchoQuery->setText(i18n("&Echo Query"));
  chkSpool->setText(i18n("Spool Output to &File"));

  setColSeparator(opt->sepId, opt->otherChar);
  setAlignment(opt->alignment);
  setOutputType(opt->outputType);

  if(opt->colHeadings == 1)
    chkShowHeadings->setChecked(TRUE);
  if(opt->echoQuery == 1)
    chkEchoQuery->setChecked(TRUE);
  if(opt->spool == 1)
    chkSpool->setChecked(TRUE);

  btnOK->setText(i18n("&OK"));
  btnOK->setDefault(TRUE);
  btnCancel->setText(i18n("&Cancel"));

  connect(btnOK,SIGNAL(clicked()),this,SLOT(accept()));
  connect(btnCancel,SIGNAL(clicked()),this,SLOT(reject()));

  setFixedSize(width(),height());
  setCaption(i18n("Result Window"));
}

OutputDialog::~OutputDialog(){
}

void OutputDialog::setColSeparator(int sep, char oc){
  char colSep[2];

  switch(sep){
    case 0:
      optNone->setChecked(TRUE);
      break;
    case 1:
      optSpace->setChecked(TRUE);
      break;
    case 2:
      optTab->setChecked(TRUE);
      break;
    case 3:
      optOther->setChecked(TRUE);
      break;
    default:
      break;
  }

  memset(colSep, '\0', 2);
  colSep[0] = oc;
  txtOther->setText(colSep);
}

void OutputDialog::setAlignment(int align){
  switch(align){
    case 0:
      optAligned->setChecked(TRUE);
      break;
    case 1:
      optStandard->setChecked(TRUE);
      break;
    case 2:
      optExpanded->setChecked(TRUE);
      break;
    default:
      break;
  }
}

void OutputDialog::setOutputType(int type){
  switch(type){
    case 0:
      optText->setChecked(TRUE);
      break;
    case 1:
      optHtml->setChecked(TRUE);
      break;
    default:
      break;
  }
}

void OutputDialog::getOptionData(OptionStruct *opt){
  // column seperator character
  if(optNone->isChecked()){
    opt->sepId = 0;
    opt->sepChar = '\0';
  }
  else if(optSpace->isChecked()){
    opt->sepId = 1;
    opt->sepChar = ' ';
  }
  else if(optTab->isChecked()){
    opt->sepId = 2;
    opt->sepChar = '\t';
  }
  else if(optOther->isChecked()){
    opt->sepId = 3;
    opt->sepChar = txtOther->text()[0];	
  }
  opt->otherChar = txtOther->text()[0];

  // output alignment
  if(optAligned->isChecked())
    opt->alignment = 0;
  else if(optStandard->isChecked())
    opt->alignment = 1;
  else if(optExpanded->isChecked())
    opt->alignment = 2;

  // output type
  if(optText->isChecked())
    opt->outputType = 0;
  else if(optHtml->isChecked())
    opt->outputType = 1;

  // column headings
  if(chkShowHeadings->isChecked())
    opt->colHeadings = 1;
  else
    opt->colHeadings = 0;

  // echo query
  if(chkEchoQuery->isChecked())
    opt->echoQuery = 1;
  else
    opt->echoQuery = 0;

  // spool file option
  if(chkSpool->isChecked())
    opt->spool = 1;
  else
    opt->spool = 0;

}

















