/***************************************************************************
                          kwdialog.h  -  kwrite dialogs
                             -------------------
    begin                : Wed Apr 7 1999
    copyright            : (C) 1999 by Mutiny Bay Software
                           (C) 1998 by Jochen Wilhelmy (kwrite portions)
    email                : info@mutinybaysoftware.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KWDIALOG_H_
#define _KWDIALOG_H_

#include <qdialog.h>
#include <qlined.h>
#include <qchkbox.h>
#include <qradiobt.h>
#include <qlistbox.h>

#include <kcolorbtn.h>

#include "kwview.h"

class SearchDialog : public QDialog {
    Q_OBJECT
  public:
    SearchDialog(const char *searchFor, const char *replaceWith,
      int flags, QWidget *parent, const char *name = 0);
    const char *getSearchFor();
    const char *getReplaceWith();
    int getFlags();

  protected slots:
    void okSlot();

  protected:
    QLineEdit *search;
    QLineEdit *replace;

    QCheckBox *opt1;
    QCheckBox *opt2;
    QCheckBox *opt3;
    QCheckBox *opt4;
    QCheckBox *opt5;
    QCheckBox *opt6;
};

class ReplacePrompt : public QDialog {
    Q_OBJECT
  public:
    ReplacePrompt(QWidget *parent, const char *name = 0);
  signals:
    void clicked();
  protected slots:
    void no();
    void all();
    virtual void done(int);
  protected:
    void closeEvent(QCloseEvent *);
};

class GotoLineDialog : public QDialog {
    Q_OBJECT
  public:
    GotoLineDialog(int line, QWidget *parent, const char *name = 0);
    int getLine();
  protected:
    QLineEdit *e1;
};

class SettingsDialog : public QDialog {
    Q_OBJECT
  public:
    SettingsDialog(int flags, int wrapAt, int tabWidth, int undoSteps,
      QWidget *parent, const char *name = 0);
    int getFlags();
    int getWrapAt();
    int getTabWidth();
    int getUndoSteps();
  protected:
    QCheckBox *opt1;
    QCheckBox *opt2;
    QCheckBox *opt3;
    QCheckBox *opt4;
    QCheckBox *opt5;
    QCheckBox *opt6;
    QCheckBox *opt7;
    QCheckBox *opt8;
    QCheckBox *opt9;
    QCheckBox *opt10;
    QCheckBox *opt11;
    QCheckBox *opt12;
    QLineEdit *e1;
    QLineEdit *e2;
    QLineEdit *e3;
};

class ColorDialog : public QDialog {
    Q_OBJECT
  public:
    ColorDialog(QColor *, QWidget *parent, const char *name = 0);
    void getColors(QColor *);
  protected:
    KColorButton *back;
    KColorButton *textBack;
    KColorButton *selected;
    KColorButton *found;
    KColorButton *selFound;
};

class ResultsColorDialog : public QDialog {
    Q_OBJECT
  public:
    ResultsColorDialog(QColor &foreColor, QColor &backColor, QWidget *parent, const char *name = 0);
    void getColors(QColor &foreColor, QColor &backColor);
  protected:
    KColorButton *text;
    KColorButton *back;
};

#endif //_KWDIALOG_H_





















