/***************************************************************************
                          kresultwindow.cpp  -  SQL output widget
                             -------------------                                         
    begin                : Thu Apr 1 1999                                           
    copyright            : (C) 1999 by Mutiny Bay Software                         
    email                : info@mutinybaysoftware.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kresultwindow.h"

KResultWindow::KResultWindow(KApplication *a,QWidget *parent, const char *name,
                             const QString& filename):KEdit(a, parent, name, filename){

  setReadOnly(TRUE);
  setWordWrap(FALSE);
  setAutoIndentMode(FALSE);

  textFont = QFont("courier", 12, QFont::Normal);
  foreColor = QColor(black);
  backColor = QColor(white);
}

KResultWindow::~KResultWindow(){
}

void KResultWindow::setTextFont() {
  selectFont();
  textFont = font();
}

void KResultWindow::setColors() {
  ResultsColorDialog *dlg;

  dlg = new ResultsColorDialog(foreColor, backColor, this);
  dlg->setCaption(i18n("Result Window Colors"));
  if (dlg->exec() == QDialog::Accepted) {
    dlg->getColors(foreColor, backColor);
    updateColors();
  }
  delete dlg;
}

void KResultWindow::updateTextFont() {
  setFont(textFont);
}

void KResultWindow::updateColors() {

  QPalette mypalette = (palette()).copy();

  QColorGroup cgrp = mypalette.normal();
  QColorGroup ncgrp(foreColor,cgrp.background(),
		    cgrp.light(),cgrp.dark(),cgrp.mid(),foreColor,backColor);

  mypalette.setNormal(ncgrp);
  mypalette.setDisabled(ncgrp);
  mypalette.setActive(ncgrp);

  setPalette(mypalette);
  setBackgroundColor(backColor);
}

void KResultWindow::readConfig(KConfig *config) {

  config->setGroup("Output Options");

  textFont = config->readFontEntry("Result Window Font", &textFont);
  foreColor = config->readColorEntry("ForeColor",&foreColor);
  backColor = config->readColorEntry("BackColor",&backColor);
}

void KResultWindow::writeConfig(KConfig *config) {

  config->setGroup("Output Options");

  config->writeEntry("Result Window Font",textFont);
  config->writeEntry("ForeColor",foreColor);
  config->writeEntry("BackColor",backColor);
}









































