/***************************************************************************
                          dbaccess.h  -  PostgreSQL connection class
                             -------------------                                         
    begin                : Tue Apr 6 1999                                           
    copyright            : (C) 1999 by Mutiny Bay Software                         
    email                : info@mutinybaysoftware.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef DBACCESS_H
#define DBACCESS_H

#include <qobject.h>
#include <qdialog.h>
#include <qsocketnotifier.h>
#include <kconfig.h>
#include <kcursor.h>
#include <kmsgbox.h>

#include <libpq-fe.h>

const int DATA_SIZE = 2048;                  // max len of a single line in a query
const int MAX_PATH_LEN = 2048;               // max length of a file path
const int QY_BUFFER_SIZE = 20000;            // max size of a single query statement
const int COPYBUFSIZ = 8192;                 // max copy buffer size
const int EXPLAINBUFSIZ = 32767;             // max explain qy buffer size
const long RSLT_BUFFER_SIZE = 4096000;       // max size of data in the result win.
const int DB_NAME_SZ = 255;                  // max size of db name
const int HOST_NAME_SZ = 255;                // max size of host name
const int PORT_NAME_SZ = 10;                 // max size of port id
const int UNAME_NAME_SZ = 255;               // max size of uname
const int PWD_NAME_SZ = 255;                 // max size of pwd
const int PRINT_NAME_SZ = 255;               // max size of printer name
const int ERR_MSG_SZ = 1024;                 // max size of error msgs

struct LoginStruct {
  char *username;
  char *password;
  char *database;
  char *host;
  char *port;
};

struct OptionStruct {
  int  sepId;
  char sepChar;
  char otherChar;
  int  alignment;
  int  outputType;
  int  spool;
  int  echoQuery;
  int  colHeadings;
};

class TopLevel;
class KWrite;
class KResultWindow;

class DBAccess : public QObject  {
    Q_OBJECT
  public:
    DBAccess(TopLevel *topwidget, const char *name=0);
    virtual ~DBAccess();

  protected:
    TopLevel *mainwin;
    KWrite   *sqlwin;
    KResultWindow  *resultwin;
    QSocketNotifier *sn;
    	
    PGconn *db;	                     // db ptr
    char dbname[DB_NAME_SZ];	     	 // db name ptr
    char host[HOST_NAME_SZ];         // host name ptr
    char port[PORT_NAME_SZ];	     	 // port ptr
    char username[UNAME_NAME_SZ];    // user name
    char passwd[PWD_NAME_SZ];        // user password
    char spool_file[MAX_PATH_LEN];   // spool file
    int  alignment;                  // column alignment
    int  outtype;                    // output type
    int  col_sep_id;                 // column separator char id
    char col_sep;                    // column separator char
    char other_sep;                  // separator char for 'other'
    int  echo_qy;                    // echo query flag
    int  colheadings;                // column heading output flag
    int  spool;                      // spool output flag
    int  qy_cancelled;               // query cancel flag
    int  qy_running;                 // query processing flag
    int  connected;                  // connect flag

    int  check_cancelled();
    void writeToResult(char *data, int spool, FILE *file);
    void printTuples(char *qy, PGresult *res, char *fout, int Spool,
                     int PrintAttNames, int Echo, char sep);
    void formatResults(FILE *fout, PGresult *res, PQprintOpt *po);
    void doField(PQprintOpt *po, PGresult *res,
	         const int i, const int j, char *buf, const int fs_len,
	         char *fields[],
	         const int nFields, char *fieldNames[],
	         unsigned char fieldNotNum[], int fieldMax[],
	         const int fieldMaxLen, FILE *fout);
    char* doHeader(FILE *fout, PQprintOpt *po, const int nFields, int fieldMax[],
		   char *fieldNames[], unsigned char fieldNotNum[],
		   const int fs_len, PGresult *res);
    void outputRow(FILE *fout, PQprintOpt *po, const int nFields, char *fields[],
		   unsigned char fieldNotNum[], int fieldMax[], char *border,
		   const int row_index);	
    void handleCopyOut(PGresult *res);
    void handleCopyIn(PGresult *res);

    char* leftTrim(char* s);
    char* rightTrim(char* s);
    char* doubleTrim(char* s);

  protected slots:
    void readStdError(int soc);

  public:
    void resetConnection();
    void setConnection(LoginStruct *login);
    void getConnectionInfo(LoginStruct *login);
    void closeConnection();
    void executeQuery();
    void cancelQuery();	
    int  queryState();

    void setSpoolFile(const char *file);
    const char* getSpoolFile();

    void redirectStdError(bool to_results);

    void setOptions(OptionStruct *opt);
    void getOptionInfo(OptionStruct *opt);
    void readConfig(KConfig *);
    void writeConfig(KConfig *);	
};

#endif //DBACCESS_H






























































