/***************************************************************************
                          connectdialog.cpp  -  database connection dialog
                             -------------------
    begin                : Wed Apr 7 1999
    copyright            : (C) 1999 by Mutiny Bay Software
    email                : info@mutinybaysoftware.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>

#include "connectdialog.h"
#include "dbaccess.h"

#define Inherited ConnectDialogData

ConnectDialog::ConnectDialog(LoginStruct *login, QWidget* parent,
                             const char* name):Inherited(parent, name){

  txtUserName->setFocus();
  txtPassword->setEchoMode(QLineEdit::Password);

  lblUserName->setText(i18n("User name:"));
  lblPassword->setText(i18n("Password:"));
  lblDatabase->setText(i18n("Database:"));
  lblHost->setText(i18n("Host:"));
  lblPort->setText(i18n("Port:"));

  txtUserName->setMaxLength(UNAME_NAME_SZ);
  txtPassword->setMaxLength(PWD_NAME_SZ);
  txtDatabase->setMaxLength(DB_NAME_SZ);
  txtHost->setMaxLength(HOST_NAME_SZ);
  txtPort->setMaxLength(PORT_NAME_SZ);

  txtUserName->setText((const char *)login->username);
  txtPassword->setText((const char *)login->password);
  txtDatabase->setText((const char *)login->database);
  txtHost->setText((const char *)login->host);
  txtPort->setText((const char *)login->port);

  btnOK->setText(i18n("&OK"));
  btnOK->setDefault(TRUE);
  btnCancel->setText(i18n("&Cancel"));

  connect(btnOK,SIGNAL(clicked()),this,SLOT(accept()));
  connect(btnCancel,SIGNAL(clicked()),this,SLOT(reject()));

  setFixedSize(width(),height());
  setCaption(i18n("Connect to Database"));
}

ConnectDialog::~ConnectDialog(){
}

void ConnectDialog::getLoginData(LoginStruct *login){
  login->username = (char *)txtUserName->text();
  login->password = (char *)txtPassword->text();
  login->database = (char *)txtDatabase->text();
  login->host = (char *)txtHost->text();
  login->port = (char *)txtPort->text();
}

























