#include"Kpgsql.h"
#include"OptionDialog.h"

// geisler@primus.baynet.de
// Sat May 23 14:51:46 MEST 1998

#ifndef _KPGSQL_CPP
#define _KPGSQL_CPP

kpgsql::kpgsql(QWidget *parent, const char *name)
     :KTopLevelWidget(name)
{
  situation=0;
  PGdiag=new PGdialog;
  PGdiag->PGhost=strdup("localhost");
  PGdiag->PGuser=strdup("postgres");
  PGdiag->PGport=strdup("5432");
  PGdiag->PGpassword=strdup("");
  PGdiag->PGdatabase=strdup("postgres");
  PGdiag->PGoptions=strdup("");
  GlDiag=new GlDialog;
  GlDiag->path=strdup("");
  GlDiag->default_table=strdup("default");

  initMenu();
  initToolBar();

  result_box=new KResultBox(this,"result");
  result_box->move(0,150);
  result_box->setGeometry(0,150,499,330);
  result_box->show();
  result_box->init(0,0);
  connect (result_box, SIGNAL (selected(int)), SLOT (listbox_clicked(int)));    

  entry = new KLined (this,"query"); 
  entry->setGeometry (90, 80, 410, 25);
  connect (entry, SIGNAL (returnPressed()), SLOT (entered_query()));

  label_query = new QLabel (entry,klocale->translate("SQL Query:"),this);
  label_query->resize(70,20);
  label_query->move(10,80);              
  label_status = new QLabel (entry,klocale->translate("Ready"),this);
  label_status->setFrameStyle(QFrame::Panel | QFrame::Sunken);
  label_status->resize(499,20);
  label_status->move(0,480);              

  PGsql=new sql();

  config = kapp->getConfig();
  config->setGroup("postgres");
#ifdef DEBUG
  cout << "host: " << config->readEntry("host",0L) << "\n"; 
  cout << "port: " << config->readEntry("port",0L) << "\n"; 
  cout << "user: " << config->readEntry("user",0L) << "\n"; 
  cout << "password: " << config->readEntry("password",0L) << "\n"; 
  cout << "database: " << config->readEntry("database",0L) << "\n"; 
  cout << "options: " << config->readEntry("options",0L) << "\n"; 
  cout << "path: " << config->readEntry("path",0L) << "\n"; 
  cout << "default-table: " << config->readEntry("defaulttable",0L) << "\n"; 
#endif

  if(config->readEntry("host",0L)) PGdiag->PGhost=strdup(config->readEntry("host",0L));
  if(config->readEntry("port",0L)) PGdiag->PGport=strdup(config->readEntry("port",0L));
  if(config->readEntry("user",0L)) PGdiag->PGuser=strdup(config->readEntry("user",0L));
  if(config->readEntry("password",0L)) PGdiag->PGpassword=strdup(config->readEntry("password",0L));
  if(config->readEntry("database",0L)) PGdiag->PGdatabase=strdup(config->readEntry("database",0L));
  if(config->readEntry("options",0L)) PGdiag->PGoptions=strdup(config->readEntry("options",0L));
  if(config->readEntry("path",0L)) GlDiag->path=strdup(config->readEntry("path",0L));
  if(config->readEntry("defaulttable",0L)) GlDiag->default_table=strdup(config->readEntry("defaulttable",0L));

};

kpgsql::~kpgsql()
{

};

void kpgsql::initMenu()
{
  QPopupMenu *file = new QPopupMenu;
  file->insertItem(  klocale->translate("SQL &Import"), ID_FILE_IMPORT );
  file->insertItem(  klocale->translate("SQL &Export"), ID_FILE_EXPORT);
  file->insertSeparator();
  file->insertItem(  klocale->translate("&Quit"), ID_FILE_QUIT);         
  connect (file, SIGNAL (activated (int)), this, SLOT (calls(int)));    

  QPopupMenu *option = new QPopupMenu;
  option->insertItem(klocale->translate("&Settings"), ID_OPTION_SETTINGS);
  option->insertItem(klocale->translate("S&ave settings"), ID_OPTION_SAVE_SETTINGS);
  connect (option, SIGNAL (activated (int)), this, SLOT (calls(int)));    

  QPopupMenu *help = new QPopupMenu;
  help->insertItem(klocale->translate("&About"), ID_HELP_ABOUT);
  connect (help, SIGNAL (activated (int)), this, SLOT (calls(int)));    

  menu = new KMenuBar( this );          
  CHECK_PTR( menu );
  menu->insertItem( klocale->translate("&File"), file );    
  menu->insertItem( klocale->translate("&Options"), option );    
  menu->insertSeparator();
  menu->insertItem( klocale->translate("&Help"), help );
  setMenu(menu);

  setMinimumSize(500,500);
  setGeometry(100,100,500,500);
}

void kpgsql::initToolBar()
{
  KIconLoader *iconloader = kapp->getIconLoader();      
  toolbar = new KToolBar(this,"toolbar");
  toolbar->setFullWidth(TRUE);
  toolbar->insertButton(iconloader->loadIcon("fileopen.xpm"),ID_TOOLBAR_IMPORT, SIGNAL(clicked(int)),this,SLOT(calls(int)),TRUE,klocale->translate("Import SQL File"));
  toolbar->insertButton(iconloader->loadIcon("filefloppy.xpm"),ID_TOOLBAR_EXPORT, SIGNAL(clicked(int)),this,SLOT(calls(int)),TRUE,klocale->translate("Export SQL File"));
  toolbar->insertButton(iconloader->loadIcon("noun.xpm"),ID_TOOLBAR_PG_USERS, SIGNAL(clicked(int)),this,SLOT(calls(int)),TRUE,klocale->translate("Show users"));
  toolbar->insertButton(iconloader->loadIcon("can.xpm"),ID_TOOLBAR_PG_DATABASE, SIGNAL(clicked(int)),this,SLOT(calls(int)),TRUE,klocale->translate("Show database"));
  toolbar->insertButton(iconloader->loadIcon("tab.xpm"),ID_TOOLBAR_PG_TYPES, SIGNAL(clicked(int)),this,SLOT(calls(int)),TRUE,klocale->translate("Show tables"));
  toolbar->setBarPos(KToolBar::Top);
  enableToolBar(KToolBar::Toggle, addToolBar(toolbar));
}

void kpgsql::calls(int option)
{
  situation=0;
#ifdef DEBUG
cout << "option: " << option << "\n";
#endif
  switch(option)
  {
    case ID_FILE_IMPORT : 
    {
#ifdef DEBUG
cout << "ID_FILE_IMPORT\n";
#endif
      QString fileName = QFileDialog::getOpenFileName(GlDiag->path,"*.sql",this);
      if(!fileName.isEmpty())
      {
        import_clicked(fileName);
        label_status->setText("Entries imported"); 
      };
      break;
    };
    case ID_FILE_EXPORT : 
    {
#ifdef DEBUG
cout << "ID_FILE_EXPORT\n";
#endif
      QString fileName = QFileDialog::getSaveFileName(GlDiag->path,"*.sql",this);
      if(!fileName.isEmpty())
      {
        export_clicked(fileName);
        label_status->setText("Entries exported"); 
      };
      break;
    };
    case ID_FILE_QUIT : 
    {
      kapp->quit();
#ifdef DEBUG
cout << "ID_FILE_QUIT\n";
#endif
      break;
    }; 
    case ID_OPTION_SETTINGS : 
    {
#ifdef DEBUG
cout << "ID_OPTION_SETTINGS\n";
#endif
      OptionDialog *option_diag;
      option_diag=new OptionDialog();
      option_diag->setData(PGdiag,GlDiag);
      option_diag->show();       
      break;
    }; 
    case ID_OPTION_SAVE_SETTINGS : 
    {
#ifdef DEBUG
cout << "ID_OPTION_SAVE_SETTINGS\n";
#endif
      config = kapp->getConfig();
      config->setGroup("postgres");
      config->writeEntry("host",PGdiag->PGhost,true,false,false); 
      config->writeEntry("port",PGdiag->PGport,true,false,false); 
      config->writeEntry("user",PGdiag->PGuser,true,false,false); 
      config->writeEntry("password",PGdiag->PGpassword,true,false,false); 
      config->writeEntry("database",PGdiag->PGdatabase,true,false,false); 
      config->writeEntry("options",PGdiag->PGoptions,true,false,false); 
      config->writeEntry("path",GlDiag->path,true,false,false); 
      config->writeEntry("defaulttable",GlDiag->default_table,true,false,false); 
      config->sync();
      break;
    }; 
    case ID_TOOLBAR_PG_USERS : 
    {
#ifdef DEBUG
cout << "ID_TOOLBAR_PG_USERS\n";
#endif
      query("select * from pg_user");
      table = strdup("pg_user");
      situation=ID_TOOLBAR_PG_USERS;
      break;
    }; 
    case ID_TOOLBAR_PG_DATABASE : 
    {
#ifdef DEBUG
cout << "ID_TOOLBAR_PG_DATABASE\n";
#endif
      query("select * from pg_database");
      table = strdup("pg_database");
      situation=ID_TOOLBAR_PG_DATABASE;
      break;
    }; 
    case ID_TOOLBAR_PG_TYPES : 
    {
#ifdef DEBUG
cout << "ID_TOOLBAR_PG_TYPES\n";
#endif
      query("select * from pg_type");
      table = strdup("pg_type");
      situation=ID_TOOLBAR_PG_TYPES;
      break;
    }; 
    case ID_HELP_ABOUT : 
    {
#ifdef DEBUG
cout << "ID_HELP_ABOUT\n";
#endif
     QString str;
     str.sprintf( klocale->translate("KPGsql 0.0.8 \n\nby Markus Geisler (geisler@primus.baynet.de)") );
     KMsgBox::message( 0, klocale->translate("About KPGsql"),
                       (const char *)str,
                       KMsgBox::INFORMATION, klocale->translate("Close") );   
      situation=ID_HELP_ABOUT;
      break;
    }; 
  };
}

void kpgsql::entered_query()
{
  query(strdup(entry->text()));
  situation=ID_ENTERED_QUERY;
}

void kpgsql::query(char *tmp_str)
{
  char *str;
  str=strdup(tmp_str);
#ifdef DEBUG
cout << "making query : " << str << "\n";
#endif

  if(!strlen(PGdiag->PGhost))
  {
    KMsgBox *info = new KMsgBox(this,0,0,1,"OK",0,0,0);
    info->message(this,"Error","Host-Field is empty\nChange in Options/Settings",1,"OK");
  }
  else
  if(!strlen(PGdiag->PGport))
  {
    KMsgBox *info = new KMsgBox(this,0,0,1,"OK",0,0,0);
    info->message(this,"Error","Port-Field is empty\nChange in Options/Settings",1,"OK");
  }
  else
  if(!strlen(PGdiag->PGuser))
  {
    KMsgBox *info = new KMsgBox(this,0,0,1,"OK",0,0,0);
    info->message(this,"Error","User-Field is empty\nChange in Options/Settings",1,"OK");
  }
  else
  if(!strlen(PGdiag->PGpassword))
  {
    KMsgBox *info = new KMsgBox(this,0,0,1,"OK",0,0,0);
    info->message(this,"Error","Password-Field is empty\nChange in Options/Settings",1,"OK");
  }
  else
  if(!strlen(PGdiag->PGdatabase))
  {
    KMsgBox *info = new KMsgBox(this,0,0,1,"OK",0,0,0);
    info->message(this,"Error","Database-Field is empty\nChange in Options/Settings",1,"OK");
  }
  else
  {
    if(situation!=QUERY_NOT_SHOWN)
    {
      delete result_box;
      result_box=new KResultBox(this,"result");
      result_box->move(0,150);
      result_box->setGeometry(0,150,width()-1,height()-170);
      PGsql->setData(PGdiag->PGhost,PGdiag->PGport,PGdiag->PGuser,PGdiag->PGpassword,PGdiag->PGdatabase,result_box);
      PGsql->db_connect();
      PGsql->reload(str);
      label_status->setText(PGsql->db_execute()); 
      PGsql->db_printresult();
      PGsql->db_exit();
      result_box->show();
      result_box->showCells();
      connect (result_box, SIGNAL (selected(int)), SLOT (listbox_clicked(int)));    
    } 
    else
    {
 PGsql->setData(PGdiag->PGhost,PGdiag->PGport,PGdiag->PGuser,PGdiag->PGpassword,PGdiag->PGdatabase,result_box);
      PGsql->db_connect();
      PGsql->reload(str);
      label_status->setText(PGsql->db_execute()); 
      PGsql->db_exit();
    };
  };

#ifdef DEBUG
cout << "PGhost: " << PGdiag->PGhost << "\n";
cout << "PGport: " << PGdiag->PGport << "\n";
cout << "PGuser: " << PGdiag->PGuser << "\n";
cout << "PGpassword: " << PGdiag->PGpassword << "\n";
#endif

};

void kpgsql::listbox_clicked(int item)
{
  char tmp[1000];
#ifdef DEBUG
cout << "in listbox_clicked\n";
cout << "Listbox clicked at row: " << item << "\n";
#endif
  if(situation==ID_TOOLBAR_PG_TYPES)
  {
#ifdef DEBUG
    cout << "Item: " << result_box->getItem(item,0) << "\n";
#endif
    sprintf(tmp,"select * from %s",result_box->getItem(item,0)); 
    query(tmp);
    situation=0;
  };
};

void kpgsql::export_clicked(const char *filename)
{
  int i,j;
  char tmp[10000];

  fp = new QFile(filename);
  fp->open(IO_WriteOnly);

  label_status->setText("running...."); 

  for(i=1;i!=result_box->numRows();i++)
  {
    sprintf(tmp,"insert into %s values (",GlDiag->default_table);
    for(j=0;j!=result_box->numCols();j++)
    { 
      if(j>0)
      {
        sprintf(tmp,"%s,'%s'",tmp,result_box->getItem(i,j)); 
      }
      else 
      {
        sprintf(tmp,"%s'%s'",tmp,result_box->getItem(i,j));
      };
    };
    sprintf(tmp,"%s);\n",tmp);
    fp->writeBlock(tmp,strlen(tmp));
  };
  fp->close();
};

void kpgsql::import_clicked(const char *filename)
{
  char tmp[10000];

  fp = new QFile(filename);
  fp->open(IO_ReadOnly);
  
  situation=QUERY_NOT_SHOWN;
  repaint();

  while(fp->readLine(tmp,10000)) 
  {
    query(tmp);  
    repaint();
  };
  
  situation=0;

  fp->close();
};

void kpgsql::resizeEvent(QResizeEvent *e)
{
#ifdef DEBUG
cout << "Window has been resized\n";
cout << "New Size: " << width() << "\n";
cout << "New Height: " << height() << "\n";
#endif
  result_box->setGeometry(0,150,width()-1,height()-170);
  label_status->resize(width()-1,20);
  label_status->move(0,height()-20);              
  updateRects();
};

int main(int argc, char **argv) 
{ 
  KApplication a(argc,argv,"KPGsql");
  kpgsql w;
  a.setMainWidget(&w);             
  w.show();
  return a.exec();
}

#include"Kpgsql.moc"

#endif
