#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

/* Postgresql includes. enables PGfunctions */ 
#include "/usr/local/pgsql/include/libpq-fe.h"
#include "/usr/local/pgsql/include/libpq-int.h"


#define FIELD_LEN 2048
#define NV_PAIRS 200

typedef struct name_value_st {
       char name[FIELD_LEN + 1];
       char value[FIELD_LEN + 1];
} name_value;

name_value name_val_pairs[NV_PAIRS];

static int get_input(void);
static void send_error(char *error_text);
static void load_nv_pair(char *tmp_buffer, int nv_entry_number_to_load);
static char x2c(char *what);
static void unescape_url(char *url);

static void html_content(void);
static void html_start(const char *title, const char *image);
static void html_head(int level, const char *header_text);
static void html_body(const char *text);
static void html_end(void);
    
static void html_content(void)
{
      printf("Content-type: text/html\r\n\r\n");
}

static void html_start(const char *title, const char *image)
{
      printf("<HTML>\r\n");
      printf("<HEAD>\r\n");
      printf("<TITLE>%s</TITLE>\r\n", title);
      printf("</HEAD>\r\n");
      printf("<BODY LINK=\"#0000FF\" BACKGROUND=\"%s\">\r\n", image);
}

static void html_head(int level, const char *header_text)
{
      if (level < 1 || level > 6) return;
      if (!header_text) return;
      printf("<H%d>%s</H%d>\r\n", level, header_text, level);
}

static void html_body(const char *text)
{
      printf("%s\r\n", text);
}


static void html_end(void)
{
      printf("<CENTER><A HREF=/>BACK</A></CENTER>\r\n\r\n");
      printf("</FORM>\r\n\r\n");
      printf("</BODY>\r\n\r\n");
      printf("</HTML>\r\n\r\n");
}

static int get_input(void)
{
     int nv_entry_number = 0;
     int got_data = 0;
     char *ip_data = 0;
     int ip_length = 0;
     char tmp_buffer[(FIELD_LEN * 2) + 2];
     int tmp_offset = 0;
     char *tmp_char_ptr;
     int chars_processed = 0;

     if (strcmp(getenv("REQUEST_METHOD"), "POST") == 0) {
       ip_length = atoi(getenv("CONTENT_LENGTH"));
       ip_data = malloc(ip_length + 1); /* allow the NULL */
       if (fread(ip_data, 1, ip_length, stdin) != ip_length) {
         send_error("BAD Read from stdin");
         return(0);
       }

       ip_data[ip_length] = '\0';
       got_data = 1;
    }

    if (strcmp(getenv("REQUEST_METHOD"), "GET") == 0) {
      ip_length = strlen(getenv("QUERY_STRING"));
      ip_data = malloc(ip_length + 1);
      strcpy(ip_data, getenv("QUERY_STRING"));
      ip_data[ip_length] = '\0';
      got_data = 1;
    }

    if (!got_data) {
      send_error("No DATA!!! No Data Received");
      return(0);
    }

    if (ip_length <= 0 ) {
      send_error("Input length not > 0");
      return(0);
    }

    memset(name_val_pairs, '\0', sizeof(name_val_pairs));
    tmp_char_ptr = ip_data;
    while (chars_processed <= ip_length && nv_entry_number < NV_PAIRS) {
         tmp_offset = 0;
         while (*tmp_char_ptr && *tmp_char_ptr != '&' && tmp_offset < FIELD_LEN) {
         tmp_buffer[tmp_offset] = *tmp_char_ptr;
         tmp_offset++;
         tmp_char_ptr++;
         chars_processed++;
         }
         tmp_buffer[tmp_offset] = '\0';

        /* decode and load */

        load_nv_pair(tmp_buffer, nv_entry_number);

         /* move to next record */

         tmp_char_ptr++;
         nv_entry_number++;
    }
    return(1);
}


static void send_error(char *error_text)
{
      printf("Content-type: text/plain\r\n");
      printf("\r\n");
      printf("Whoops:- %s\r\n", error_text);
}

static void load_nv_pair(char *tmp_buffer, int nv_entry)
{
      int chars_processed = 0;
      char *src_char_ptr;
      char *dest_char_ptr;

     /* part before '=' */
      src_char_ptr = tmp_buffer;
      dest_char_ptr = name_val_pairs[nv_entry].name;
      while(*src_char_ptr && *src_char_ptr != '=' && chars_processed < FIELD_LEN) {
           /* change '+' to '' */
           if (*src_char_ptr == '+') *dest_char_ptr = ' ';
           else *dest_char_ptr = *src_char_ptr;
           dest_char_ptr++;
           src_char_ptr++;
           chars_processed++;
      }
     
      /* skip '=' */
      if (*src_char_ptr == '=') {
        /*get the part after the '=' */
        src_char_ptr++;
        dest_char_ptr = name_val_pairs[nv_entry].value;
        chars_processed = 0;
        while(*src_char_ptr && *src_char_ptr != '=' && chars_processed < FIELD_LEN) {
             /* change '+' to ' ' */
             if (*src_char_ptr == '+') *dest_char_ptr = ' ';
             else *dest_char_ptr = *src_char_ptr;
             dest_char_ptr++;
             src_char_ptr++;
             chars_processed++;
        }
      }
    
      /* now to decode %XX characters from the fields.. */
      unescape_url(name_val_pairs[nv_entry].name);
      unescape_url(name_val_pairs[nv_entry].value);
}

static void unescape_url(char *url)
{
      register int x;
      register int y;

      for (x=0,y=0; url[y]; ++x,++y) {
         if ((url[x] = url[y]) == '%') {
           url[x] = x2c(&url[y+1]);
           y +=2;
         }
      }
      url[x] = '\0';
}

static char x2c(char *what)
{
      register char digit;
      digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
      digit *= 16;
      digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));
      return(digit);
}
