/* Call log processor/Database front end libpq      */
/* will be used. This program will take HTML input  */
/* and windows input (X/9x) and added it to the     */
/* prob_entry database the users database is        */ 
/* read-only and only grabs the user info...        */
/* loc/ext/dept etc. we might even want to do a bit */
/* of inline documentation... this is a big program */
/* estimate 5000 lines of new code. Good Luck       */

/* this is the headers for all web programs (default includes)*/
#include "web.h"

/* some basic handlers */
void exit_nicely(PGconn *conn);

/* basic table structs... for reading/writing the database */
struct prob_entry {
       int prob_num;
       char prob_desc[2048];
       char prob_type[128];
       char username[128];
       char useremail[128];
       char telephone[15];
       char timeentered[17];
       char closed[1];
       char prob_user[128];
       char prob_short_desc[128];
       char timeclosed[17];
       char userid[11];
} problem;

struct users {
       char ssn[11];
       char lname[50];
       char fname[50];
       char mi[2];
       char extension[10];
       char location[128];
       char email[128];
       char hardware[128];
       char notes[255];
       char username[128];
       char timeentered[17];
} user;

/* Startup and run-baby!        */
int main(int argc, char *argv[]) {

/* counters and field options */
    int nv_entry_number = 0, i, j, x, ntuples, nFields;

/* Database connection options and other values */
    char *pghost, *pgport, *pgoptions, *pgtty, *dbName, *login, *pwd;
/* full table record buffer<jifc> */    
    char nField[256], query[256], tmp_buffer1[FIELD_LEN + 1], tmp_buffer2[FIELD_LEN + 1];

    struct tm *tm_ptr;
    time_t timeval;    

    PGconn *conn;
    PGresult *res;    
    
/* set options for database connection */
   pghost = "192.168.1.1";
   pgport = NULL;
   pgoptions = NULL;
   pgtty = NULL;
   dbName = "helldesk";  
   login = "nobody";
   pwd = "";
/* this is a check to see if the web page has data returning to the program */
    if (!get_input()) {
      exit(EXIT_FAILURE);
    }

/* setup time functions for timestamping the problem entries */
    (void) time(&timeval);
    tm_ptr = localtime(&timeval);

    sprintf(problem.timeentered,"%02d%02d%04d %02d:%02d:%02d",
            tm_ptr->tm_mon+1, tm_ptr->tm_mday, tm_ptr -> tm_year,
            tm_ptr->tm_hour, tm_ptr->tm_min,tm_ptr->tm_sec);

    i = 0;
    
/* read and decode the data. Also, insert it into the struct varibles */
/* note that the field names could be used instead of the nested if   */
/* that does not mean it is better to do so. might cut the time down  */
    while (name_val_pairs[nv_entry_number].name[0] != '\0') {
         sprintf(tmp_buffer1,"%s",name_val_pairs[nv_entry_number].name);
         sprintf(tmp_buffer2,"%s",name_val_pairs[nv_entry_number].value);
         if (i == 0) {
          sprintf(user.username, name_val_pairs[nv_entry_number].value);
         } else {
          sprintf(user.notes, name_val_pairs[nv_entry_number].value);
         }
         nv_entry_number++;
         i++;
    }
/* database connection and check if true */
   conn = PQsetdbLogin(pghost, pgport, pgoptions, pgtty, dbName, login, pwd);
      if (PQstatus(conn) == CONNECTION_BAD) {
        printf("Content type: text/html\r\n\r\n");
        printf("Connection to database %s failed. \n", dbName);
        printf("%s", PQerrorMessage(conn));
        printf("Connection not made: please report this error to Sys Admin\r\n");
        exit_nicely(conn);
      }

/* Begin the transaction and make SURE that the database is open */
    res = PQexec(conn,"BEGIN");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("BEGIN FAILED!!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
    sprintf(query,"DECLARE mycursor CURSOR FOR SELECT * FROM users WHERE username = '%s'",user.username);
    res = PQexec(conn, query);
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("SELECT FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
/* This grabs the user information and adds it to hidden fields  */
/* in the helpdesk HTML document                                 */
    res = PQexec(conn, "FETCH ALL in mycursor");
    if (PQresultStatus(res) != PGRES_TUPLES_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("FETCH FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    ntuples = PQntuples(res);
    nFields = PQnfields(res);
    for (i = 0; i < PQntuples(res); i++) {
       for (j = 0; j < nFields; j++){
          if (j == 0) {
            sprintf(nField,PQgetvalue(res,i,j));
            for (x = 0; x < 10; x++){
               user.ssn[x] = nField[x];
            }
          } else if (j == 1) {
            sprintf(user.lname,PQgetvalue(res,i,j));
          } else if (j == 2) {
            sprintf(user.fname,PQgetvalue(res,i,j));
          } else if (j == 3) {
            sprintf(user.mi,PQgetvalue(res,i,j));
          } else if (j == 4) {
            sprintf(user.extension,PQgetvalue(res,i,j));
          } else if (j == 5) {
            sprintf(user.location,PQgetvalue(res,i,j));
          } else if (j == 6) {
            sprintf(user.email,PQgetvalue(res,i,j));
          } else if (j == 7) {
            sprintf(user.hardware,PQgetvalue(res,i,j));
          } else if (j == 8) {
            sprintf(user.notes,PQgetvalue(res,i,j));
          } else if (j == 9) {
            sprintf(user.username,PQgetvalue(res,i,j));
          } else {
          }
       }
    }
    PQclear(res);

    res = PQexec(conn, "CLOSE mycursor");
    PQclear(res);

    res = PQexec(conn, "END");
    if (PQresultStatus(res) != PGRES_COMMAND_OK) {
      printf("Content type: text/html\r\n\r\n");
      printf("END FAILED!");
      printf("%s", PQerrorMessage(conn));
      printf("Notify the System Administrator");
      exit_nicely(conn);
    }
    PQclear(res);
    PQfinish(conn);

/* this section is the dynamic html returned to the client */
/* not the prettiest way to do this, but it works, which counts*/
    html_content();
    html_start("Helpdesk / Trouble Call Entry", "/brickwall.gif");
    html_body("<form action=\"/cgi-bin/helldesk\" METHOD=POST>");
    html_body("<TABLE WIDTH=400 BORDER=3 CELLPADDING=0 CELLSPACING=0>");
    html_body("<COL WIDTH=1><COL WIDTH=81><COL WIDTH=1><COL WIDTH=106>");
    html_body("<COL WIDTH=386><COL WIDTH=2><COL WIDTH=2><COL WIDTH=2>");
    html_body("<COL WIDTH=2><COL WIDTH=2><TR VALIGN=TOP><TD WIDTH=1>");
    html_body("<P><BR></TD><TD COLSPAN=4 WIDTH=400>");
    html_body("<H2>Trouble Call Log Center</H2>");
    html_body("</TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD></TR><TR VALIGN=TOP>");
    html_body("<TD WIDTH=1><P><BR></TD><TD COLSPAN=4 WIDTH=450>");
    html_body("<P><FONT FACE=\"Arial\">");
    html_body("This is a trouble/service call entry form...");
    html_body(" please fill out ALL fields.</FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD></TR><TR VALIGN=TOP>");
    html_body("<TD WIDTH=1><P><BR></TD><TD COLSPAN=4>");
    html_body("<H3>NOTE: Please be very DESCRIPTIVE of the problem ");
    html_body("in the description field</H3></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR>");

    html_body("<TR VALIGN=TOP><TD WIDTH=1><P><BR>");
    html_body("</TD><TD COLSPAN=2 WIDTH=82><P>");
    html_body("<FONT FACE=\"Arial\">Short Description</FONT></P><br></TD>");
    html_body("<TD COLSPAN=2 WIDTH=498><P><FONT FACE=\"Arial\"><FONT SIZE=1>");
    html_body("<input type=text name=\"prob_short_desc\" maxlength=128 size=74 length=128>");
    html_body("</FONT></FONT></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR>");

    html_body("<TR VALIGN=TOP><TD WIDTH=1><P><BR>");
    html_body("</TD><TD COLSPAN=2 WIDTH=82><P>");
    html_body("<FONT FACE=\"Arial\">Problem Description</FONT></P>");
    html_body("<P><BR><BR></P><P><BR><BR></P><P><BR></TD>");
    html_body("<TD COLSPAN=2 WIDTH=498><P><FONT FACE=\"Arial\">");
    html_body("<FONT SIZE=1><TEXTAREA ROWS=9 COLS=71 NAME=\"prob_desc\">");
    html_body("</TEXTAREA></FONT></FONT></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR>");

    html_body("<TR VALIGN=TOP><TD ROWSPAN=8 WIDTH=1><P><BR></TD>");
    html_body("<TD ROWSPAN=8 COLSPAN=2 WIDTH=82><P>");
    html_body("<FONT FACE=\"Arial\">Problem Type</FONT></P>");
    html_body("<P><BR></TD><TD WIDTH=106><P><FONT FACE=\"Arial\">");
    html_body("<FONT SIZE=1><INPUT TYPE=RADIO CHECKED NAME=\"prob_type\"");
    html_body("VALUE=\"AFW Prob\"></FONT></FONT></TD>");
    html_body("<TD WIDTH=386><P><FONT FACE=\"Arial\">American Fundware</FONT>");
    html_body("</TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD></TR><TR VALIGN=TOP>");
    html_body("<TD WIDTH=106><P><FONT FACE=\"Arial\"><FONT SIZE=1>");
    html_body("<INPUT TYPE=RADIO NAME=\"prob_type\" VALUE=\"Printer\">");
    html_body("</FONT></FONT></TD><TD WIDTH=386><P><FONT FACE=\"Arial\">");
    html_body("Printer (Include Queue Name and Location)</FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD></TR><TR VALIGN=TOP>");
    html_body("<TD WIDTH=106><P><FONT FACE=\"Arial\"><FONT SIZE=1>");
    html_body("<INPUT TYPE=RADIO NAME=\"prob_type\" VALUE=\"PC/Software prob\"></FONT></FONT></TD>");
    html_body("<TD WIDTH=386><P><FONT FACE=\"Arial\">PC / Software problem");
    html_body("</FONT></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2>");
    html_body("</TD><TD WIDTH=2></TD><TD WIDTH=2></TD></TR>");
    html_body("<TR VALIGN=TOP>");
    html_body("<TD WIDTH=106>");
    html_body("<P><FONT FACE=\"Arial\"><FONT SIZE=1>");
    html_body("<INPUT TYPE=RADIO NAME=\"prob_type\" VALUE=\"NOVELL PROBLEM\">");
    html_body("</FONT></FONT></TD><TD WIDTH=386><P><FONT FACE=\"Arial\">Novell Netware Connectivity");         html_body("Problem</FONT></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD></TR><TR VALIGN=TOP><TD WIDTH=106>");
    html_body("<P><FONT FACE=\"Arial\"><FONT SIZE=1><INPUT TYPE=RADIO NAME=\"prob_type\"");         html_body("VALUE=\"EMAILPROB\"></FONT></FONT></TD>");
    html_body("<TD WIDTH=386><P><FONT FACE=\"Arial\">E-Mail Problem(Access/Password)</FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR><TR VALIGN=TOP><TD WIDTH=106><P><FONT FACE=\"Arial\">");
    html_body("<FONT SIZE=1><INPUT TYPE=RADIO NAME=\"prob_type\" VALUE=\"SYSTEMSLOW\"></FONT></FONT></TD>");
    html_body("<TD WIDTH=386><P><FONT FACE=\"Arial\">System slowness problem (Include Application Name)</FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR>");
    
    html_body("<TR VALIGN=TOP><TD WIDTH=106><P><FONT FACE=\"Arial\">");
    html_body("<FONT SIZE=1><INPUT TYPE=RADIO NAME=\"prob_type\" VALUE=\"NETWORK\"></FONT></FONT></TD>");
    html_body("<TD WIDTH=386><P><FONT FACE=\"Arial\">Network Problems</FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR>");
    html_body("<TR VALIGN=TOP><TD WIDTH=106><P><FONT FACE=\"Arial\">");
    html_body("<FONT SIZE=1><INPUT TYPE=RADIO NAME=\"prob_type\" VALUE=\"OTHER\"></FONT></FONT></TD>");
    html_body("<TD WIDTH=386><P><FONT FACE=\"Arial\">Other (Not Listed here)</FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR>");

    html_body("<TR VALIGN=TOP><TD WIDTH=1><P><BR></TD>");
    html_body("<TD COLSPAN=4 WIDTH=586><H3><FONT FACE=\"Arial\">Personal Information</FONT></H3>");
    html_body("</TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR><TR VALIGN=TOP><TD WIDTH=1><P><BR></TD>");
    html_body("<TD WIDTH=81><P><FONT FACE=\"Arial\">First Name</FONT></TD>");
    html_body("<TD COLSPAN=3 WIDTH=499><P><FONT FACE=\"Arial\"><FONT SIZE=1><BR>");
    printf("<INPUT TYPE=HIDDEN SIZE=25 NAME=\"username\" VALUE=\"%s\"> %s", user.username, user.fname);
    html_body("</FONT></FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR><TR VALIGN=TOP><TD WIDTH=1><P><BR>");
    html_body("</TD><TD WIDTH=81><P><FONT FACE=\"Arial\">Last Name</FONT></TD>");
    html_body("<TD COLSPAN=3 WIDTH=499><P><FONT FACE=\"Arial\"><FONT SIZE=1><BR>");
    printf("<INPUT TYPE=Hidden SIZE=24 NAME=\"username\" VALUE=\"%s %s\"> %s",
             user.fname,user.lname,user.lname);
    html_body("</FONT></FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR><TR VALIGN=TOP><TD WIDTH=1><P><BR></TD>");
    html_body("<TD WIDTH=81><P><FONT FACE=\"Arial\">Telephone</FONT></TD>");
    html_body("<TD COLSPAN=3 WIDTH=499><P><FONT FACE=\"Arial\"><FONT SIZE=1>");
    printf("<INPUT TYPE=HIDDEN SIZE=24 NAME=\"telephone\" VALUE=\"%s\">%s", user.extension,user.extension);
    html_body("</FONT></FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR><TR VALIGN=TOP><TD WIDTH=1><P><BR>");
    html_body("</TD><TD WIDTH=81><P><FONT FACE=\"Arial\">E-Mail</FONT>");
    html_body("</TD><TD COLSPAN=3 WIDTH=499><P><FONT FACE=\"Arial\"><FONT SIZE=1>");
    printf("<INPUT TYPE=Hidden SIZE=25 NAME=\"useremail\" VALUE=\"%s\">%s</FONT></FONT>",user.email,user.email);
    printf("<INPUT Type=hidden size=11 name=\"userid\" value=\"%s\"></TD>", user.ssn);
    html_body("<BR><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR><TR VALIGN=TOP><TD COLSPAN=2 WIDTH=500><P><BR><FONT FACE=\"Arial\">");
    html_body("<FONT SIZE=1>");
    html_body("<INPUT TYPE=SUBMIT NAME=\"submit_Button\" VALUE=\"Submit\"></FONT></FONT></TD>");
    html_body("<TD COLSPAN=1 WIDTH=250></TD><TD COLSPAN=2 WIDTH=500><P><BR><FONT FACE=\"Arial\"><FONT SIZE=1>");
    html_body("<INPUT TYPE=RESET NAME=\"Rest_Form_button\" VALUE=\"Reset\"></FONT></FONT></TD>");
    html_body("<TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD><TD WIDTH=2></TD>");
    html_body("<TD WIDTH=2></TD></TR></TABLE>");
    html_end();
    
    exit(EXIT_SUCCESS);
}

void exit_nicely(PGconn *conn){   
    
   PQfinish(conn);
   exit(1);
}
