#include <stdio.h>
#include <string.h>

#define MAX_FIELDS 64

char *freadln(FILE*);
char *caps(char[]);
char *getval(char[], FILE*, int, FILE*);
int countcomma(char[]);

struct tables {
	char name[17];
	int  no_fields;
	char title[256];
	char summary[128];
	struct field {
		char name[32];
		char type[10];	
		int length;
		int primary_key;
		char foreign[128]; } field[MAX_FIELDS];
		}; 

void sqlout(struct tables,FILE*);
void cout(struct tables,FILE*);

char pghost[128];
char pgdatabase[32];
char pgport[10];
char pgoptions[10];
char pgtty[10];
char cgi_url[128];
char doc_url[128];
char pgdir[256];
char httpdhome[256];
char rootname[256];

main (int argc, char *argv[])
{
	FILE *input,*app,*sql;
	char line[256],cgi[256],appname[256],sqlname[256];
	int a,done,b,c,tables=1;
	char numb[6];
	struct tables table[64];
	if (argc!=2) {
		printf("Usage: defgen <filename.def>\n");
		exit(1);
		}
	input=fopen(argv[1],"rt");
	if (input==NULL) {
		fprintf(stderr,"Cannot open %s\n",argv[1]);
		exit(1);
		}
	for (a=0; ((a<strlen(argv[1]))&&(argv[1][a]!='.')); a++) {
		rootname[a]=argv[1][a];
		} 
	strcpy(appname,rootname);
	strcat(appname,".app");
	strcpy(sqlname,rootname);
	strcat(sqlname,".sql");
	app=fopen(appname,"wt");
	if (input==NULL) {
		fprintf(stderr,"Cannot create %s\n",appname);
		exit(1);
		}
	sql=fopen(sqlname,"wt");
	if (input==NULL) {
		fprintf(stderr,"Cannot create %s\n",sqlname);
		exit(1);
		}
	

	strcpy(pgdir,getval("PGDIR",input,1,app));
	strcpy(httpdhome,getval("HTTPD-DIR",input,1,app));
	strcpy(pghost,getval("PGHOST",input,1,app));
	strcpy(pgdatabase,getval("PGDATABASE",input,1,app));
	strcpy(pgport,"NULL");
	strcpy(pgoptions,"NULL");
	strcpy(pgtty,"NULL");
	strcpy(cgi_url,getval("CGI-URL",input,1,app));
	strcpy(doc_url,getval("DOC-URL",input,1,app));
/* GLOBAL   */
	fprintf(app,"[GLOBAL]\n");
	fprintf(app,"	SET pgdir AS \"%s\"\n", pgdir);
	fprintf(app,"	SET pghost AS \"%s\"\n", pghost);
	fprintf(app,"	SET pgdatabase AS \"%s\"\n", pgdatabase);
	fprintf(app,"	SET httpd-dir AS \"%s\"\n", httpdhome);
	fprintf(app,"	SET cgi-url AS \"%s\"\n", cgi_url);
	fprintf(app,"	SET doc-url AS \"%s\"\n", doc_url);
	fprintf(app,"	SET src-dir AS \".\"\n\n");


	while(!feof(input)) {
		for (a=0; a<17; a++) table[tables].name[a]=0;
		strcpy(table[tables].name,getval("TABLE-NAME",input,tables,app));
		if (strlen(table[tables].name)>1) {
			strcpy(table[tables].title,getval("SCREEN-TITLE",input,tables,app));
			strcpy(table[tables].summary,getval("SUMMARY-LIST",input,tables,app));
			getval("FIELDS",input,tables,app);
			a=0;
			done=0;
			do {
				strcpy(line,freadln(input));
				if ((line[0]=='E')&&(line[1]=='N')&&(line[2]=='D')) done=1;
				if (!done) {
					for (b=0; ((b<strlen(line))&&(line[b]<97)); b++); 
					for (c=b; ((c<strlen(line))&&(line[c]!=' ')); c++) table[tables].field[a].name[c-b]=line[c];
					for (c=c; ((c<strlen(line))&&(line[c]<'a')); c++);
					for (b=c; ((b<strlen(line))&&(line[b]!=' ')&&(line[b]!='(')); b++) table[tables].field[a].type[b-c]=line[b];
					if (line[b]=='(') {
						strcpy(numb,"       ");
						for (c=b+1; ((b<strlen(line))&&(line[c]!=')')); c++) numb[c-b-1]=line[c]; 
						table[tables].field[a].length=atoi(numb);
						}
					else table[tables].field[a].length=1;
					for (c=b; c<strlen(line); c++) if (line[c]=='*') table[tables].field[a].primary_key=1;
					for (c=0; c<128; c++) table[tables].field[a].foreign[c]=0;
					for (c=b; c<strlen(line); c++) if (line[c]=='$') {
						c+=2;
						for (b=c; b<strlen(line); b++) table[tables].field[a].foreign[b-c]=line[b];   
						}
					a++;
					}
			} while (!done);
		table[tables].no_fields=a;
		printf("Parsing Table %d: %s\n",tables,table[tables].name);
		for (a=0; a<table[tables].no_fields; a++) printf("  Attribute: %d, %s %s %d\n",a,table[tables].field[a].name,table[tables].field[a].type,table[tables].field[a].length);
		sqlout(table[tables],sql);		
		cout(table[tables],app);
		b=0;
		for (a=0; ((a<strlen(cgi_url))&&(b<3)); a++) {
			if (cgi_url[a]=='/') b++;
			}
		for (b=a; b<strlen(cgi_url); b++) cgi[b-a]=cgi_url[b];
		tables++;
		}
	}	
	fclose(sql);
	fclose(input);
	fclose(app);
	
}

char *freadln(FILE *input)
{
	int a,c;
	char output[256];
	for (a=0; a<256; a++) output[a]=0;
	a=0;
	do {
		c=fgetc(input);
		output[a]=c;
		a++;
		} while((a<256) && (c!='\n') && (!feof(input))); 
	a--;
	output[a]=0;
	return(output);
}

char *getval(char* var1, FILE *input, int from, FILE *out)
{
	int a,b,done;
	char line[256],var[256];
	char output[256];
	strcpy(var,var1);
	fseek(input, 0, SEEK_SET);
	for (b=0; b<from; b++) {
		do  {
			strcpy(line,freadln(input));
			done=1;	
			for (a=0; a<strlen(var); a++) if (line[a]!=var[a]) done=0;
			} while ((!feof(input)) && (!done));
		}

	a++;
	if (done) {
		for (b=a; b<strlen(line); b++) output[b-a]=line[b];
		output[b-a]=0;  
		return(output);
		}
	else {
		printf("Can't find %s, exiting...\n",var);
		fprintf(out,"\n[]");
		exit(0);
		}
}

int countcomma(char* var1)
{
	int a,b;
	char var[256];
	strcpy(var,var1);
	b=0;
	for (a=0; a<strlen(var); a++) if (var[a]==',') b++;
	return(b);
}

char *caps(char* var1)
{
	int a;
	char var[256];
	strcpy(var, var1);
	for (a=0; a<strlen(var); a++) if (var[a]>=97) var[a]-=97-65;
	return(var);
}
		
void sqlout(struct tables table, FILE *sql)
{
	int a;
	fprintf(sql,"CREATE TABLE %s (\n",table.name);
	fprintf(sql,"	recnum int,\n");
	for (a=0; a<table.no_fields; a++) {
		fprintf(sql,"    %s %s",table.field[a].name,table.field[a].type);
		if (table.field[a].length>1) fprintf(sql,"(%d)",table.field[a].length);
		if (a<table.no_fields-1) fprintf(sql,",\n");
		else fprintf(sql,"); \n\n");
		}
}

void cout(struct tables table, FILE *cout) 
{
	char filename[32],foreign_field[32],foreign_table[32];
	char spare[256];
	int a,and,b,c,clear_result;
	fprintf(cout,"[MODULE %s]\n",table.name);
	fprintf(cout,"	SET default_process AS \"clear\"\n\n");

/* FORM */
	fprintf(cout,"[FORM %s]\n",table.name);
	fprintf(cout,"	SET title AS \"%s\"\n", table.title);
	fprintf(cout,"	DEFINE FORM {\n");
	fprintf(cout,"		recnum : 10 : \"\" : HIDDEN\n");
	for (a=0; a<table.no_fields; a++) {
		if (strcmp("int",table.field[a].type)==0) table.field[a].length=10;
		if (strcmp("date",table.field[a].type)==0) table.field[a].length=12;
		if (strcmp("float",table.field[a].type)==0) table.field[a].length=12;
		fprintf(cout,"		%s : %d : \"%s: \" : ",table.field[a].name,table.field[a].length,table.field[a].name);
		if (table.field[a].foreign[0]!=0) fprintf(cout,"PICK PROCESS \"pick_%s\"\n",table.field[a].name);
		else fprintf(cout,"TEXT\n");
		}
	fprintf(cout,"		} IN COLUMN\n");
	fprintf(cout,"	DEFINE TOOLBAR {\n");
	fprintf(cout,"		\"ADD\" : ALL : PROCESS \"add\"\n");
	fprintf(cout,"		\"FIND\" : ALL : PROCESS \"find\"\n");
	fprintf(cout,"		\"UPDATE\" : DATA : PROCESS \"update\"\n");
	fprintf(cout,"		\"DELETE\" : DATA : PROCESS \"delete\"\n");
	fprintf(cout,"		\"CLEAR\" : ALL : PROCESS \"clear\"\n");
	fprintf(cout,"		\"EXIT\" : ALL : MENU \"%s\"\n",rootname);
	fprintf(cout,"		}\n\n");

/* SURE */
	fprintf(cout,"[FORM sure]\n");
	fprintf(cout,"	SET title AS \"Are you sure you want to delete ?\"\n");
	fprintf(cout,"	DEFINE FORM {\n");
	fprintf(cout,"		recnum : 10 : \"\" : HIDDEN\n");		
	for (a=0; a<table.no_fields; a++) if (table.field[a].primary_key==1) {
		if (strcmp("int",table.field[a].type)==0) table.field[a].length=10;
		if (strcmp("date",table.field[a].type)==0) table.field[a].length=12;
		fprintf(cout,"		%s : %d : \"%s: \" : TEXT\n",table.field[a].name,table.field[a].length,table.field[a].name);
		}
	fprintf(cout,"		}\n	DEFINE TOOLBAR {\n");
	fprintf(cout,"		\"YES\" : ALL : PROCESS \"yes\"\n");
	fprintf(cout,"		\"NO\" : ALL : PROCESS \"clear\"\n");	
	fprintf(cout,"		}\n\n");

/* ADD */
	fprintf(cout,"[PROCESS add]\n");
	fprintf(cout,"	DATA results\n");
	fprintf(cout,"	INT no_rows\n");
	fprintf(cout,"	INT new_recnum\n");
	fprintf(cout,"	SQL \"SELECT * FROM %s WHERE ",table.name);
	and=0;	
	for (a=0; a<table.no_fields; a++) if (table.field[a].primary_key==1) {
		if (and==1) fprintf(cout," AND"); 
		fprintf(cout," %s=$input.%s",table.field[a].name,table.field[a].name);
		and=1;
		}
	fprintf(cout,";\" TO results\n");
	fprintf(cout,"	ROWS results TO no_rows\n");
	fprintf(cout,"	IF no_rows > 0 THEN BEGIN\n");
	for (a=0; ((a<table.no_fields) && (table.field[a].primary_key!=1)); a++); 
	fprintf(cout,"		DISPLAY %s WITH input ERROR \"Duplicate Record\" ON %d\n",table.name,a+1);
	fprintf(cout,"		END\n");
	for (a=0; a<table.no_fields; a++) if (table.field[a].foreign[0]!=0) {
		fprintf(cout,"	SQL \"SELECT %s WHERE ",table.field[a].foreign);
		for (b=0; ((b<strlen(table.field[a].foreign))&&(table.field[a].foreign[b]!=' ')); b++) foreign_field[b]=table.field[a].foreign[b];
		foreign_field[b]=0;
		c=b;
		for (b=c; ((b<strlen(table.field[a].foreign))&&(table.field[a].foreign[b]!=' ')); b++) foreign_table[b-c]=table.field[a].foreign[b];
		c=b;
		for (b=c; b<strlen(table.field[a].foreign); b++) foreign_table[b-c]=table.field[a].foreign[b];
		foreign_table[b+1]=0;
		fprintf(cout,"%s=",foreign_field);
		fprintf(cout,"$input.%s ;\" TO results\n",table.field[a].name);
		fprintf(cout,"	ROWS results TO no_rows\n");
		fprintf(cout,"	IF no_rows = 0 THEN BEGIN\n");
		fprintf(cout,"		DISPLAY %s WITH input ERROR \"Foreign Key Not Found\" ON %d\n",table.name,a+1);
		fprintf(cout,"		END\n");
		}
	fprintf(cout,"	SQL \"SELECT max(recnum) FROM %s;\" TO results\n",table.name);
	fprintf(cout,"	CALC ( results.0.0 + 1 ) TO new_recnum\n");
	

	fprintf(cout,"	SQL \"INSERT INTO %s (recnum",table.name);
	and=1;
	for (a=0; a<table.no_fields; a++) {
		if (and==1) fprintf(cout,",");
		fprintf(cout,"%s",table.field[a].name);
		and=1;
		}
	fprintf(cout,") VALUES ($new_recnum ");
	and=1;
	for (a=0; a<table.no_fields; a++) {
		if (and==1) fprintf(cout,",");
		fprintf(cout," ");
		if (!((table.field[a].type[0]=='i') || (table.field[a].type[0]=='f'))) fprintf(cout,"\'");
		fprintf(cout,"$input.%s",table.field[a].name);
		if (!((table.field[a].type[0]=='i') || (table.field[a].type[0]=='f'))) fprintf(cout,"\'");
		and=1;
		}
	fprintf(cout,");\"\n");
	fprintf(cout,"	DISPLAY %s\n\n",table.name);


/* UPDATE */
	fprintf(cout,"[PROCESS update]\n");
	fprintf(cout,"	DATA results\n");
	fprintf(cout,"	INT no_rows\n");
	

	for (a=0; a<table.no_fields; a++) if (table.field[a].foreign[0]!=0) {
		fprintf(cout,"	SQL \"SELECT %s WHERE ",table.field[a].foreign);
		for (b=0; ((b<strlen(table.field[a].foreign))&&(table.field[a].foreign[b]!=' ')); b++) foreign_field[b]=table.field[a].foreign[b];
		foreign_field[b]=0;
		c=b;
		for (b=c; ((b<strlen(table.field[a].foreign))&&(table.field[a].foreign[b]!=' ')); b++) foreign_table[b-c]=table.field[a].foreign[b];
		c=b;
		for (b=c; b<strlen(table.field[a].foreign); b++) foreign_table[b-c]=table.field[a].foreign[b];
		foreign_table[b+1]=0;
		fprintf(cout,"%s=",foreign_field);
		fprintf(cout,"$input.%s ;\" TO results\n",table.field[a].name);
		fprintf(cout,"	ROWS results TO no_rows\n");
		fprintf(cout,"	IF no_rows = 0 THEN BEGIN\n");
		fprintf(cout,"		DISPLAY %s WITH input ERROR \"Foreign Key Not Found\" ON %d\n",table.name,a+1);
		fprintf(cout,"		END\n");
		}
	fprintf(cout,"	SQL \"UPDATE %s SET ",table.name);
	and=0;
	for (a=0; a<table.no_fields; a++) {
		if (and==1) fprintf(cout,",");
		fprintf(cout,"%s=",table.field[a].name);
		if (!((table.field[a].type[0]=='i') || (table.field[a].type[0]=='f'))) fprintf(cout,"\'");
		fprintf(cout,"$input.%s",table.field[a].name);
		if (!((table.field[a].type[0]=='i') || (table.field[a].type[0]=='f'))) fprintf(cout,"\'");
		and=1;
		}
	fprintf(cout," WHERE recnum = $input.recnum ;\"\n");
	fprintf(cout,"	DISPLAY %s\n\n",table.name);


/* DELETE */
	fprintf(cout,"[PROCESS delete]\n");
	fprintf(cout,"	DISPLAY sure WITH input\n\n");
	
/* CLEAR */ 
	fprintf(cout,"[PROCESS clear]\n");
	fprintf(cout,"	DISPLAY %s\n\n",table.name);
	
/* YES */	
	fprintf(cout,"[PROCESS yes]\n");
	fprintf(cout,"	SQL \"DELETE FROM %s WHERE recnum = $input.recnum ",table.name);
	fprintf(cout,";\"\n");
	fprintf(cout,"	DISPLAY %s\n\n",table.name);

/* FIND */	
	fprintf(cout,"[PROCESS find]\n");
	fprintf(cout,"	DATA results\n");
	fprintf(cout,"	INT and\n");
	fprintf(cout,"	STRING query\n");
	fprintf(cout,"	MOVE 0 TO and\n");
	fprintf(cout,"	MOVE \"SELECT recnum, %s FROM %s WHERE \" TO query\n",table.summary,table.name);
	for (a=0; a<table.no_fields; a++) if (table.field[a].type[0]=='c') {
		fprintf(cout,"	IF NOT BLANK(input.%s) THEN BEGIN\n",table.field[a].name);
		fprintf(cout,"		IF and = 1 THEN APPEND query \" AND \"\n");
		if ((table.field[a].type[0]=='f')||(table.field[a].type[0]=='i')) {
			fprintf(cout,"		APPEND query \"%s = \" input.%s\n",table.field[a].name,table.field[a].name);
 			}
		else {
			fprintf(cout,"		APPEND query \"%s like \'%%\" input.%s \"%%\'\"\n",table.field[a].name,table.field[a].name);
 		
			}
		fprintf(cout,"		MOVE 1 TO and\n");
		fprintf(cout,"		END\n");
		}
	fprintf(cout,"	APPEND query \"ORDER BY %s;\"\n",table.summary);
	fprintf(cout,"	SQL query TO results\n");
	fprintf(cout,"	OUTPUT find_list WITH results\n\n");


/* FIND_DISPLAY */
	
	fprintf(cout,"[PROCESS find_display]\n");
	fprintf(cout,"	DATA results\n");
	fprintf(cout,"	SQL \"SELECT recnum, ");
	and=0;
	for (a=0; a<table.no_fields; a++) {
		if (and==1) fprintf(cout,",");
		fprintf(cout,"%s",table.field[a].name);
		and=1;
		}
	fprintf(cout," FROM %s WHERE recnum=$input.recnum ",table.name);
	fprintf(cout,";\" TO results\n");
	fprintf(cout,"	DISPLAY %s WITH results\n\n",table.name);


/* PICK DISPLAY */
	fprintf(cout,"[PROCESS pick_display]\n");
	fprintf(cout,"	DISPLAY %s WITH input\n\n",table.name);


/* PICKS */
	for (a=0; a<table.no_fields; a++) if (table.field[a].foreign[a]!=0) {
		fprintf(cout,"[PROCESS pick_%s]\n",table.field[a].name);
		fprintf(cout,"	DATA results\n");
		fprintf(cout,"	SQL \"SELECT %s ; \" TO results\n",table.field[a].foreign);
		fprintf(cout,"	OUTPUT pick_%s WITH results\n\n",table.field[a].name);
		fprintf(cout,"[OUTPUT pick_%s]\n",table.field[a].name);
		fprintf(cout,"	SET title AS \"Available choices:\"\n");
		fprintf(cout,"	SET type AS screen\n");
		fprintf(cout,"	DEFINE  OUTPUT {\n");
		fprintf(cout,"		%s : LEFT : \"%s\"\n",table.field[a].name,table.field[a].name);
		fprintf(cout,"		} LINK TO PROCESS pick_display WITH VALUE %s\n\n",table.field[a].name);
		}	
					

/* OUTPUT */

	fprintf(cout,"[OUTPUT find_list]\n");
	fprintf(cout,"	SET title AS \"Search Results\"\n");
	fprintf(cout,"	SET type AS screen\n");
	fprintf(cout,"	DEFINE OUTPUT {\n");
	fprintf(cout,"		recnum : RIGHT : \"Record\"\n");
	b=0;
	for (a=0; a<strlen(table.summary); a++) {
		if ((table.summary[a]!=',') && (table.summary[a]!=' ')) {
			spare[b]=table.summary[a];
			b++;
			}
		if (table.summary[a]==',') {
			spare[b]=0;
			b=0;
			fprintf(cout,"		%s : LEFT : \"%s\"\n",spare,spare);
			}
		}
	spare[b]=0;
	fprintf(cout,"		%s : LEFT : \"%s\"\n",spare,spare);		
	fprintf(cout,"		} LINK TO PROCESS find_display WITH VALUE recnum");	
	fprintf(cout,"\n\n\n");	
}
