#######################################################
# Sample Application Configuration File               #
#######################################################

INCLUDE "global.app"

[MENU pam]
	SET title AS "Property Appraisal Module Main Menu"
	DEFINE MENU {
		"Site Details" : MODULE "sites"
		"Block Details" : MODULE "blocks"
		"Reports Menu" : MENU "reports"
		}
	SHOWLN "Maintenance Functions:"
	DEFINE MENU {
		"4. Update Element Codes" : MODULE "elements"
		}

[MENU reports]
	SET title AS "Reports Menu"
	DEFINE MENU {
		"Block List" : MODULE "block-list"
		"Mereworth Report" : MODULE "mereworth"
		}

[MODULE sites]
	SET default_process AS "clear"
	DATA results
 [FORM site]
	SET title AS "Site Details"
	DEFINE FORM {
		site_code : 7 : "Site Code:" : TEXT
		description : 45 : "Description:" : TEXT
		} IN COLUMN
	DEFINE TOOLBAR {
		"ADD" : ALL : PROCESS "add"
		"FIND" : ALL : PROCESS "find"
		"UPDATE" : DATA : PROCESS "update"
		"DELETE" : DATA : PROCESS "delete"
		"CLEAR" : ALL : PROCESS "clear"
		"EXIT" : ALL : MENU "pam"
		}
 [FORM sure]
	SET title AS "Are you sure you want to delete ?"
	DEFINE FORM {
		site_code : 7 : "Site Code:"
		} IN COLUMN
	DEFINE TOOLBAR {
		"YES" : ALL : PROCESS "yes"
		"NO" : ALL : PROCESS "clear"
		}

 [OUTPUT find_list]
	SET title AS "Search Results"
	SET type AS screen
	DEFINE OUTPUT {
		site_code : LEFT : "Site Code" 
		description : LEFT : "Description"
		} LINK TO PROCESS find_display WITH VALUE site_code
	
 [PROCESS add]
	DATA results
	INT no_rows
	SQL "SELECT * FROM sites WHERE site_code = $input.site_code;" TO results
	ROWS results TO no_rows
	IF no_rows > 0 THEN DISPLAY site WITH input ERROR "Duplicate Record" ON site_code
	SQL "INSERT INTO sites (site_code, name) VALUES ($input.site_code,$input.description);" TO results
	DISPLAY site

 [PROCESS find]
	DATA results
	INT and
	STRING query
	MOVE 0 TO and
	MOVE "SELECT site_code, name FROM sites WHERE " TO query
	IF NOT BLANK(input.site_code) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "site_code like '%" input.site_code "%' "
		MOVE 1 TO and
		END
	IF NOT BLANK(input.description) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "name like '%" input.description "%' "
		MOVE 1 TO and
		END
	APPEND query "ORDER BY site_code;"
	SQL query TO results
	OUTPUT find_list WITH results

 [PROCESS find_display]
	DATA results
	SQL "SELECT * FROM sites WHERE site_code=$input.site_code;" TO results
	DISPLAY site WITH results

 [PROCESS update]
	DATA results
	SQL "UPDATE sites SET site_code=$input.site_code, name=$input.description WHERE site_code=$input.site_code;" TO results
	DISPLAY site

 [PROCESS clear]
	DISPLAY site

 [PROCESS delete]
	DISPLAY sure WITH input

 [PROCESS yes]
	SQL "DELETE FROM sites WHERE site_code=$input.site_code;" 
	DISPLAY site
	
