INCLUDE "global.app"

[MODULE pim]
SET default_process AS "logon_screen"

[PROCESS logon_screen]
DISPLAY login

[FORM login]
SET title AS "Personal Information Manager"
SHOWLN "<H1>Please Login:</H1>"
DEFINE FORM {
	user_id : 8 : "Login Name:" : TEXT
	password : 8 : "Password" : PASSWORD
}
DEFINE TOOLBAR {
	"LOGON" : ALL : PROCESS "logon"
	"CHANGE_PASSWORD" : ALL : PROCESS "ch_passwd"
}

[PROCESS logon]
DATA users
INT no_rows
SQL "SELECT * FROM users WHERE username='$input.user_id' AND password='$input.password';" TO users
ROWS users TO no_rows
IF no_rows < 1 THEN BEGIN
	DISPLAY login WITH input ERROR "LOGIN FAILURE" ON 1
	END
PROCESS main

[PROCESS ch_passwd]

[PROCESS main]
DATA results
SQL "SELECT priority + 1 as p, job_id, name, date, time FROM todo WHERE user_id='$input.user_id' AND status=0 ORDER BY p, date, time;" TO results
OUTPUT todo_list WITH results

[OUTPUT todo_list]
SET title AS "Personal Information Manager"
SET type AS screen
PROCESS username
DEFINE OUTPUT {
	priority : CENTER : "Priority"
	job_id : LEFT : "Job no."
	name : LEFT : "Job"
	date : LEFT : "Date"
	time : LEFT : "Time"
	} LINK TO PROCESS amend WITH VALUE job_id
PROCESS links

[PROCESS username]
STRING today
SYSDATE today
SHOWLN "<TABLE BORDER=1><TR><TD><APPLET CODEBASE=/ag CODE=clock.class WIDTH=48 HEIGHT=48></APPLET>"
SHOWLN "<TD>"
SHOWLN "<H1>" today "</H1></TABLE><BR>"

[PROCESS links]
SHOWLN "<BR><BR>"
SHOWLN "<TD><A HREF=/cgi-bin/contacts?AG_PROCESS=CONTACTS&USER_ID=" input.user_id "><IMG SRC=/ag/notebook.gif BORDER=0>Contacts Database</A>"
SHOWLN "<TD><A HREF=/cgi-bin/pim?AG_PROCESS=NEWTODO&USER_ID=" input.user_id "><IMG SRC=/ag/todo.gif BORDER=0>To Do List</A>"
SHOWLN "</TABLE>"


[PROCESS amend]
DATA job
SQL "SELECT user_id, job_id, priority, name FROM todo WHERE job_id=$input.job_id;" TO job
DISPLAY todo_edit WITH job

[PROCESS newtodo]
DISPLAY todo_edit WITH input

[FORM todo_edit]
SET title AS "Add / Amend ToDo Item"
DEFINE FORM {
	user_id : 8 : " " : HIDDEN
	job_id : 10 : " " : HIDDEN
	priority : 2 : "Priority" : CHOICE "1" "2" "3"
	name : 45 : "Job Name"
	}
DEFINE TOOLBAR {
	"COMPLETED" : ALL : PROCESS "complete"
	"ADD_NEW" : ALL : PROCESS "add_new"
	"UPDATE" : ALL : PROCESS "update"
	"DELETE" : ALL : PROCESS "delete"
	"EXIT" : ALL : PROCESS "main"
	}

[PROCESS update]
SQL "UPDATE todo SET priority=$input.priority, name= '$input.name' WHERE job_id=$input.job_id;"
PROCESS main

[PROCESS add_new]
DATA highest
INT new_job
STRING date
STRING time
SYSDATE date time
SQL "SELECT max(job_id) FROM todo;" TO highest
CALC ( highest.0.0 + 1 ) TO new_job
SQL "INSERT INTO todo (user_id, job_id, priority, status, name, date, time) VALUES ('$input.user_id', $new_job, $input.priority, 0, '$input.name', '$date', '$time');"
PROCESS main

[PROCESS delete]
IF NOT ( input.priority = 4 ) THEN BEGIN
	SQL "DELETE FROM todo WHERE job_id=$input.job_id;"
END
PROCESS main

[PROCESS complete] 
STRING today
STRING now
SYSDATE today now
IF NOT ( input.priority = 4 ) THEN BEGIN
	SQL "UPDATE todo SET status=1, c_date = '$today', c_time = '$now' WHERE job_id=$input.job_id;"
END
PROCESS main

#-------------------------
# Contacts Module 
#-------------------------

[MODULE contacts]

[PROCESS contacts] 
DISPLAY contact_edit WITH input

[FORM contact_edit]
SET title AS "Contacts Database"
DEFINE FORM {
	user_id : 8 : " " : HIDDEN 
	contact_id : 8 : " " : HIDDEN
	name : 45 : "Contact Name: " 
	company : 45 : "Company Name: "
	addr1 : 45 : "Address: "
	addr2 : 30 : " " 
	addr3 : 30 : " "
	addr4 : 30 : " " 
	tel : 20 : "Telephone Number: "
	fax : 20 : "Fax Number: "
	email : 45 : "E-Mail Address: "
	remark1 : 60 : "Remarks: "
	remark2 : 60 : " " 
	scope : 1 : "Private or Public:" : CHOICE "PUBLIC" "PRIVATE"
}
DEFINE TOOLBAR {
	"ADD" : ALL : PROCESS "add"
	"FIND" : ALL : PROCESS "find"
	"UPDATE" : DATA : PROCESS "update"
	"DELETE" : DATA : PROCESS "delete"
	"CLEAR" : DATA : PROCESS "clear"
	"EXIT" : ALL : MODULE "pim" PROCESS "main" VALUE "user_id"
	}

[PROCESS add]
DATA highest
INT new_job
SQL "SELECT max(contact_id) FROM contacts;" TO highest
CALC ( highest.0.0 + 1 ) TO new_job
SQL "INSERT INTO contacts (user_id,contact_id,name,company,addr1,addr2,addr3,addr4,tel,fax,email,remark1,remark2,scope) VALUES ('$input.user_id',$new_job,'$input.name','$input.company','$input.addr1','$input.addr2','$input.addr3','$input.addr4','$input.tel','$input.fax','$input.email','$input.remark1','$input.remark2',$input.scope);"
PROCESS clear

[PROCESS find]
DATA results
INT and
STRING query
MOVE "SELECT contact_id, name, company, tel FROM contacts WHERE (user_id=" TO query
APPEND query "'" input.user_id "' OR scope=0) "
MOVE 1 TO and
IF NOT BLANK(input.name) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "name like '%" input.name "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.company) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "company like '%" input.company "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.addr1) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "addr1 like '%" input.addr1 "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.addr2) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "addr2 like '%" input.addr2 "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.addr3) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "addr3 like '%" input.addr3 "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.addr4) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "addr4 like '%" input.addr4 "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.tel) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "tel like '%" input.tel "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.fax) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "fax like '%" input.fax "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.email) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "email like '%" input.email "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.remark1) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "remark1 like '%" input.remark1 "%' "
	MOVE 1 TO and
	END
IF NOT BLANK(input.remark2) THEN BEGIN
	IF and = 1 THEN APPEND query " AND "
	APPEND query "remark2 like '%" input.remark2 "%' "
	MOVE 1 TO and
	END
APPEND query ";"
SQL query TO results
OUTPUT find_list WITH results

[PROCESS update]
SQL "UPDATE contacts SET name='$input.name', company='$input.company', addr1='$input.addr1', addr2='$input.addr2', addr3='$input.addr3', addr4='$input.addr4', tel='$input.tel', fax='$input.fax', email='$input.email', remark1='$input.remark1', remark2='$input.remark2', scope=$input.scope WHERE contact_id=$input.contact_id;"
PROCESS clear

[PROCESS delete]
SQL "DELETE FROM contacts WHERE contact_id = $input.contact_id;"
PROCESS clear

[PROCESS clear]
DATA user
SQL "SELECT username, 0, '','','','','','','','','','','','' FROM users WHERE username = $input.user_id;" TO user
DISPLAY contact_edit WITH user

[OUTPUT find_list]
SET title AS "Search Results"
SET type AS screen
DEFINE OUTPUT {
	contact_id : LEFT : "Record"
	name : LEFT : "Name"
	company : LEFT : "Company"
	tel : LEFT : "Telephone"
} LINK TO PROCESS find_display WITH VALUES contact_id

[PROCESS find_display]
DATA results
SQL "SELECT '$input.user_id', contact_id, name, company, addr1, addr2, addr3, addr4, tel, fax, email, remark1, remark2, scope FROM contacts WHERE contact_id = $input.contact_id;" TO results
DISPLAY contact_edit WITH results

[END]
#------------------------------------
