[GLOBAL]
	SET pgdir AS "/usr/local/postgres95"
	SET pghost AS "arthur"
	SET pgdatabase AS "root"
	SET httpd-dir AS "/usr/local/httpd"
	SET cgi-url AS "http://arthur/apps"
	SET doc-url AS "http://arthur/docs"
	SET src-dir AS "."

[MODULE sites]
	SET default_process AS "clear"

[FORM sites]
	SET title AS "Site Details"
	DEFINE FORM {
		recnum : 10 : "" : HIDDEN
		site_code : 7 : "site_code: " : TEXT
		name : 30 : "name: " : TEXT
		} IN COLUMN
	DEFINE TOOLBAR {
		"ADD" : ALL : PROCESS "add"
		"FIND" : ALL : PROCESS "find"
		"UPDATE" : DATA : PROCESS "update"
		"DELETE" : DATA : PROCESS "delete"
		"CLEAR" : ALL : PROCESS "clear"
		"EXIT" : ALL : MENU "pam"
		}

[FORM sure]
	SET title AS "Are you sure you want to delete ?"
	DEFINE FORM {
		recnum : 10 : "" : HIDDEN
		site_code : 7 : "site_code: " : TEXT
		}
	DEFINE TOOLBAR {
		"YES" : ALL : PROCESS "yes"
		"NO" : ALL : PROCESS "clear"
		}

[PROCESS add]
	DATA results
	INT no_rows
	INT new_recnum
	SQL "SELECT * FROM sites WHERE  site_code=$input.site_code;" TO results
	ROWS results TO no_rows
	IF no_rows > 0 THEN BEGIN
		DISPLAY sites WITH input ERROR "Duplicate Record" ON 1
		END
	SQL "SELECT max(recnum) FROM sites;" TO results
	CALC ( results.0.0 + 1 ) TO new_recnum
	SQL "INSERT INTO sites (recnum,site_code,name) VALUES ($new_recnum , '$input.site_code', '$input.name');"
	DISPLAY sites

[PROCESS update]
	DATA results
	INT no_rows
	SQL "UPDATE sites SET site_code='$input.site_code',name='$input.name' WHERE recnum = $input.recnum ;"
	DISPLAY sites

[PROCESS delete]
	DISPLAY sure WITH input

[PROCESS clear]
	DISPLAY sites

[PROCESS yes]
	SQL "DELETE FROM sites WHERE recnum = $input.recnum ;"
	DISPLAY sites

[PROCESS find]
	DATA results
	INT and
	STRING query
	MOVE 0 TO and
	MOVE "SELECT recnum, site_code, name FROM sites WHERE " TO query
	IF NOT BLANK(input.site_code) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "site_code like '%" input.site_code "%'"
		MOVE 1 TO and
		END
	IF NOT BLANK(input.name) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "name like '%" input.name "%'"
		MOVE 1 TO and
		END
	APPEND query "ORDER BY site_code, name;"
	SQL query TO results
	OUTPUT find_list WITH results

[PROCESS find_display]
	DATA results
	SQL "SELECT recnum, site_code,name FROM sites WHERE recnum=$input.recnum ;" TO results
	DISPLAY sites WITH results

[PROCESS pick_display]
	DISPLAY sites WITH input

[OUTPUT find_list]
	SET title AS "Search Results"
	SET type AS screen
	DEFINE OUTPUT {
		recnum : RIGHT : "Record"
		site_code : LEFT : "site_code"
		name : LEFT : "name"
		} LINK TO PROCESS find_display WITH VALUE recnum


[MODULE blocks]
	SET default_process AS "clear"

[FORM blocks]
	SET title AS "Block Details"
	DEFINE FORM {
		recnum : 10 : "" : HIDDEN
		site_code : 7 : "site_code: " : PICK PROCESS "pick_site_code"
		block : 2 : "block: " : TEXT
		description : 45 : "description: " : TEXT
		gen_comment : 45 : "gen_comment: " : TEXT
		area : 10 : "area: " : TEXT
		stories : 10 : "stories: " : TEXT
		volume : 10 : "volume: " : TEXT
		year_built : 10 : "year_built: " : TEXT
		year_upgraded : 10 : "year_upgraded: " : TEXT
		funct_cap : 10 : "funct_cap: " : TEXT
		actual_use : 10 : "actual_use: " : TEXT
		} IN COLUMN
	DEFINE TOOLBAR {
		"ADD" : ALL : PROCESS "add"
		"FIND" : ALL : PROCESS "find"
		"UPDATE" : DATA : PROCESS "update"
		"DELETE" : DATA : PROCESS "delete"
		"CLEAR" : ALL : PROCESS "clear"
		"EXIT" : ALL : MENU "pam"
		}

[FORM sure]
	SET title AS "Are you sure you want to delete ?"
	DEFINE FORM {
		recnum : 10 : "" : HIDDEN
		site_code : 7 : "site_code: " : TEXT
		block : 2 : "block: " : TEXT
		}
	DEFINE TOOLBAR {
		"YES" : ALL : PROCESS "yes"
		"NO" : ALL : PROCESS "clear"
		}

[PROCESS add]
	DATA results
	INT no_rows
	INT new_recnum
	SQL "SELECT * FROM blocks WHERE  site_code=$input.site_code AND block=$input.block;" TO results
	ROWS results TO no_rows
	IF no_rows > 0 THEN BEGIN
		DISPLAY blocks WITH input ERROR "Duplicate Record" ON 1
		END
	SQL "SELECT site_code from sites WHERE site_code=$input.site_code ;" TO results
	ROWS results TO no_rows
	IF no_rows = 0 THEN BEGIN
		DISPLAY blocks WITH input ERROR "Foreign Key Not Found" ON 1
		END
	SQL "SELECT max(recnum) FROM blocks;" TO results
	CALC ( results.0.0 + 1 ) TO new_recnum
	SQL "INSERT INTO blocks (recnum,site_code,block,description,gen_comment,area,stories,volume,year_built,year_upgraded,funct_cap,actual_use) VALUES ($new_recnum , '$input.site_code', '$input.block', '$input.description', '$input.gen_comment', $input.area, $input.stories, $input.volume, $input.year_built, $input.year_upgraded, $input.funct_cap, $input.actual_use);"
	DISPLAY blocks

[PROCESS update]
	DATA results
	INT no_rows
	SQL "SELECT site_code from sites WHERE site_code=$input.site_code ;" TO results
	ROWS results TO no_rows
	IF no_rows = 0 THEN BEGIN
		DISPLAY blocks WITH input ERROR "Foreign Key Not Found" ON 1
		END
	SQL "UPDATE blocks SET site_code='$input.site_code',block='$input.block',description='$input.description',gen_comment='$input.gen_comment',area=$input.area,stories=$input.stories,volume=$input.volume,year_built=$input.year_built,year_upgraded=$input.year_upgraded,funct_cap=$input.funct_cap,actual_use=$input.actual_use WHERE recnum = $input.recnum ;"
	DISPLAY blocks

[PROCESS delete]
	DISPLAY sure WITH input

[PROCESS clear]
	DISPLAY blocks

[PROCESS yes]
	SQL "DELETE FROM blocks WHERE recnum = $input.recnum ;"
	DISPLAY blocks

[PROCESS find]
	DATA results
	INT and
	STRING query
	MOVE 0 TO and
	MOVE "SELECT recnum, site_code, block, description FROM blocks WHERE " TO query
	IF NOT BLANK(input.site_code) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "site_code like '%" input.site_code "%'"
		MOVE 1 TO and
		END
	IF NOT BLANK(input.block) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "block like '%" input.block "%'"
		MOVE 1 TO and
		END
	IF NOT BLANK(input.description) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "description like '%" input.description "%'"
		MOVE 1 TO and
		END
	IF NOT BLANK(input.gen_comment) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "gen_comment like '%" input.gen_comment "%'"
		MOVE 1 TO and
		END
	APPEND query "ORDER BY site_code, block, description;"
	SQL query TO results
	OUTPUT find_list WITH results

[PROCESS find_display]
	DATA results
	SQL "SELECT recnum, site_code,block,description,gen_comment,area,stories,volume,year_built,year_upgraded,funct_cap,actual_use FROM blocks WHERE recnum=$input.recnum ;" TO results
	DISPLAY blocks WITH results

[PROCESS pick_display]
	DISPLAY blocks WITH input

[PROCESS pick_site_code]
	DATA results
	SQL "SELECT site_code from sites ; " TO results
	OUTPUT pick_site_code WITH results

[OUTPUT pick_site_code]
	SET title AS "Available choices:"
	SET type AS screen
	DEFINE  OUTPUT {
		site_code : LEFT : "site_code"
		} LINK TO PROCESS pick_display WITH VALUE site_code

[OUTPUT find_list]
	SET title AS "Search Results"
	SET type AS screen
	DEFINE OUTPUT {
		recnum : RIGHT : "Record"
		site_code : LEFT : "site_code"
		block : LEFT : "block"
		description : LEFT : "description"
		} LINK TO PROCESS find_display WITH VALUE recnum


[MODULE element]
	SET default_process AS "clear"

[FORM element]
	SET title AS "Condition Elements"
	DEFINE FORM {
		recnum : 10 : "" : HIDDEN
		element_number : 10 : "element_number: " : TEXT
		name : 25 : "name: " : TEXT
		} IN COLUMN
	DEFINE TOOLBAR {
		"ADD" : ALL : PROCESS "add"
		"FIND" : ALL : PROCESS "find"
		"UPDATE" : DATA : PROCESS "update"
		"DELETE" : DATA : PROCESS "delete"
		"CLEAR" : ALL : PROCESS "clear"
		"EXIT" : ALL : MENU "pam"
		}

[FORM sure]
	SET title AS "Are you sure you want to delete ?"
	DEFINE FORM {
		recnum : 10 : "" : HIDDEN
		element_number : 10 : "element_number: " : TEXT
		}
	DEFINE TOOLBAR {
		"YES" : ALL : PROCESS "yes"
		"NO" : ALL : PROCESS "clear"
		}

[PROCESS add]
	DATA results
	INT no_rows
	INT new_recnum
	SQL "SELECT * FROM element WHERE  element_number=$input.element_number;" TO results
	ROWS results TO no_rows
	IF no_rows > 0 THEN BEGIN
		DISPLAY element WITH input ERROR "Duplicate Record" ON 1
		END
	SQL "SELECT max(recnum) FROM element;" TO results
	CALC ( results.0.0 + 1 ) TO new_recnum
	SQL "INSERT INTO element (recnum,element_number,name) VALUES ($new_recnum , $input.element_number, '$input.name');"
	DISPLAY element

[PROCESS update]
	DATA results
	INT no_rows
	SQL "UPDATE element SET element_number=$input.element_number,name='$input.name' WHERE recnum = $input.recnum ;"
	DISPLAY element

[PROCESS delete]
	DISPLAY sure WITH input

[PROCESS clear]
	DISPLAY element

[PROCESS yes]
	SQL "DELETE FROM element WHERE recnum = $input.recnum ;"
	DISPLAY element

[PROCESS find]
	DATA results
	INT and
	STRING query
	MOVE 0 TO and
	MOVE "SELECT recnum, element_number, name FROM element WHERE " TO query
	IF NOT BLANK(input.name) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "name like '%" input.name "%'"
		MOVE 1 TO and
		END
	APPEND query "ORDER BY element_number, name;"
	SQL query TO results
	OUTPUT find_list WITH results

[PROCESS find_display]
	DATA results
	SQL "SELECT recnum, element_number,name FROM element WHERE recnum=$input.recnum ;" TO results
	DISPLAY element WITH results

[PROCESS pick_display]
	DISPLAY element WITH input

[OUTPUT find_list]
	SET title AS "Search Results"
	SET type AS screen
	DEFINE OUTPUT {
		recnum : RIGHT : "Record"
		element_number : LEFT : "element_number"
		name : LEFT : "name"
		} LINK TO PROCESS find_display WITH VALUE recnum


[MODULE condition]
	SET default_process AS "clear"

[FORM condition]
	SET title AS "Physical Condition"
	DEFINE FORM {
		recnum : 10 : "" : HIDDEN
		site_code : 7 : "site_code: " : PICK PROCESS "pick_site_code"
		block : 2 : "block: " : PICK PROCESS "pick_block"
		element : 10 : "element: " : PICK PROCESS "pick_element"
		category : 2 : "category: " : TEXT
		life : 10 : "life: " : TEXT
		repair : 10 : "repair: " : TEXT
		upgrade : 10 : "upgrade: " : TEXT
		} IN COLUMN
	DEFINE TOOLBAR {
		"ADD" : ALL : PROCESS "add"
		"FIND" : ALL : PROCESS "find"
		"UPDATE" : DATA : PROCESS "update"
		"DELETE" : DATA : PROCESS "delete"
		"CLEAR" : ALL : PROCESS "clear"
		"EXIT" : ALL : MENU "pam"
		}

[FORM sure]
	SET title AS "Are you sure you want to delete ?"
	DEFINE FORM {
		recnum : 10 : "" : HIDDEN
		site_code : 7 : "site_code: " : TEXT
		block : 2 : "block: " : TEXT
		element : 10 : "element: " : TEXT
		}
	DEFINE TOOLBAR {
		"YES" : ALL : PROCESS "yes"
		"NO" : ALL : PROCESS "clear"
		}

[PROCESS add]
	DATA results
	INT no_rows
	INT new_recnum
	SQL "SELECT * FROM condition WHERE  site_code=$input.site_code AND block=$input.block AND element=$input.element;" TO results
	ROWS results TO no_rows
	IF no_rows > 0 THEN BEGIN
		DISPLAY condition WITH input ERROR "Duplicate Record" ON 1
		END
	SQL "SELECT site_code FROM sites WHERE site_code=$input.site_code ;" TO results
	ROWS results TO no_rows
	IF no_rows = 0 THEN BEGIN
		DISPLAY condition WITH input ERROR "Foreign Key Not Found" ON 1
		END
	SQL "SELECT block FROM blocks WHERE block=$input.block ;" TO results
	ROWS results TO no_rows
	IF no_rows = 0 THEN BEGIN
		DISPLAY condition WITH input ERROR "Foreign Key Not Found" ON 2
		END
	SQL "SELECT element_number FROM element WHERE element_number=$input.element ;" TO results
	ROWS results TO no_rows
	IF no_rows = 0 THEN BEGIN
		DISPLAY condition WITH input ERROR "Foreign Key Not Found" ON 3
		END
	SQL "SELECT max(recnum) FROM condition;" TO results
	CALC ( results.0.0 + 1 ) TO new_recnum
	SQL "INSERT INTO condition (recnum,site_code,block,element,category,life,repair,upgrade) VALUES ($new_recnum , '$input.site_code', '$input.block', $input.element, '$input.category', $input.life, $input.repair, $input.upgrade);"
	DISPLAY condition

[PROCESS update]
	DATA results
	INT no_rows
	SQL "SELECT site_code FROM sites WHERE site_code=$input.site_code ;" TO results
	ROWS results TO no_rows
	IF no_rows = 0 THEN BEGIN
		DISPLAY condition WITH input ERROR "Foreign Key Not Found" ON 1
		END
	SQL "SELECT block FROM blocks WHERE block=$input.block ;" TO results
	ROWS results TO no_rows
	IF no_rows = 0 THEN BEGIN
		DISPLAY condition WITH input ERROR "Foreign Key Not Found" ON 2
		END
	SQL "SELECT element_number FROM element WHERE element_number=$input.element ;" TO results
	ROWS results TO no_rows
	IF no_rows = 0 THEN BEGIN
		DISPLAY condition WITH input ERROR "Foreign Key Not Found" ON 3
		END
	SQL "UPDATE condition SET site_code='$input.site_code',block='$input.block',element=$input.element,category='$input.category',life=$input.life,repair=$input.repair,upgrade=$input.upgrade WHERE recnum = $input.recnum ;"
	DISPLAY condition

[PROCESS delete]
	DISPLAY sure WITH input

[PROCESS clear]
	DISPLAY condition

[PROCESS yes]
	SQL "DELETE FROM condition WHERE recnum = $input.recnum ;"
	DISPLAY condition

[PROCESS find]
	DATA results
	INT and
	STRING query
	MOVE 0 TO and
	MOVE "SELECT recnum, site_code, block, element FROM condition WHERE " TO query
	IF NOT BLANK(input.site_code) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "site_code like '%" input.site_code "%'"
		MOVE 1 TO and
		END
	IF NOT BLANK(input.block) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "block like '%" input.block "%'"
		MOVE 1 TO and
		END
	IF NOT BLANK(input.category) THEN BEGIN
		IF and = 1 THEN APPEND query " AND "
		APPEND query "category like '%" input.category "%'"
		MOVE 1 TO and
		END
	APPEND query "ORDER BY site_code, block, element;"
	SQL query TO results
	OUTPUT find_list WITH results

[PROCESS find_display]
	DATA results
	SQL "SELECT recnum, site_code,block,element,category,life,repair,upgrade FROM condition WHERE recnum=$input.recnum ;" TO results
	DISPLAY condition WITH results

[PROCESS pick_display]
	DISPLAY condition WITH input

[PROCESS pick_site_code]
	DATA results
	SQL "SELECT site_code FROM sites ; " TO results
	OUTPUT pick_site_code WITH results

[OUTPUT pick_site_code]
	SET title AS "Available choices:"
	SET type AS screen
	DEFINE  OUTPUT {
		site_code : LEFT : "site_code"
		} LINK TO PROCESS pick_display WITH VALUE site_code

[PROCESS pick_block]
	DATA results
	SQL "SELECT block FROM blocks ; " TO results
	OUTPUT pick_block WITH results

[OUTPUT pick_block]
	SET title AS "Available choices:"
	SET type AS screen
	DEFINE  OUTPUT {
		block : LEFT : "block"
		} LINK TO PROCESS pick_display WITH VALUE block

[PROCESS pick_element]
	DATA results
	SQL "SELECT element_number FROM element ; " TO results
	OUTPUT pick_element WITH results

[OUTPUT pick_element]
	SET title AS "Available choices:"
	SET type AS screen
	DEFINE  OUTPUT {
		element : LEFT : "element"
		} LINK TO PROCESS pick_display WITH VALUE element

[OUTPUT find_list]
	SET title AS "Search Results"
	SET type AS screen
	DEFINE OUTPUT {
		recnum : RIGHT : "Record"
		site_code : LEFT : "site_code"
		block : LEFT : "block"
		element : LEFT : "element"
		} LINK TO PROCESS find_display WITH VALUE recnum



[]