/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#define PROG_NAME "kdcreatedb"

#if HAVE_CONFIG_H
# include "config.h"
#endif 

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include <ctype.h>
#include <signal.h>
#include <getopt.h>
#include <locale.h>

#include "kdbs.h"
#include "sm.h"

Database db;

/*-----------------------------------
  Das eigentlich Hauptprogramm
------------------------------------*/
void showhelp (void);
void showversion (void);
void showerror (int errnr);
void Welcome (void);

#define HELP_OPT       0
#define USER_OPT       1
#define PATH_OPT       2
#define BASE_OPT       3
#define DATAF_OPT      4
#define INDEX_OPT      5
#define VERSION_OPT    6

static char default_indices[] = "class:0";

void
main(int argc, char **argv)
{
  int c;
  char 
    *pathname = NULL,
    *basename = NULL,
    *datafiles = NULL,
    *indexfiles = NULL;

  setlocale (LC_MESSAGES, "");
  textdomain (PACKAGE);

  Welcome ();
  
  opterr = 0;

  while (1) {
    static struct option long_options[] = {
      {"help", 0, 0, HELP_OPT},
      {"user", 1, 0, USER_OPT},
      {"path", 1, 0, PATH_OPT},
      {"base", 1, 0, BASE_OPT},
      {"data", 1, 0, DATAF_OPT},
      {"index", 1, 0, INDEX_OPT},
      {"version", 0, 0, VERSION_OPT},
      {0, 0, 0, 0}
    };
    int option_index = 0;
    
    c = getopt_long (argc, argv, "hu:p:b:d:i:", long_options, &option_index);

    if (c == -1)
      break;
    
    switch (c) {
    case HELP_OPT:
    case 'h':
      showhelp();
      exit (0);
    case USER_OPT:
    case 'u':
      break;
    case PATH_OPT:
    case 'p':
      pathname = optarg;
      break;
    case BASE_OPT:
    case 'b':
      basename = optarg;
      break;
    case DATAF_OPT:
    case 'd':
      datafiles = optarg;
      break;
    case INDEX_OPT:
    case 'i':
      indexfiles = optarg;
      break;
    case VERSION_OPT:
      showversion ();
      exit (EXIT_SUCCESS);
    case '?':
      exit (EXIT_FAILURE);
    default:
      exit (EXIT_FAILURE);
    }
  }
  
  if (!datafiles) {
    fprintf (stderr, _("%s: No datafiles specified\n"), PROG_NAME);
    exit (1);
  }
  
  
  if (!indexfiles) {
    indexfiles = default_indices; 
  }
  else {
    if (strstr (indexfiles, "class:0") == NULL) {
      char *s;
      
      s = (char *) malloc (strlen (indexfiles) + strlen("class:0, ") + 1);
      sprintf (s, "class:0, %s", indexfiles);
      
      indexfiles = s;
    }
  }
  
  if (createdb (&db, basename, pathname, datafiles, indexfiles) < 0)
    goto errhd;
  
  printf(_("New database created:\n"));
  printf(_("Basename: %s\n"), db.basename);
  printf(_("Path: %s\n"), db.path);
  
  exit (0);
  
errhd:
  fprintf(stderr, "%s: %s\n", PROG_NAME, errstr);
  exit (1);
}

/* -----------------------------------------------------
   Kurzhilfe & Fehlerausgabe
--------------------------------------------------------*/

void
Welcome (void)
{
  printf(_(
"kdcreatdb - database creating tool\n"
"This file is part of the kaenguru database system\n"
"Copyright (c) %s Gregor Klinke\n"
"\n"), COPYRIGHTYEAR);
}

void
showversion (void)
{
  fprintf (stdout, 
"This is Kaenguru %s - The Kaenguru Database System (%s)\n"
"Copyright (c) %s by Gregor Klinke\n"
"\n"
"This program is free software; you can redistribute it and/or modify it\n"
"under the terms of the GNU General Public License as published by the\n"
"Free Software Foundation; either version 2 of the License, or (at your\n"
"option) any later version.\n"
"\n"
"This program ist distributed in the hope that it will be useful, but\n"
"WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
"General Public Lincense for more details.\n"
"\n", VERSION, PROG_NAME, COPYRIGHTYEAR);
}

void
showhelp (void)
{
  printf(_(
"%s is an ininteractive tool for creating a database to the kaenguru\n"
"database system.  You always should use this tool to create a new\n"
"database, because it initializes all files and prebuild all indexes.\n"
"\n"
"General usage:\n"
"  %s [-h] [-u<user>] [-p<path>] [-b<basename>] [-d<datafiles>]\n"
"          [-i<indices>]\n"
"\n"
"Options:\n"
"\n"
"  -h, --help       This help\n"
"\n"
"  -u, --user=NAME  User, the owner of the database (Not implemented yet)\n"
"\n"
"  -p, --path=PATH  If no path is set with the option -p %s assumes\n"
"                   the systemwide default path /var/lib/kaenguru/base\n"
"                   as base path and creates a new sub directory with the\n"
"                   basename (option -b) under it.  Is -p specified it\n"
"                   must give an absolute path.\n"
"\n"
"  -b, --base=NAME  The database to be created.  If no name is given\n"
"                   %s tries the environment variable KAENBASE.  Is\n"
"                   this is also undefined it takes the user login name.\n"
"\n"
"  -d, --data=LIST  a komma separated list of names and file ids used as\n"
"                   datafile names.  %s will stop if this list is\n"
"                   unset. You have to specify both information in this\n"
"                   form: name:id, name:id, i.e. seperated by a colon!\n"
"                   You should start with File id 0.\n"
"\n"
"  -i, --index=LIST a komma separated list of names used as indexfile names\n"
"                   and - seperated by colons - of index ids.\n"
"                   At least one index (class) will be generated if no index\n"
"                   name is specified. You have to start with index id 1,\n"
"                   since the system index `class' take index id 0 by\n"
"                   default\n"
"\n"
"      --version    print out version and copyright.\n"
"\n"
"  NOTE: You have to put the LISTs in \"\" to secure them from your shell.\n"
"        Note also, that %s DOES NOT add any data to\n"
"        $BASE/conf/databases nor does it any other configuration for you!\n"
"        This has to be done by the adminstrator.\n"
"\n"
"  NOTE TO: You have to specify the file and index ids yourself.  The\n"
"  system doesn't know, if you forget one or if your data is bad!\n"),
	 PROG_NAME, PROG_NAME, PROG_NAME, PROG_NAME, PROG_NAME, PROG_NAME
	 );
  
}





