/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include "kdbs.h"
#include "utils.h"
#include "path.h"
#include "read_configuration.h"

/* ----------------------------------------------------------------------
   GENERAL CONFIG READ FUNCTION
   ---------------------------------------------------------------------- */
int
read_configuration (char *name)
{
  FILE *stream;
  char tmp[FILENAME_MAX], buffer[1024], *token;
  int inscope = false;

  if (name) {
    sprintf (tmp, "%s", name);
  }
  else {
    sprintf (tmp, "%s", CONFIG_DEFAULT);
  }
  stream = fopen (tmp, "r");
  
  if (!stream)
    GOERR (_("config file: open"));
  
  while (!feof (stream)) {
    
    if (fgets (buffer, 1023, stream) == NULL) {
      if (feof (stream))
	goto eofhd;
      else
	GOERR (_("config file: read"));
    }
    
    if (!inscope) {
      token = strtok (buffer, " (\n");
      if (token) {
	if (strcasecmp (token, "begin") == 0) {
	  token = strtok (NULL, " )\r\t\n");
	  if ((token) 
	      && ((strcasecmp (token, "utilities") == 0) 
		  || (strcasecmp (token, "global") == 0))) {
	    inscope = true;
	  }
	}
      }
    }
    else {
      token = strtok (buffer, ": \n");
      
      if (token) {
	
	if (strcmp (token, "port") == 0) {
	  port = GET_CONST (token, 1, 65535);
	}
	else if (strcmp (token, "timeout") == 0) {
	  timeoutval = GET_CONST (token, 1, 86400); /* max. 1 Tag timeout */
	}
	else if (strcmp (token, "host") == 0) {
	  token = strtok (NULL, " \r\t\n");
	  if (token) {
	    host = strdup (token);
	  }
	}
	else if (strcasecmp (token, "end") == 0) {
	  inscope = false;
	}
	else {
	  if (*token == '#') {}
	}
      }
    }
  }
  
eofhd:
  if (inscope) {
    PRINTERR (_("warning! unexpected eof in config file\n"));
  }
  
  if (fclose (stream) != 0)
    GOERR (_("config file: close"));
  return 1;
  
errhd:
  PRINTERR (errstr);
  return -1;
}

