/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include "sm.h"
#include "net.h"

int
connect_to_remote_site (Database *db)
{
#if DISTRIBUTED_DB
  int tmpsize = 1024;
  char *token, *tail, *tmp = (char*) malloc (tmpsize);

  /* if we are not connected yet do this now */
  if (db->sock == 0) {		/* not connected! */
    struct sockaddr_in servername;

    /* Create a socket. */
    db->sock = socket (PF_INET, SOCK_STREAM, 0);
    if (db->sock < 0)
      SM_GOERR (_("socket failed"));
    
    /* Connect to the daemon. */
    printf("Connect to the daemon (%s:%d) ...\n", db->server, db->port);
    init_sockaddr (&servername, db->server, db->port);
    if (0 > connect (db->sock, (struct sockaddr *) &servername,
		     sizeof (servername)))
      SM_GOERR (_("connection to sm failed"));
    
    if (read_from_sock (db->sock, &tmp, &tmpsize) < 0) 
      goto errhd;
    
    if (tmp[0] != KCP_OKC)
      SM_GOERR (NWEREMOTELOGIN);
    
    token = strtok (tmp, " \r");	/* parse the ok header */
    token = strtok (NULL, " \r");	/* get the conn id */
    if (!token)
      SM_GOERR (NWEREMOTELOGIN);
    db->connid = strtol (token, &tail, 0);
    
    token = strtok (NULL, " \r");	/* get the conn key */
    if (!token)
      SM_GOERR (NWEREMOTELOGIN);
    db->connkey = strdup (token);
  }

  /* now open the database */ 
  if (writesockf (db->sock, 
		  "OPENDB %d %s %s",
		  db->connid, db->connkey, db->basename) <= 0)
    SM_GOERR (_("writing socket"));
  read_from_sock (db->sock, &tmp, &tmpsize);
  if (tmp[0] != KCP_OKC)
    SM_GOERR (_("opening remote database"));
  
  return 1;
  
errhd:
  free (tmp);
  return -1;

#else /* no distributed db*/
  SM_DESCERR (NODISTRDB);
  return -1;
#endif
}

int
disconnect_from_remote_site (Database *db)
{
#if DISTRIBUTED_DB
  char tmp[MAXKCPBUF];
  
  if (writesockf (db->sock, "BYE %d %s", db->connid, db->connkey) <= 0)
    SM_GOERR (_("reading socket"));
  
  close (db->sock);
  db->sock = 0;
  
  return 1;
errhd:
  return -1;

#else /* no distributed db */
  SM_DESCERR (NODISTRDB);
  return -1;
#endif
}




