/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_BTREE_H
#define _KDBS_BTREE_H

#include "sm.h"

/* prototypen */

extern void setistat (Indexstatus *istat, char pagetype);
extern long nodeofs (long node);
extern int writeBasispage (Index *index);
extern int loadBasispage (Index *index);
extern void changeNextfree (Index *index, long nextfree);
extern void changeRoot (Index *index, long root);
extern long getNextfree (Index *index);
extern long getRoot (Index *index);
extern int loadKnot (Index *index, long node, Workpage *workpage);
extern int writeKnot (Index *index, long node, Workpage *workpage);
extern void initItem (Item *item);
extern void initKnot (Workpage *wp, char pagetype);
extern void initEmptypage (Workpage *wp, long nextfree, Indexstatus *istat);
extern void initBasispage (Basispage *basispage, long root, long nextfree);
extern long getnewKnot (Index *index);
extern int releaseKnot (Index *index, Workpage *wp, long node);
extern void keysearch (char *key, Workpage *workpage, int *itemnr,
		       bool *itemfound);
extern void refsearch (long ref, Workpage *workpage, int *itemnr,
		       bool *itemfound);
extern int retrievebtree (char *key, Index *index, long *lastwp,
			  int *nr, Keyinfo *keyinfo);

/* from ins.c */
extern int splitknot (Index *index, Workpage *wp, Item *item, int itemnr,
		      Indexstatus *istat);
extern int bt_update (Index *index, Keyinfo *key, long node, bool *rise,
		   Item *item, Indexstatus *istat);
extern int updatebtree (Index *index, char *key, long ref);

/* from del.c */
extern int compensateright (Index *index, Workpage *wp, long node,
			    long rightnode, bool *sink, Item *itemx,
			    Indexstatus *istat);
extern int compensateleft (Index *index, Workpage *wp, long node,
			   long leftnode, bool *sink, Item *itemx,
			   Indexstatus *istat);
extern int greatest (Index *index, long node, Item *replaceitem,
		     long neighbour, bool left, bool *change, bool *sink,
		     Item *downx, Indexstatus *istat);
extern int delete (Index *index, Keyinfo *key, long node, long neighbour,
		   bool left, bool *change, bool *sink, Item *downx,
		   long rootnode, bool *refcount,
		   Indexstatus *istat);
extern int deletebtree (Index *index, char *key, long ref);


#endif
