/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include "btree.h"

/* ----------------------------------------------------------------------
   Suchen und Einfuegen eines Elementes mit dem Schluessel x in einen Baum
   ---------------------------------------------------------------------- */
int
splitknot (Index *index,
	   Workpage *wp,
	   Item *item,
	   int itemnr,
	   Indexstatus *istat)
{
  Node splitnode;
  Workpage splitwp;
  Item upitem;
  int i;
  
  initKnot (&splitwp, istat->pagetype);
  splitnode = getnewKnot (index);
  
  if (itemnr < istat->pagemidth) {
    /* item ist in der linken Haelfte einzufuegen */
    memcpy (&upitem, &wp->itm[istat->pagemidth], sizeof (Item));
    for (i = istat->pagemidth - 1; i > itemnr; i--) {
      memcpy (&wp->itm[i + 1], &wp->itm[i], sizeof (Item));
    }
    memcpy (&wp->itm[itemnr + 1], item, sizeof (Item));
  }
  else if (itemnr > istat->pagemidth) {
    /* item ist in der rechten Haelfte einzufuegen */
    memcpy (&upitem, &wp->itm[istat->pagemidth + 1], sizeof (Item));
    for (i = istat->pagemidth + 2; i < itemnr + 1; i++) {
      memcpy (&wp->itm[i-1], &wp->itm[i], sizeof (Item));
    }
    memcpy (&wp->itm[itemnr], item, sizeof (Item));    
  }
  else {
    /* item nicht einfuegen, sondern direkt an nach oben weiterreichen */
    memcpy (&upitem, item, sizeof (Item));
  }
  
  /* der Zeiges des nach oben zu reichenden upitem verbleibt als linkester
     Zeiger in splitwp.  Der Verweis auf diesen neuen Knoten wird mit
     upitem nach oben gereicht. */
  
  splitwp.itm[0].link = upitem.link;
  upitem.link = splitnode;
  memcpy (item, &upitem, sizeof(Item));
  
  for (i = istat->pagemidth + 1; i < istat->maxitems; i++) {
    memcpy (&splitwp.itm[i - istat->pagemidth], &wp->itm[i],
	    sizeof (Item));
  }
  wp->items = istat->pagemidth;
  splitwp.items = istat->maxitems - istat->pagemidth - 1;
  if (writeKnot (index, splitnode, &splitwp) < 0)
    goto errhd;
  return 1;
  
 errhd:
  return -1;
}

int
updatereftree (Index *index, Node node, Workpage *wp, int itemnr, Node ref)
{
  bool rootsplit = false;
  Item rootitem;
  Node rootnode;
  Indexstatus istat;
  Keyinfo keyinfo;
  
  /*  if (loadKnot (index, node, wp) < 0)
      goto errhd; */
  
  rootnode = wp->itm[itemnr].info;
  
  keyinfo.info = ref;
  keyinfo.key[0] = '\0';
  setistat (&istat, i_REFTREE);
  
  if (bt_update (index, &keyinfo, rootnode, &rootsplit, &rootitem, &istat) < 0)
    goto errhd; 
  
  if (rootsplit) {
    Workpage nwp;
    /* die alte Wurzel wurde gespalten; mit root item musse eine neue
       Wurzel angelegt werden */
    
    initKnot (&nwp, i_REFTREE);
    nwp.items = 1;
    nwp.itm[0].link = rootnode;
    nwp.itm[0].info = i_NOREF;
    
    memcpy (&nwp.itm[1], &rootitem, sizeof (Item));
    
    rootnode = getnewKnot (index);
    if (writeKnot (index, rootnode, &nwp) < 0)
      goto errhd;
    
    wp->itm[itemnr].info = rootnode; /* change Root */
    
    if (writeKnot (index, node, wp) < 0)
      goto errhd;
  }
  
  return 1;
  
errhd:
  return -1;
}

int
bt_update (Index *index,
	Keyinfo *key,		/* key to be inserted */
	Node node,		/* node zum durchsuchen */
	bool *rise,		/* wird etwas hochgereicht? */
	Item *item,		/* item das hochgereicht wird */
	Indexstatus *istat)
{
  Workpage *wp;
  int itemnr, i;
  bool itemfound, risen;
  
  if (node == i_NOLINK) {
    *rise = true;
    
    item->link = i_NOLINK;	/* init a new item  */
    if (istat->pagetype == i_KEYTREE) {
      item->info = key->info;
      item->reftype = i_REFLINK; /* eine reference auf Datensaetze */
      strcpy (item->key, key->key);
    }
    else if (istat->pagetype == i_REFTREE) {
      item->info = key->info;
    }
  }
  else {
    wp = (Workpage *) alloca (sizeof (Workpage)); /* dynamic get heap */
    if (loadKnot (index, node, wp) < 0)
      goto errhd;
    if (istat->pagetype == i_KEYTREE)
      keysearch (key->key, wp, &itemnr, &itemfound);
    else if (istat->pagetype == i_REFTREE)
      refsearch (key->info, wp, &itemnr, &itemfound);
    
    if (itemfound) {
      /* ACHTUNG: Hier im Subtree austesten, ob der Schluessel unter
         key->info bereits enthalten ist, wenn er es ist, dann ist alles
         ok, ansonsten den neuen infowert einfach in den Index schreiben! */
      if (wp->itm[itemnr].reftype == i_PAGELINK) {
	if (updatereftree (index, node, wp, itemnr, key->info) < 0)
	  goto errhd;
      }
      else if (wp->itm[itemnr].reftype == i_REFLINK) {
	if (wp->itm[itemnr].info != key->info) { /* ein neuer schluessel */
	  /* Wir muessen eine neue Seite definieren! */
	  Workpage nwp;
	  Node rootnode;
	  
	  initKnot (&nwp, i_REFTREE);
	  nwp.pagetype = i_REFTREE;
	  nwp.items = 2;
	  nwp.itm[0].link = 0;
	  nwp.itm[0].info = i_NOREF;
	  
	  if (wp->itm[itemnr].info > key->info) {
	    nwp.itm[1].info = key->info;
	    nwp.itm[1].link = i_NOLINK;
	    nwp.itm[2].info = wp->itm[itemnr].info;
	    nwp.itm[2].link = i_NOLINK;
	  }
	  else {
	    nwp.itm[1].info = wp->itm[itemnr].info;
	    nwp.itm[1].link = i_NOLINK;
	    nwp.itm[2].info = key->info;
	    nwp.itm[2].link = i_NOLINK;
	  }
	  
	  rootnode = getnewKnot (index);
	  if (writeKnot (index, rootnode, &nwp) < 0)
	    goto errhd;
	  
	  wp->itm[itemnr].info = rootnode; /* change Root */
	  wp->itm[itemnr].reftype = i_PAGELINK;
	  if (writeKnot (index, node, wp) < 0)
	    goto errhd;
	  
	}
      }
    }
    else {
      risen = false;
      if (bt_update (index, key, wp->itm[itemnr].link, &risen, item,
		  istat) < 0)
	goto errhd;
      if (risen) {
	if (wp->items < istat->maxitems - 1) {
	  /* einfuegen von item an der Stelle intemnr */
	  wp->items++;
	  for (i = wp->items-1; i >= itemnr + 1; i--) {
	    memcpy (&wp->itm[i+1], &wp->itm[i], sizeof(Item));
	  }
	  memcpy (&wp->itm[itemnr+1], item, sizeof (Item));
	  rise = false;
	}
	else {
	  if (splitknot (index, wp, item, itemnr, istat) < 0)
	    goto errhd;
	  *rise = true;
	}
	if (writeKnot (index, node, wp) < 0)
	  goto errhd;
      }
    }
  }
  return 1;
  
errhd:
  return -1;
}

int
updatebtree (Index *index, char *key, Node ref)
{
  bool rootsplit = false;
  Item rootitem;
  Node rootnode;
  Workpage nwp;
  Indexstatus istat;
  Keyinfo keyinfo;

  cleaninput (index->file);	/* reset up iostream */
  
  if (key) {
    if (loadBasispage (index) < 0)
      goto errhd;
    
    rootnode = getRoot (index);

    if (strlen (key) > i_KEYSIZE) {
      strncpy (keyinfo.key, key, i_KEYSIZE - 1);
      keyinfo.key[i_KEYSIZE] = '\0';
    }
    else
      strcpy (keyinfo.key, key);
    keyinfo.info = ref;
    
    setistat (&istat, i_KEYTREE);
    if (bt_update (index, &keyinfo, rootnode, &rootsplit, &rootitem,
		   &istat) < 0)
      goto errhd; 
    
    if (rootsplit) {
      /* die alte Wurzel wurde gespalten; mit root item musse eine neue
	 Wurzel angelegt werden */
      initKnot (&nwp, i_KEYTREE);
      nwp.items = 1;
      
      nwp.itm[0].link = rootnode;
      nwp.itm[0].info = i_NOREF;
      nwp.itm[0].reftype = 'p';
      nwp.itm[0].key[0] = '\0';
      
      memcpy (&nwp.itm[1], &rootitem, sizeof (Item));
      
      rootnode = getnewKnot (index);
      if (writeKnot (index, rootnode, &nwp) < 0)
	goto errhd;
      
      changeRoot (index, rootnode);
    }
    
    if (writeBasispage (index) < 0)
      goto errhd;

    cleanoutput (index->file);	/* clean up up iostream */    
    return 1;
  }
errhd:
  return -1;
}
