/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include "btree.h"

/* ----------------------------------------------------------------------
   functions for deleting a key from the index
   ---------------------------------------------------------------------- */
int
compensateright (Index *index, Workpage *wp, Node node,
		 Node rightnode, bool *sink, Item *itemx,
		 Indexstatus *istat)
{
  Workpage *rightwp;
  int i;
  Item itemy;
  int avail;  
  
  rightwp = (Workpage *) alloca (sizeof (Workpage));
  if (loadKnot (index, rightnode, rightwp) < 0)
    goto errhd;
  
  if (rightwp->items > istat->pagemidth) {  /* *** */
    /* der rechte Nachbar kann einige Elemente abgeben */

    avail = (rightwp->items - istat->pagemidth) / 2;
    if (avail == 0)
      avail = 1;
    
    memcpy (&itemy, &rightwp->itm[avail], sizeof (Item)); /* take y */
    itemx->link = rightwp->itm[0].link;
    rightwp->itm[0].link = itemy.link;
    itemy.link = rightnode;
    
    memcpy (&wp->itm[wp->items + 1], itemx, sizeof (Item));
    
    for (i = 1; i < avail; i++) {
      memcpy (&wp->itm[wp->items + i + 1],
	      &rightwp->itm[i], sizeof (Item));
    }
    
    /* nun richte die rechte Seite wieder her */
    for (i = avail + 1; i <= rightwp->items; i++) {
      memcpy (&rightwp->itm[i - avail], &rightwp->itm[i],
	      sizeof (Item));
    }
    /* copy y to the key-position */
    memcpy (itemx, &itemy, sizeof (Item));
    
    rightwp->items -= avail;
    wp->items += avail;
    *sink = false;
  }
  else {
    /* der rechte Nachbar ist so klein, dass er komplett auf wp passt */
    itemx->link = rightwp->itm[0].link;
    memcpy (&wp->itm[istat->pagemidth], itemx, sizeof (Item));
    
    for (i = 1; i <= istat->pagemidth; i++) {
      memcpy (&wp->itm[istat->pagemidth + i], &rightwp->itm[i],
	      sizeof (Item));
    }
    wp->items += istat->pagemidth + 1;
    *sink = true;
    if (releaseKnot (index, rightwp, rightnode) < 0) /* free page */
      goto errhd;
  }
  
  if (writeKnot (index, rightnode, rightwp) < 0)
    goto errhd;
  
  return 1;
  
errhd:
  return -1;
}

int
compensateleft (Index *index, Workpage *wp, Node node,
		Node leftnode, bool *sink, Item *itemx,
		Indexstatus *istat)
{
  Workpage *leftwp;
  int i;
  Item itemy;
  int avail;
  
  
  leftwp = (Workpage *) alloca (sizeof (Workpage));
  if (loadKnot (index, leftnode, leftwp) < 0)
    goto errhd;
  
  if (leftwp->items > istat->pagemidth) {
    /* der linke Nachbar kann einige Elemente abgeben */
    
    avail = (leftwp->items - istat->pagemidth) / 2;
    if (avail == 0)
      avail = 1;
    
    memcpy (&itemy, &leftwp->itm[leftwp->items - avail + 1],
	    sizeof (Item));
    itemx->link = wp->itm[0].link;
    wp->itm[0].link = itemy.link;
    itemy.link = node;
    
    for (i = istat->pagemidth - 1; i >= 1; i--) {
      memcpy (&wp->itm[i + avail], &wp->itm[i], sizeof (Item));
    }
    memcpy (&wp->itm[avail], itemx, sizeof (Item));
    
    for (i = 1; i < avail; i++) {
      memcpy (&wp->itm[i],
	      &leftwp->itm[leftwp->items - avail + i + 1],
	      sizeof (Item));
    }
    memcpy (itemx, &itemy, sizeof (Item));
    leftwp->items -= avail;
    wp->items += avail;
    *sink = false;
  }
  else {
    /* der linke Nachbar hat so viel Platz, dass er wp ganz bei sich
       aufnehmen kann */
    itemx->link = wp->itm[0].link;
    memcpy (&leftwp->itm[istat->pagemidth+1], itemx, sizeof (Item));
    
    for (i = 1; i < istat->pagemidth; i++) {
      memcpy (&leftwp->itm[istat->pagemidth + i + 1], &wp->itm[i],
	      sizeof (Item));
    }
    leftwp->items += istat->pagemidth;
    *sink = true;
    if (releaseKnot (index, wp, node) < 0) /* seite wieder freigeben */
      goto errhd;
  }
  
  if (writeKnot (index, leftnode, leftwp) < 0)
    goto errhd;
  
  return 1;
  
errhd:
  return -1;
}

int
greatest (Index *index, Node node, Item *replaceitem, Node neighbour,
	  bool left, bool *change, bool *sink, Item *downx,
	  Indexstatus *istat)
{
  Workpage *wp;
  bool changed, sunk;
  Node oldlink;
  
  changed = false;
  sunk = false;
  
  wp = (Workpage *) alloca (sizeof (Workpage));
  if (loadKnot (index, node, wp) < 0)
    goto errhd;
  
  if (wp->itm[0].link == i_NOLINK) {
    /* wp ist ein Blatt */
    oldlink = replaceitem->link;
    memcpy (replaceitem, &wp->itm[wp->items], sizeof (Item));
    replaceitem->link = oldlink;
    sunk = true;
  }
  else {
    /* wp ist kein Blatt und greatest wird ueber den rechtesten Zeiger
       rekursiv weitergesucht. */
    greatest (index,		/* index */
	      wp->itm[wp->items].link, /* node */
	      replaceitem,	/* replaceitem */
	      wp->itm[wp->items-1].link, /* neighbour */
	      i_LEFT,		/* left */
	      &changed,		/* change */
	      &sunk,		/* sink */
	      &wp->itm[wp->items], /* downx */
	      istat);
  }
  
  if (sunk) {
    /* das rechteste Element ist abgesunken */
    wp->items --;
    if (wp->items < istat->pagemidth) {
      if (left) {
	if (compensateleft (index, wp, node, neighbour, sink,
			    downx, istat) < 0)
	  goto errhd;
      }
      else {
	if (compensateright (index, wp, node, neighbour, sink,
			     downx, istat) < 0)
	  goto errhd;
      }
      *change = true;
    }
    changed = true;
  }
  
  if (changed) 
    if (writeKnot (index, node, wp) < 0)
      goto errhd;
  
  return 1;
  
errhd:
  return -1;
}

int
deletereftree (Index *index, 
	       Node node, 
	       Workpage *wp, 
	       int itemnr, 
	       Node ref)
{
  Node rootnode;
  bool rootchanged, skipbool;
  Item rootitem;
  Indexstatus istat;
  Keyinfo keyinfo;
  bool refsunk;
  
  rootchanged = false;
  refsunk = false;
  
  rootnode = wp->itm[itemnr].info;
  
  keyinfo.info = ref;
  keyinfo.key[0] = '\0';
  setistat (&istat, i_REFTREE);
  
  if (delete (index, &keyinfo, rootnode, 0, false, &rootchanged,
	      &skipbool, &rootitem, rootnode, &refsunk, &istat) < 0)
    goto errhd;
  
  if (rootchanged) {
    /* der rootknoten wurde geloescht.  Update die Basisseite! */
    wp->itm[itemnr].info = rootitem.link;
    if (refsunk)
      wp->itm[itemnr].reftype = i_REFLINK;
    else
      wp->itm[itemnr].reftype = i_PAGELINK;
  }
  if (writeKnot (index, node, wp) < 0)
    goto errhd;
  return 1;
errhd:
  return -1;
}

int
delete (Index *index, Keyinfo *key, Node node, Node neighbour, bool left,
	bool *change, bool *sink, Item *downx, Node rootnode,
	bool *refsunk,
	Indexstatus *istat)
{
  Workpage *wp;
  int itemnr, i;
  bool itemfound, sunk, changed;
  Node leftlink, rightlink;
  
  if (node == i_NOLINK) {		/* linker Zeiger = key not in knot */
    *sink = false;
    goto notfoundhd;
  }
  else {
    changed = false;
    sunk = false;
    
    wp = (Workpage *) alloca (sizeof (Workpage));
    if (loadKnot (index, node, wp) < 0)
      goto errhd;
    if (istat->pagetype == i_KEYTREE)
      keysearch (key->key, wp, &itemnr, &itemfound);
    else if (istat->pagetype == i_REFTREE)
      refsearch (key->info, wp, &itemnr, &itemfound);
    
    if (itemfound) {
      if (istat->pagetype == i_KEYTREE) {
	if (wp->itm[itemnr].reftype == i_PAGELINK) {
	  /* Hier erstmal nach dem Referenceeintrag suchen. Nicht gefunden? 
	     Dann gibt's auch nichts zu loeschen! */
	  if (deletereftree (index, node, wp, itemnr, key->info) < 0)
	    goto errhd;
	}
	else if (wp->itm[itemnr].reftype == i_REFLINK) {
	  /* ok, es gibt nur einen einzigen Eintrag. */
	  if (key->info == wp->itm[itemnr].info) {
	    leftlink = wp->itm[itemnr - 1].link;
	    if (leftlink == i_NOLINK) { /* key ist ein Blatt! */
	      sunk = true;
	    }
	    else {
	      rightlink = wp->itm[itemnr].link;
	      /* wp ist kein Blatt; das zu loeschende Element an der Stelle
		 itemnr ist durch das groesste Element des linken
		 Unterbaumes zu ersetzen */
	      if (greatest (index, leftlink, &wp->itm[itemnr], rightlink,
			    i_RIGHT, &changed, &sunk,
			    &wp->itm[itemnr], istat) < 0)
		goto errhd;
	      changed = true;
	    }
	  }
	  else
	    goto notfoundhd;	 
	}
      }
      else if (istat->pagetype == i_REFTREE) {
	/* ok, Eintrag gefunden, loeschen */
	leftlink = wp->itm[itemnr - 1].link;
	if (leftlink == i_NOLINK) { /* key ist ein Blatt! */
	  sunk = true;
	}
	else {
	  rightlink = wp->itm[itemnr].link;
	  /* wp ist kein Blatt; das zu loeschende Element an der Stelle
	     itemnr ist durch das groesste Element des linken Unterbaumes zu
	     ersetzen */
	  if (greatest (index, leftlink, &wp->itm[itemnr], rightlink,
			i_RIGHT, &changed, &sunk,
			&wp->itm[itemnr], istat) < 0)
	    goto errhd;
	  changed = true;
	}
      }
    }
    else {
      if (itemnr == 0) {
	/* es gibt keinen linken Nachbarn fuer einen im darunterliegenden
	   Knoten etvl. notwendigen Defizitausgleich */
	if (delete (index, key, wp->itm[0].link, /* suche ganze links, mit */
		    wp->itm[1].link, /* dem rechten als defizitausgleich */
		    i_RIGHT, &changed, &sunk, &wp->itm[1], rootnode,
		    refsunk, istat) < 0)
	  goto errhd;
	itemnr = 1;
      }
      else {
	if (delete (index, key, wp->itm[itemnr].link, /* search right path */
		    wp->itm[itemnr - 1].link, /* mit dem linken als defizit */
		    true, &changed, &sunk, &wp->itm[itemnr], rootnode,
		    refsunk, istat) < 0)
	  goto errhd;
      }
    }
    
    if (sunk) {
      wp->items --;
      for (i = itemnr; i <= wp->items; i++) {
	memcpy (&wp->itm[i], &wp->itm[i + 1], sizeof (Item));
      }
      
      if (node != rootnode) {
	if (wp->items < istat->pagemidth) {
	  if (left) {
	    if (compensateleft (index, wp, node, neighbour, sink,
				downx, istat) < 0)
	      goto errhd;
	  }
	  else {
	    if (compensateright (index, wp, node, neighbour, sink,
				 downx, istat) < 0)
	      goto errhd;
	  }
	  *change = true;
	}
      }
      else {
	if (wp->items == 0) {
	  /* die root-seite hat sich vollstaendig geleert, wir muessen die
	     Basisseite aendern! */
	  memcpy (downx, &wp->itm[0], sizeof (Item));
	  *change = true;
	  if (releaseKnot (index, wp, rootnode) < 0) /* free page */
	    goto errhd;
	}
	else
	  if (istat->pagetype == i_REFTREE) {
	    if ((wp->items == 1) && (wp->itm[0].link == 0)) {
	      /* es befindet sich nur noch ein einziges Element im Blatt. Das
		 wird dann wieder in die Keyseite selbst runtergereicht. Die
		 Referenceseite wird wieder freigegeben */
	      downx->link = wp->itm[1].info;
	      *change = true;
	      *refsunk = true;
	      if (releaseKnot (index, wp, rootnode) < 0) /* free page */
		goto errhd;
	    }
	  }
      }
      changed = true;
    }
    
    if (changed) {
      if (writeKnot (index, node, wp) < 0)
	goto errhd;
      changed = false;
    }
  }
  return 1;
  
notfoundhd:
  return 0;
  
errhd:
  return -1;
}


int
deletebtree (Index *index, char *key, Node ref)
{
  Node rootnode;
  bool rootchanged, skipbool;
  Item rootitem;
  Indexstatus istat;
  Keyinfo keyinfo;
  bool refsunk;

  cleaninput (index->file);	/* reset input stream */

  if (key) {
    rootchanged = false;
    
    if (loadBasispage (index) < 0)
      goto errhd;
    
    rootnode = getRoot (index);
    
    if (strlen (key) > i_KEYSIZE) {
      strncpy (keyinfo.key, key, i_KEYSIZE - 1);
      keyinfo.key[i_KEYSIZE] = '\0';
    }
    else
      strcpy (keyinfo.key, key);

    keyinfo.info = ref;
    setistat (&istat, i_KEYTREE);
    if (delete (index, &keyinfo, rootnode, 0, false, &rootchanged,
		&skipbool, &rootitem, rootnode, &refsunk, &istat) < 0)
      goto errhd;
    
    if (rootchanged) {
      /* der rootknoten wurde geloescht.  Update die Basisseite! */
      changeRoot (index, rootitem.link);
    }
    if (writeBasispage (index) < 0)
      goto errhd;

    cleanoutput (index->file);	/* clean up output stream */

    return 1;
  }
 errhd:
  return -1;
}

