/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include <errno.h>
#include <signal.h>
#include <ctype.h>
#include <getopt.h>

#include "kdbs.h"
#include "net.h"

int
read_key_file (char *file, char **buf, int *bufsize)
{
  FILE *stream;
  char tmp[FILENAME_MAX];
  char *home;
  long lng, sizeread;

  if (file) {
    if (index(file, '/')) {
      strcpy (tmp, file);
    }
    else {
      home = getenv ("HOME");
      if (!home)
	home = "/";
      sprintf (tmp, "%s/%s", home, file);
    }
  }
  else {
    home = getenv ("HOME");
    if (!home)
      home = "/";
    sprintf (tmp, "%s/.kdbdauth", home);
  }

  stream = fopen (tmp, "r");
  if (!stream)
    return 0;
  
  fseek (stream, 0, SEEK_END);	/* get length of file */
  lng = ftell (stream);
  fseek (stream, 0, SEEK_SET);

  if (lng > *bufsize) {
    if (*bufsize == 0)
      *buf = malloc (lng + 1);
    else
      *buf = realloc (*buf, lng + 1);
    *bufsize = lng + 1;
  }
  
  sizeread = fread (*buf, 1, lng, stream);
  (*buf)[lng] = '\0';

  if (sizeread < lng) {
    fclose (stream);
    return -1;
  }

  fclose (stream);
  return 1;
}

int
make_connection (unsigned short *iport, char **ihost)
{
  struct sockaddr_in servername;
  unsigned short port = *iport;
  char *host = *ihost;
  int sock;
  
  if (port == 0) {
    return -1;
  }

  port = establishport (port);	/* get correct port */
  host = establishhost (host);	/* get correct host */
  
  /* Create a socket. */
  sock = socket (PF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    return -1;
  }
  
  /* Connect to the daemon. */
  init_sockaddr (&servername, host, port);
  if (0 > connect (sock, (struct sockaddr *) &servername,
		   sizeof (servername))) {
    return -1;
  }
  
  *ihost = host;
  *iport = port;
  return sock;
}

int
make_login (int socket, char *kcp_code, char *logname, char *keydbfile,
	    char **tmp, int *tmpsize)
{
  int retval;
  int bufsize = 256;
  char *buf = (char*) malloc (bufsize);

  if (!*tmpsize) {
    *tmpsize = 256;
    *tmp = malloc (*tmpsize);
  }

  retval = read_key_file (keydbfile, &buf, &bufsize);
  if (retval < 0) {
    free (buf);
    goto errhd;
  }
  if (retval == 0)
    strcpy (buf, "<no key>");
  
  if (*tmpsize < 256) {
    *tmpsize = 256;
    *tmp = (char *) realloc (*tmp, *tmpsize);
  }
  sprintf (*tmp, "%s %s %s", kcp_code, logname, buf);
  free (buf);

  if (write_to_sock (socket, *tmp) < 0)
    goto errhd;
 
  if (read_from_sock (socket, tmp, tmpsize) < 0)
    goto errhd;
  
  return 1;
 errhd:
  return -1;
}
  

int
parse_login_data (char *tmp, int *connectid, char **connkey,
		  char **client_usrname, Uid *clientuid,
		  Gid *clientgid)
{
  char *token, *tail;

  token = strtok (tmp, " \n\r");
  if ((!token) ||
      (strcasecmp (token, KCP_HELO) != 0))
    NET_GOERR (_("bad protocol `helo'"));

  token = strtok (NULL, " \n\r"); /* get the id-num */
  if (!token)
    NET_GOERR (_("bad protocol: connection id"));
  *connectid = strtol (token, &tail, 0);
  
  token = strtok (NULL, " \n\r"); /* get the conn key */
  if (!token)
    NET_GOERR (_("bad protocol: connection key"));
  *connkey = strdup (token);

  token = strtok (NULL, " \n\r"); /* get the user name */
  if (!token)
    NET_GOERR (_("bad protocol: user name"));
  *client_usrname = strdup (token);

  token = strtok (NULL, " \n\r"); /* get the user id */
  if (!token)
    NET_GOERR (_("bad protocol: user id"));
  *clientuid = strtol (token, &tail, 0);

  token = strtok (NULL, " \n\r"); /* get the default group id */
  if (!token)
    NET_GOERR (_("bad protocol: default group id"));
  *clientgid = strtol (token, &tail, 0);

  return 1;
 errhd:
  return -1;
}
