/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include <signal.h>
#include <sys/types.h>
#if defined HAVE_SYS_TIME_H
# include <sys/time.h>
#endif
#if defined TIME_WITH_SYS_TIME
# include <time.h>
#endif

#include "conn.h"

/* Creates a unique keycode which is be used a password for
   server-access. it takes an integer as parameter, specifiing the length
   of the key (lng > 10 seems to be unuseful, max lng is CONNKEYSIZE!) */
static char tmpconnkey[CONNKEYSIZE];
char *
get_conn_key (int lng)
{
  struct timeval tp;
  int i;
  long t;

  gettimeofday (&tp, NULL);
  t = tp.tv_sec + tp.tv_usec;
  
  for (i = 0; i < lng; i++) {
    tmpconnkey[i] = (t % 95)+33; /* no space in keyword! */
    t /= 4;
  }
  tmpconnkey[i] = '\0';
  return tmpconnkey;
}

/* --------------------------------------------------
   Hilfsroutinen fr Connectiontables &c.
   -------------------------------------------------- */
void
free_conn (Clist *clist)
{
  if (clist) {
    if (clist->connkey)
      free (clist->connkey);
    if (clist->login)
      free (clist->login);
    free (clist);
  }
}

void
free_total_clist (Clist **clist)
{
  Clist *cl, *ncl;
  
  cl = *clist;

  while (cl) {
    ncl = cl->next;

    free_conn (cl);
    cl = ncl;
  }
  *clist = NULL;
}

void
free_connid (Clist **clist, int connid)
{
  Clist *cl, *lcl;

  cl = *clist;
  lcl = NULL;
  while (cl) {
    if (cl->connid == connid) {
      if (lcl) {
	lcl->next = cl->next;
	free_conn (cl);
	cl = lcl->next;
      }
      else {
	*clist = cl->next;
	free_conn (cl);
	cl = *clist;
      }
    }
    else {
      lcl = cl;
      cl = cl->next;
    }
  }
}

int
cleanup_clist (Clist **clist)
{
  Clist *cl, *lcl;
  int fdcon = 0;		/* a counter of freed connections */

  cl = *clist;
  lcl = NULL;
  while (cl) {
    if (cl->status == C_ZOMBIE) {
      if (lcl) {
	lcl->next = cl->next;
	free_conn (cl);
	fdcon++;
	cl = lcl->next;
      }
      else {
	*clist = cl->next;
	free_conn (cl);
	fdcon++;
	cl = *clist;
      }
    }
    else {
      lcl = cl;
      cl = cl->next;
    }
  }

  return fdcon;
}

bool
checkconnkey (Clist *cl, int connid, char *key)
{
  if (cl) {
    if ((cl->connid == connid) &&
	(strcmp (cl->connkey, key) == 0))
      return true;
  }
  return false;
}

int global_connid_counter = 0;	/* starts with 0 */
int
get_next_connid ()
{
  global_connid_counter++;
  return global_connid_counter;
}

Clist *
get_connection (Clist *clist, int connid)
{
  Clist *c = clist;
  
  while (c) {
    if (c->connid == connid)
      return c;
    c = c->next;
  }
  return NULL;
}

Clist *
alloc_clist ()
{
  Clist *cl = (Clist *) malloc (sizeof (Clist));

  cl->status = C_NULL; /* nicht belegt */
  cl->port = 0;
  cl->login = NULL;
  cl->connkey = NULL;
  cl->connid = 0;
  cl->next = NULL;
  return cl;
}

Clist *
get_new_conn ()
{
  Clist *cl = alloc_clist ();
  
  cl->connid = get_next_connid ();
  cl->connkey = strdup (get_conn_key (8));
  return cl;
}


Clist *
insert_conn (Clist **clist, Clist *cl)
{
  if (*clist) {
    cl->next = *clist;
    *clist = cl;
  }
  else {
    *clist = cl;
  }
  return cl;
}

void
showconns (Clist *clist)
{
  Clist *cl = clist;
  
  printf ("CONNECTIONLIST:\n");
  while (cl) {
    printf ("ID: %d KEY: %s UID: %d STATUS: %c\n",
	    cl->connid, cl->connkey, cl->uid, cl->status);
    cl = cl->next;
  }
}
