/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_SERVER_H
#define _KDBS_SERVER_H

#include "kdbs.h"
#include "kscm.h"
#include "net.h"

#define GETRES_NONE    0
#define GETRES_OK      1
#define GETRES_WAIT    2
#define GETRES_DENIED  3

/* from sexp.c */
extern Atom lastexp;
extern jmp_buf interpreter_error;
#define GOERR(estr) ({lastexp = 0; errstr = (estr); goto errhd; })
#define PRINTERR(estr) ({fprintf (stderr, "kaenguru: %s\n", estr); })
#define SHOWK4ERR()				\
({						\
  printf("k4 error: %s\n", errstr); 		\
  if (lastexp) {				\
    printf(_("Error occured in: "));		\
    show (lastexp);				\
    printf ("\n");				\
  }						\
})

/* main.c */
extern bool errormsgs;

extern int connectid;
extern char *connkey;
extern char *client_usrname;
extern Uid clientuid;		
extern Gid clientuid;		
extern bool trace;
extern int tracing (const char *message);
extern int getres_status;
extern int clientsock;
extern int daemonsock;
extern int eoserver;
extern char configpath[FILENAME_MAX];
extern int class_outdate_period;
extern int class_check_period;
extern int timeoutval;

/* server.c */
extern int servercycle ();

/* from config.c */
extern int read_configuration (char *name);
#endif
