/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include <errno.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#include "server.h"
#include "lock.h"
#include "dbfunc.h"

/* include the k4 stuff */
#include "proto.h"


/* GLOBALE VARIABLEN */
int eoserver = 0;		/* server zu ende? */
int getres_status = GETRES_NONE;

int do_client_request (int clientsock, int daemonsock, char *buf);

jmp_buf interpreter_error;

/* --------------------------------------------------
   Die eigentliche Serverroutinen 
   -------------------------------------------------- */

/* servercycle stellt die eigentliche listenroutine des Servers da, die
 * auf Anfragen von clients und dem Daemon wartet und diese Anfragen ent-
 * sprechend in EXITS oder Datenbankanweisungen umsetzt.
 */
int
servercycle ()
{
  const char spacedelim[]=" \n\r\t";
  fd_set
    active_fd_set, read_fd_set;	/* for select */
  int 
    testsock;			/* sock fr testing */
  int 
    selectval, 
    retval;			/* return values */
  char *token;
  struct timeval  
    timeout;			/* fr die timeoutroutine */
  Date acttime, lasttime = 0;

  /* INIT-PHASE of the LISP-Interpreter ------------------------------ */  
  if (setjmp (interpreter_error) > 0) { 
    printf(_("error during initialization: %s\n"), errstr); 
    if (lastexp) {
      printf(_("Error occured in: "));
      show(lastexp);
      printf ("\n");
    }
    goto errhd;
  }
  
  /* init the interpreter */
  initscm (0);			/* 1: we need init.k4! */

  /* ----- no start the server-run ------------------------------------ */  
  /* talk to daemon : ok, listeningport established + id-number */
  FD_ZERO (&active_fd_set);	/* init activ-sockets for select */
  FD_SET (daemonsock, &active_fd_set);
  FD_SET (clientsock, &active_fd_set);
  

  /* --------------------------------------------------------------------
     Ab hier die eigentliche Server loop
     -------------------------------------------------------------------- */
  eoserver = false;  
  
  while (!eoserver) {
    
    read_fd_set = active_fd_set;
    
    /* diese seltsame Schleife um einfache INTR-Signale abzufangen */
  justtemperror:
    if (class_check_period) {
      timeout.tv_sec = class_check_period; /* dann sofort berprfen */
      timeout.tv_usec = 0;	/* test 2 times a second */
      selectval = select (FD_SETSIZE, &read_fd_set, NULL, NULL, &timeout);
    }
    else {
      selectval = select (FD_SETSIZE, &read_fd_set, NULL, NULL, NULL);
    }
    if (selectval < 0) {
      if (errno == EINTR)
	goto justtemperror;
      GOERR (_("select error"));
    }
    
    /* test for chache cleanup */
    acttime = get_system_time ();
    if ((class_check_period) &&
	(lasttime + class_check_period < acttime)) {
      cleanup_cache (class_outdate_period, acttime);
      lasttime = acttime;
    }

    for (testsock = 0; testsock < FD_SETSIZE; ++testsock) { /* FD_SETSIZE */
      
      if (FD_ISSET (testsock, &read_fd_set)) { /* activ socket? */
	
	/* handelt es sich ansonsten vielleicht um Anfragen vom daemonsock,
	 * d.h. handelt es sich vielleicht um einen Leitungszusammenbruch,
	 * um explizite EXIT-Requests?
	 */
	
	if (testsock == daemonsock) {	/* anfrage vom daemon */
	  int bufsize = 1024;
	  char *buffer = (char*) malloc (bufsize);

	  if (read_from_sock (testsock, &buffer, &bufsize) <= 0) {
	    /* sock is broken -- if the clientsock gots broken too, we have
               no chance; so ignore any error here */
	    writesockf (clientsock, 
			_("%c%s the daemon died - security halt\n"),
			KCP_ERRC, KCP_ERR);
	    
	    PRINTERR (_("daemon died"));
	    
	    close (daemonsock);	        /* client/server socket schlieen  */
	    FD_CLR (daemonsock, &active_fd_set);
	    eoserver = 1;	/* server ende */
	    free (buffer);
	    goto serverende;
	  }
	  
	  token = strtok (buffer, spacedelim);
	  
	  if (token) {
	    /* ----- HALT-COMMANDO by DAEMON -------------------------- */
	    if (strcasecmp (token, KCP_HALT) == 0) {
	      /* we haven't to print an error message here, I think.  It is
                 an explicit request by the daemon */
/* 	      sprintf (buffer, "%c%s daemon close request\n", */
/* 		       KCP_ERRC, KCP_ERR); */
/* 	      write_to_sock (clientsock, buffer); */
	      PRINTERR (_("explicit close request from daemon"));
	      
	      close (clientsock); /* daemon/server socket schlieen  */
	      close (daemonsock); /* daemon/server socket schlieen  */
	      FD_CLR (daemonsock, &active_fd_set);
	      FD_CLR (clientsock, &active_fd_set);
	      eoserver = 1;	/* server ende */
	      free (buffer);
	      goto serverende;
	    }
	    
	    else if (strcasecmp (token, KCP_ENDTRANS) == 0) {
	    }
	    else if (strcasecmp (token, KCP_TRANS) == 0) {
	    }
	    /* ----- UNKNOWN COMMANDO -------------------------------- */
	    else {
	      printf(_("unknown command from daemon: %s\n"), token);
	    }
	    
	  }
	  free (buffer);
	}
	else {		/* data from client */
	  int bufsize = 1024;
	  char *buffer = (char*) malloc (bufsize);

	  /* ansonsten kann es sich nur noch um Daten und Anfragen vom
	     client handeln */
	  
	  if (read_from_sock (testsock, &buffer, &bufsize) <= 0) {
	    /* client-server-conn broken */
	    tracing ("Connection to client lost.\n");

	    close (testsock);
	    eoserver = 1;	/* Serverende! */
	    /* since the server is halted a moment later, we may ignore
               every error here */
	    writesockf (daemonsock, 
			"%s %d %s I'm going home.\n",
			KCP_CLOSE,
			connectid, connkey);
	    free (buffer);
	    goto serverende;
	  }
	  else {
	    retval = do_client_request (clientsock, daemonsock, buffer); 
	    if (retval < 0) {
	      free (buffer);
	      goto errhd;
	    }
	  }
	  
	  free (buffer);
	}
      }
    }
  }
  
 serverende:
  if (errstr)
    goto errhd;
  return 0;
  
 errhd:
  SHOWK4ERR();
  return -1;
}


int
do_client_request (int clientsock, int daemonsock, char *buf)
{
  char tmp[MAXMSG];
  char *token;
  
  if (buf) {
    
    token = strtok (buf, " \n\t\r");
    if (token) {

      if (strcasecmp (token, KCP_LISP) == 0) { /* a lisp request! */
	token = strtok (NULL, "\r");
	
	if (token) {
	  if (setjmp (interpreter_error) > 0) { 
	    SHOWK4ERR();
	    if (writesockf (clientsock, "%c%s %s\n",
			    KCP_ERRC, KCP_ERR, errstr) <= 0)
	      goto clientsock_broken;
	  }
	  else {
	    reset_scm ();
	    execute_buffer (token, PLAIN_CODE);
	    if (writesockf (clientsock, "%c%s", KCP_OKC, KCP_OK) <= 0)
	      goto clientsock_broken;
	  }
	}
      } 
      
      else if (strcasecmp (token, KCP_GETVAL) == 0) {
	if (k4data_to_sock (clientsock, lasteval) <= 0)
	  goto clientsock_broken;
      }
      else if (strcasecmp (token, KCP_TALKLISP) == 0) {
	if (show_to_sock (clientsock, lasteval) <= 0)
	  goto clientsock_broken;
      }
      else if (strcasecmp (token, KCP_READ_DFIELD) == 0) {
	token = strtok (NULL, " \n\t\r");
	
 	if (token) { 
	  char *tail;
	  int blobid = strtol (token, &tail, 0);
	  Atom blobobj = blob_ref (blobid);

	  if (blobobj != FALSE) {
	    if (blob_to_sock (clientsock, blobobj) <= 0)
	      goto clientsock_broken;
	  }
	  else {
	    if (writesockf (clientsock,
			    _("%c%s no object handle"),
			    KCP_ERRC, KCP_ERR) <= 0)
	      goto clientsock_broken;
	  }
	}
      }
      else if (strcasecmp (token, KCP_STORE_DFIELD) == 0) {
	token = strtok (NULL, " \n\t\r");
	
 	if (token) { 
	  char *tail;
	  int blobid = strtol (token, &tail, 0);
	  Atom blobobj = blob_ref (blobid);

	  if (blobobj != FALSE) {
	    read_blob_from_sock (clientsock, blobobj);
	  }
	}
      }
      
      else if (strcasecmp (token, KCP_QUIT) == 0) {
	/* since the clientsock is closed a moment later, we may ignore any
           error here */
	writesockf (daemonsock,
		    "%s %d %s I'm going home.\n",
		    KCP_CLOSE,
		    connectid, connkey);
	eoserver = 1;
	close (clientsock);
	close (daemonsock);
	return 1;
      }
      
      else {
	sprintf (tmp, "Unknown request from client: %s\n", token);
	if (tracing (tmp) <= 0)
	  goto daemon_lost;
      }
    }
  }
  
  return 1;

 clientsock_broken:
  return -1;

 daemon_lost:
  return -2;
}



