/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_PROTO_H
#define _KDBS_PROTO_H

#include "kscm.h"

/* ----------------------------------------------------------------------
   SECURE MALLOC!
   ---------------------------------------------------------------------- */
#define smalloc(size)				\
({						\
  void *_buf = malloc (size);			\
  if (!_buf)					\
    SETERR (0, _("virtual memory exhausted"));	\
  _buf;						\
})

/* ----------------------------------------------------------------------
   Variables
   ---------------------------------------------------------------------- */
/* from sexp.c */
extern Cell *heap;
extern Oblist *oblist;
extern Strlist *strlist;
extern Hashlist *hashlist;

extern int heapsize;
extern int oblistsize;
extern int strlistsize;
extern int hashlistsize;

extern int defaultstacksize;
extern int defaulthashlistsize;
extern int defaultstrlistsize;
extern int defaultoblistsize;
extern int defaultheapsize;

extern int verbose;
extern int talklisp;

extern int hashpagesize;
extern int hashsize, systemhash;

extern Atom lastexp;
extern jmp_buf interpreter_error;

extern Blobrec bloblist;

/* from memory.c */
extern int gc_stackpagesize;
extern int gc_initstacksize;
extern int heappagesize;
extern int maxheapsize;
extern int oblistpagesize;
extern int maxoblistsize;
extern int strlistpagesize;
extern int maxstrlistsize;
extern int minfreecell;
extern int minfreeobj;
extern int minfreestr;
extern int stackpagesize;

/* from run.c */
extern char default_lisp_path[FILENAME_MAX];

/* from scan.y */
extern Atom lasteval;

/* from string.c */
extern char *charnametable[];

/* ----------------------------------------------------------------------
   Prototypes
   ---------------------------------------------------------------------- */

/* from sexp.c */
extern void initscm (int initneeded);
extern Atom lookup (int hash);
extern int addhash (char *name);
extern void make_fset (char *name, int hashcode, char *args, void *fnc);

extern Atom eq (Atom first, Atom sec);
extern Atom equal (Atom first, Atom sec);
extern int numv (Atom x);
extern Atom number (Atom x);

extern Vector * make_vector (int alloc_size, int size, Atom fill);
extern void vector_set (Vector *vec, Atom val, int ref);
extern Atom vector_ref (Vector *vec, int ref);
extern void vector_fill (Vector *vec, Atom fill);
extern int vector_lookup (Vector *vec, Atom obj);
extern void vector_set_length (Vector *vec, int size);
extern void vector_sort (Vector *vec);
extern Vector * vector_merge_and (Vector *vec1, Vector *vec2);
extern Vector * vector_merge_or (Vector *vec1, Vector *vec2);
extern Vector * vector_merge_xany (Vector *vec1, Vector *vec2);
extern Vector * vector_merge_xor (Vector *vec1, Vector *vec2);

extern Vector * empty_object (Atom class, Atom oid);

extern void init_bloblist ();
extern Blobrec * record_blob (Atom obj, int blobid);
extern int free_blob (int blobid);
extern Dfield * make_dfield (char *buf, int size);
extern Dfield * set_dfield (Dfield *dfield, char *buf, int size);
extern Atom blob_ref (int blobid);

extern char* date2string (Date date, int format);
extern Date string2date (char *strline);

/* from memory.c */
extern int gc (int minfree, int *sexp, int *obj, int *str);
extern Atom alloc_cell (Atom car, Atom cdr);
extern Atom alloc_obl (int typ, void *value);
extern Atom alloc_str (char *strq, int mode);

extern void initstack (int initstacksize);
extern void pushstack (Atom x);
extern Atom popstack ();

extern void initactivl ();

extern void reset_scm ();

extern Atom look_up_cache (Atom obj);
extern void cleanup_cache (int timespan, Date acttime);

/* from list.c */
extern void init_vars ();
extern void init_hash ();

/* from talklisp.c */
extern void show (Atom list);
extern int show_to_sock (int socket, Atom cell);
extern int k4data_to_sock (int socket, Atom cell);
extern int blob_to_sock (int sock, Atom obj);
extern void read_blob_from_sock (int sock, Atom obj);

/* from run.c */
extern void initpaths ();
extern char * loadlispprog (char *name, int *len, int *fenc);
extern int execute_buffer (char *buffer, int fenc);
extern Atom run_file (char *name, Atom mode);

/* from scan.y */
extern int runprog_plain (char *source);
extern void initparse ();

/* from eval.c */
extern Atom autoload_sym (char *filename);
extern int check_fset_args(char *argstr, Atom params);
extern Atom evaluate (Atom list);

/* from strings.c */
extern char decode_char (char *str);

/* from compile.c */
extern Atom code2list (char *prog);
extern char *list2code (Atom list, int *blng, int commentp);

/* initialization prototypes */
extern void init_numeric ();	/* from num.c */
extern void init_funcs ();	/* from func.c */
extern void init_sysfuncs ();	/* from sys.c */
extern void init_strings ();	/* from strings.c */
extern void init_chars ();	/* from chars.c */
extern void init_vectors ();	/* from vectors.c */
extern void init_db_funcs ();	/* from dbfunc.c */
extern void init_talklisp ();	/* initialize the output */
extern void initdatabase();	/* init the database */
extern void init_admin ();	/* init the adminstration functions */
#endif


