/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
# if defined HAVE_STRING_H
#  include <string.h>
# else
#  include <strings.h>
# endif
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include "proto.h"
#include "hc.h"
#include "dbfunc.h"

/* ----------------------------------------------------------------------
   LISTE DER BUILTIN VARIABLES
   name:    Name der variablen
   hc:      der hashcode wie er in hc.h definiert ist
   ro:      h_RO = readonly variable
            h_RW = readwrite variable
   typ:     NIL = kein besonderer Typ, ansonsten bisher nur INT_T
   in?:     true = internal (wird vom Interpreter als Standardlispvariable
                   behandelt)
            false = external (die Speicherstelle wird von C "verwaltet")
   init:    ein default-wert der Variable (interne variable knnen als
            Integer, Strings und Hashs initialisiert werden, externe z.Z.
            nur als Integer).  Wird NULL angegeben (oder ist typ == NIL)
            so ist der defaultwert stets c_NIL
   addr:    bei externen variablen der C offset der Variable

   ---------------------------------------------------------------------- */
Vartable variables[] = {
  /*   name        hc,        ro    typ  in?   init  addr */
  {"load-path",  h_LOAD_PATH, h_RW, NIL, true, NULL, NULL},
  {"cache",      h_CACHE,     h_RW, NIL, true, NULL, NULL},
  {"base-path",  h_BASE_PATH, h_RO, NIL, true, NULL, NULL},
  {"heapsize",   h_HEAPSIZE,  h_RO, INT_T, false, (void*)-1, &heapsize},
  {"oblistsize", h_OBLSIZE,   h_RO, INT_T, false, (void*)-1, &oblistsize},
  {"strlistsize", h_STRLSIZE,  h_RO, INT_T, false, (void*)-1, &strlistsize},
  {"verbose",    h_VERBOSE,   h_RW, INT_T, false, (void*)0, &verbose},
  {"talklisp",   h_TALKLISP,  h_RW, INT_T, false, (void*)1, &talklisp},
  {"forceindex", h_FORCEINDEX, h_RW, INT_T, false, (void*)0, &forceindex},
  {NULL, 0}
};

/* ----------------------------------------------------------------------
   HASH_LISTS
   ---------------------------------------------------------------------- */
Hashpredefined hashpredefined[] = {
  {h_STR,               "str"},
  {h_INT,               "int"},
  {h_OBJ,               "obj"},
  {h_VECTOR,            "vector"},
  {h_OID,               "oid"},
  {h_UID,               "uid"},
  {h_FID,               "fid"},
  {h_GID,               "gid"},
  {h_MOD,               "mode"},
  {h_CREAT,             "creation"},
  {h_DATE,              "date"},
  {h_BOOL,              "bool"},
  {h_DFIELD,            "dfield"},
  {h_CHAR,              "char"},
  {h_SYM,               "sym"},
  {h_RO,                ":ro"},
  {h_RW,                ":rw"},
  {h_CLOS,              ":closure"},
  {h_SPEC,              ":spec"},
  {h_FSET,              ":fset"},
  {h_OBJECT,            ":object"},
  {h_CORE,              "Core"},
  {h_ELSE,              "else"},
  {h_DATEFORM_NORMAL,   "dateform-normal"},
  {h_DATEFORM_UNIX,     "dateform-unix"},
  {h_DATEFORM_AMERICAN, "dateform-american"},
  {h_DATEFORM_GERMAN,   "dateform-german"},
  {h_DATEFORM_KOREAN,   "dateform-korean"},
  {h_QUOTE,             "quote"},
  {h_LAMBDA,            "lambda"},
  {h_DEFINE,            "define"},
  {h_SET,               "set!"},
  {h_DEFINES,           "define*"},
  {h_SETS,              "set*!"},
  {h_IF,                "if"},
  {h_AND,               "and"},
  {h_OR,                "or"},
  {h_XOR,               "xor"},
  {h_XANY,              "xany"},
  {h_BEGIN,             "begin"},
  {h_LETS,              "let*"},
  {h_LET,               "let"},
  {h_COND,              "cond"},
  {h_LETREC,            "letrec"},
  {h_CASE,              "case"},
  {h_DBNAME,            "db-name"}, /* achtung: nderungen an diesen Namen */
  {h_DBPATH,            "db-path"}, /* mssen auch in database.k4 */
  {h_INDICES,           "db-indices"}, /* nachgetragen werden! */
  {h_DATAFILES,         "db-files"},
  {h_UPDATEOBJ,         "db-update-obj"},
  {h_SUPER_CLASS_SLOT,  "super-class-slot"},
  {h_OID_SLOT,          "oid-slot"},
  {h_METHL_SLOT,        "methl-slot"},
  {h_DESCL_SLOT,        "descl-slot"},
  {h_VAL_SLOT,          "val-slot"},
  {h_FID_SLOT,          "fid-slot"},
  {h_UID_SLOT,          "uid-slot"},
  {h_GID_SLOT,          "gid-slot"},
  {h_KEY,               "key"},
  {h_REGEXP,            "regexp"},
  {h_REGEXP_FULL,       "regexp-full"},
  {h_TRAVERSE,          "traverse"},
  {h_REGEXP_OID,        "regexp-oid"},
  {0, NULL}
};

/* ----------------------------------------------------------------------
   Now the functions to initialize the tables
   ---------------------------------------------------------------------- */
void
init_vars ()			/* puts functions in table. */
{
  int i, hc;
  Atom rootx, rx;
  
  PUSH_SCANL();
  rx = rootx = SAVE_ROOT();

  for (i = 0; variables[i].name; i++) {
    hc = variables[i].hashcode;
    if (hc >= 0) {
      SETHASH (variables[i].name, hc);
    }
    else
      hc = addhash (variables[i].name);
    if (variables[i].intrn) {
      switch (variables[i].typ) {
      case INT_T:
	rx = CDR(rootx) = AINT((Atom)variables[i].deflt);
	break;
      case BOOL_T:
	rx = CDR(rootx) = ABOOL((int)variables[i].deflt);
	break;
      case CHAR_T:
	rx = CDR(rootx) = ACHAR((int)variables[i].deflt);
	break;
      case STR_T:
	rx = CDR(rootx) = NEWSTR((char *)variables[i].deflt);
	break;
      case HASH_T:
	rx = CDR(rootx) = AHASH((int)variables[i].deflt);
	break;
      default:
	rx = CDR(rootx) = NIL;
      }
    }
    else {
      int *j = (variables + i)->addr;
      rx = CDR(rootx) = NEWEXTINT(j); /* new ext-var object */
      if ((int)variables[i].deflt >= 0) {
	*OBL_INT(rx) = (int)variables[i].deflt;
      }
    }
    PUTSYM (GENVL,		/* to the global environment */
	    hc,			/* the 'name' */
	    variables[i].modus,	/* h_RO, h_RW */
	    CDR(rootx));	/* the data or offset */
  }
  POP_SCANL();
}

/* at first set up a list of labels, which hash_codes we _KNOW_ - codes
   that are used to speed up the machine, e.g. quote
   
   ACHTUNG: Strings werden hier lediglich nur zugewiesen 

   ACHTUNG 2: in hashpredefined stehen die Hashcodes.  Sie sind hard coded
   und mssen lckenlos aufeinanderfolgen, da diese Hashcode als direkte
   Adressen in der Hashliste dienen!  Nur so kann direkt auf die Hashliste
   zugegriffen werden */
void
init_hash ()
{
  register int i;
  systemhash = hashsize = 0;
  
  for (i = 0; hashpredefined[i].string; i++) {
    SETHASH (hashpredefined[i].string, hashpredefined[i].hash);
  }
}






