/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
#endif
#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#include "proto.h"
#include "hc.h"

static char s_list[] = "list";
static char a_list[] = ".>*";
Atom
f_list (Atom list)
{
  return list;
}

static char s_booleanq[] = "boolean?";
static char a_booleanq[] = "*";
Atom
f_booleanq (Atom list)
{
  return ((TYP(CAR(list)) == BOOL_P) ? TRUE : FALSE);
}

static char s_atomq[] = "atom?";
static char a_atomq[] = "*";
Atom
f_atomq (Atom list)
{
  return ATOMQ(CAR(list));
}

static char s_listq[] = "list?";
static char a_listq[] = "*";
Atom
f_listq (Atom list)
{
  return LISTQ(CAR(list));
}

static char s_nullq[] = "null?";
static char a_nullq[] = "*";
Atom
f_nullq (Atom list)
{
  return NULLQ(CAR(list));
}

static char s_eq[] = "eq?";
static char a_eq[] = "**";
Atom
f_eq (Atom list)
{
  return eq (CAR(list), CAR(CDR(list)));
}

static char s_equalq[] = "equal?";
static char a_equalq[] = "**";
Atom
f_equalq (Atom list)
{
  return equal (CAR(list), CAR(CDR(list)));
}

static char s_appends[] = "append!";
static char a_appends[] = "l*";
Atom
f_appends (Atom list)
{
  return NCONC (CAR(list), CADR(list));
}

static char s_append[] = "append";
static char a_append[] = "l*";
Atom
f_append (Atom list)
{
  return APPEND(CAR(list), CADR(list));
}

static char s_setcdr[] = "set-cdr!";
static char a_setcdr[] = "l*";
Atom
f_setcdr (Atom list)
{
  return CDR(CAR(list)) = CAR(CDR(list));
}

static char s_setcar[] = "set-car!";
static char a_setcar[] = "l*";
Atom
f_setcar (Atom list)
{
  return CAR(CAR(list)) = CAR(CDR(list));
}

static char s_assoc[] = "assoc";
static char a_assoc[] = "*l";
Atom
f_assoc (Atom list)
{
  return ASSOC(CAR(CDR(list)), CAR(list));
}

static char s_assq[] = "assq";
static char a_assq[] = "*l";
Atom
f_assq (Atom list)
{
  return ASSQ(CAR(CDR(list)), CAR(list));
}

static char s_memq[] = "memq";
static char a_memq[] = "*l";
Atom
f_memq (Atom list)
{
  return MEMQ(CAR(CDR(list)), CAR(list));
}

static char s_member[] = "member";
static char a_member[] = "*l";
Atom
f_member (Atom list)
{
  return MEMBER(CAR(CDR(list)), CAR(list));
}

static char s_car[] = "car";
static char a_car[] = "l";
Atom
f_car (Atom list)
{
  return CAR(CAR(list));
}

static char s_cdr[] = "cdr";
static char a_cdr[] = "l";
Atom
f_cdr (Atom list)
{
  return CDR(CAR(list));
}

static char s_caar[] = "caar";
static char a_caar[] = "l";
Atom
f_caar (Atom list)
{
  Atom l = CAR(list);
  if (TYP(CAR(l)) == CELL_P)
    return CAAR(l);
  SETERR(CAR(l), LEWRONGTYP);
}

static char s_cadr[] = "cadr";
static char a_cadr[] = "l";
Atom
f_cadr (Atom list)
{
  Atom l = CAR(list);
  if (TYP(CDR(l)) == CELL_P)
    return CADR(l);
  SETERR(CDR(l), LEWRONGTYP);
}

static char s_cdar[] = "cdar";
static char a_cdar[] = "l";
Atom
f_cdar (Atom list)
{
  Atom l = CAR(list);
  if (TYP(CAR(l)) == CELL_P)
    return CDAR(l);
  SETERR(CAR(l), LEWRONGTYP);
}

static char s_cddr[] = "cddr";
static char a_cddr[] = "l";
Atom
f_cddr (Atom list)
{
  Atom l = CAR(list);
  if (TYP(CDR(l)) == CELL_P)
    return CDDR(l);
  SETERR(CDR(l), LEWRONGTYP);
}

static char s_caaar[] = "caaar";
static char a_caaar[] = "l";
Atom
f_caaar (Atom list)
{
  Atom l = CAAR(list);
  if (TYP(l) == CELL_P) {
    l = CAR(l);
    if (TYP(l) == CELL_P)
      return CAR(l);
  }
  SETERR(l, LEWRONGTYP);
}

static char s_cdaar[] = "cdaar";
static char a_cdaar[] = "l";
Atom
f_cdaar (Atom list)
{
  Atom l = CAAR(list);
  if (TYP(l) == CELL_P) {
    l = CAR(l);
    if (TYP(l) == CELL_P)
      return CDR(l);
  }
  SETERR(l, LEWRONGTYP);
}

static char s_cadar[] = "cadar";
static char a_cadar[] = "l";
Atom
f_cadar (Atom list)
{
  Atom l = CAAR(list);
  if (TYP(l) == CELL_P) {
    l = CDR(l);
    if (TYP(l) == CELL_P)
      return CAR(l);
  }
  SETERR(l, LEWRONGTYP);
}

static char s_cddar[] = "cddar";
static char a_cddar[] = "l";
Atom
f_cddar (Atom list)
{
  Atom l = CAAR(list);
  if (TYP(l) == CELL_P) {
    l = CDR(l);
    if (TYP(l) == CELL_P)
      return CDR(l);
  }
  SETERR(l, LEWRONGTYP);
}

static char s_caadr[] = "caadr";
static char a_caadr[] = "l";
Atom
f_caadr (Atom list)
{
  Atom l = CDAR(list);
  if (TYP(l) == CELL_P) {
    l = CAR(l);
    if (TYP(l) == CELL_P)
      return CAR(l);
  }
  SETERR(l, LEWRONGTYP);
}

static char s_cdadr[] = "cdadr";
static char a_cdadr[] = "l";
Atom
f_cdadr (Atom list)
{
  Atom l = CDAR(list);
  if (TYP(l) == CELL_P) {
    l = CAR(l);
    if (TYP(l) == CELL_P)
      return CDR(l);
  }
  SETERR(l, LEWRONGTYP);
}

static char s_caddr[] = "caddr";
static char a_caddr[] = "l";
Atom
f_caddr (Atom list)
{
  Atom l = CDAR(list);
  if (TYP(l) == CELL_P) {
    l = CDR(l);
    if (TYP(l) == CELL_P)
      return CAR(l);
  }
  SETERR(l, LEWRONGTYP);
}

static char s_cdddr[] = "cdddr";
static char a_cdddr[] = "l";
Atom
f_cdddr (Atom list)
{
  Atom l = CDAR(list);
  if (TYP(l) == CELL_P) {
    l = CDR(l);
    if (TYP(l) == CELL_P)
      return CDR(l);
  }
  SETERR(l, LEWRONGTYP);
}

static char s_not[] = "not";
static char a_not[] = "*";
Atom
f_not (Atom list)
{
  return NOT(CAR(list));
}

static char s_cons[] = "cons";
static char a_cons[] = "**";
Atom
f_cons (Atom list)
{
  return CONS(CAR(list), CAR(CDR(list)));
}

static char s_acons[] = "acons";
static char a_acons[] = "***";
Atom
f_acons (Atom list)
{
  return ACONS (CAR(list), CADR(list), CADDR(list));
}

static char s_symbolq[] = "symbol?";
static char a_symbolq[] = "*";
Atom
f_symbolq (Atom list)
{
  if (TYP(CAR(list)) == HASH_P)
    return TRUE;
  return FALSE;
}

static char s_procedureq[] = "procedure?";
static char a_procedureq[] = "*";
Atom
f_procedureq (Atom list)
{
  if ((TYP(CAR(list)) == HASH_P)
      && ((HASHV(CAR(list)) == h_CLOS)
	  || (HASHV (CAR(list)) == h_FSET)))
    return TRUE;
  return FALSE;
}

static char s_oidq[] = "oid?";
static char a_oidq[] = "*";
Atom
f_oidq (Atom list)
{
  return OIDQ(list);
}

static char s_objectq[] = "object?";
static char a_objectq[] = "*";
Atom
f_objectq (Atom list)
{
  return OBJECTQ(CAR(list));
}

static char s_dateq[] = "date?";
static char a_dateq[] = "*";
Atom
f_dateq (Atom list)
{
  return DATEQ(CAR(list));
}

static char s_length[] = "length";
static char a_length[] = "l";
Atom
f_length (Atom list)
{
  return NEWINT(LENGTH(CAR(list)));
}

static char s_list_tail[] = "list-tail";
static char a_list_tail[] = "ln";
Atom
f_list_tail (Atom list)
{
  return LIST_TAIL(CAR(list), numv(CADR(list)));
}

static char s_list_ref[] = "list-ref";
static char a_list_ref[] = "ln";
Atom
f_list_ref (Atom list)
{
  return LIST_REF(CAR(list), numv(CADR(list)));
}

static char s_sym2str[] = "symbol->string";
static char a_sym2str[] = "h";
Atom
f_sym2str (Atom list)
{
  return NEWSTR(HASH_STR(CAR(list)));
}

static char s_str2sym[] = "string->symbol";
static char a_str2sym[] = "s";
Atom
f_str2sym (Atom list)
{
  return NEWHASH(STR_STR(CAR(list)));
}

static char s_type[] = "type";
static char a_type[] = "a";
Atom
f_type (Atom list)
{
  switch (TYP(CAR(list))) {
  case CHAR_P: return AHASH(h_CHAR);
  case HASH_P: return AHASH(h_SYM);
  case STR_P: return AHASH(h_STR);
  case BOOL_P: return AHASH(h_BOOL);
  case INT_P: return AHASH(h_INT);
  case OID_P: return AHASH(h_OID);
  case OBL_P: 
    switch (OBL_TYP(CAR(list))) {
    case OID_T: return AHASH(h_OID);
    case DATE_T: return AHASH(h_DATE);
    case EXTINT_T: return AHASH(h_INT);
    case EXTSTR_T: return AHASH(h_STR);
    case VECTOR_T: return AHASH(h_VECTOR);
    case DFIELD_T: return AHASH(h_DFIELD);
    }
  }
  return UNSPECIFIED;
}

static char s_date2str[] = "date->string";
static char a_date2str[] = "d.h";
Atom
f_date2str (Atom list)
{
  int format = h_DATEFORM_NORMAL;
  if (CDR(list) != NIL)
    format = HASHV(CAR(CDR(list)));
  return NEWSTR(date2string ((Date)OBL_DATA(CAR(list)), format));
}

static char s_str2date[] = "string->date";
static char a_str2date[] = "s";
Atom
f_str2date (Atom list)
{
  return NEWDATE(string2date(STR_STR(CAR(list))));
}

static char s_cur_time[] = "current-time";
static char a_cur_time[] = "";
Atom
f_cur_time (Atom list)
{
  return NEWDATE(get_system_time());
}

static char s_display[] = "display";
static char a_display[] = "*.>*";
Atom
f_display (Atom list)
{
  Atom s = list;
  while (TYP(s) == CELL_P) {
    switch (TYP(CAR(s))) {
    case CHAR_P:
      printf ("%c", CHARV(CAR(s)));
      break;
    case INT_P:
      printf ("%d", INTV(CAR(s)));
      break;
    case STR_P:
      printf ("%s", STR_STR(CAR(s)));
      break;
    default:
      show (CAR(s));
    }
    s = CDR(s);
  }
  return UNSPECIFIED;
}

static char s_list2code[] = "list->code";
static char a_list2code[] = "l.b";
Atom
f_list2code (Atom list)
{
  int blng = 0;
  char *buf = NULL;
  int commentp = true;
  if ((CDR(list) != NIL)
      && (CADR(list) == FALSE))
    commentp = false;
  buf = list2code (CAR(list), &blng, commentp);
  return NEWDFIELD(make_dfield (buf, blng));
}

void
init_funcs ()
{
  Functiontable functbl[] = {
    {s_list, h_LIST, a_list, f_list},
    {s_booleanq, h_BOOLEANQ, a_booleanq, f_booleanq},
    {s_atomq, h_ATOMQ, a_atomq, f_atomq},
    {s_listq, h_LISTQ, a_listq, f_listq},
    {s_nullq, h_NULLQ, a_nullq, f_nullq},
    {s_eq, h_EQ, a_eq, f_eq},
    {s_equalq, h_EQUALQ, a_equalq, f_equalq},
    {s_appends, h_APPENDS, a_appends, f_appends},
    {s_append, h_APPEND, a_append, f_append},
    {s_setcdr, h_SETCDR, a_setcdr, f_setcdr},
    {s_setcar, h_SETCAR, a_setcar, f_setcar},
    {s_assoc, h_ASSOC, a_assoc, f_assoc},
    {s_assq, h_ASSQ, a_assq, f_assq},
    {s_memq, h_MEMQ, a_memq, f_memq},
    {s_member, h_MEMBER, a_member, f_member},
    {s_car, h_CAR, a_car, f_car},
    {s_cdr, h_CDR, a_cdr, f_cdr},
    {s_caar, h_CAAR, a_caar, f_caar},
    {s_cadr, h_CADR, a_cadr, f_cadr},
    {s_cdar, h_CDAR, a_cdar, f_cdar},
    {s_cddr, h_CDDR, a_cddr, f_cddr},
    {s_caaar, h_CAAAR, a_caaar, f_caaar},
    {s_cdaar, h_CDAAR, a_cdaar, f_cdaar},
    {s_cadar, h_CADAR, a_cadar, f_cadar},
    {s_cddar, h_CDDAR, a_cddar, f_cddar},
    {s_caadr, h_CAADR, a_caadr, f_caadr},
    {s_cdadr, h_CDADR, a_cdadr, f_cdadr},
    {s_caddr, h_CADDR, a_caddr, f_caddr},
    {s_cdddr, h_CDDDR, a_cdddr, f_cdddr},
    {s_not, h_NOT, a_not, f_not},
    {s_cons, h_CONS, a_cons, f_cons},
    {s_acons, h_ACONS, a_acons, f_acons},
    {s_symbolq, h_SYMBOLQ, a_symbolq, f_symbolq},
    {s_procedureq, h_PROCEDUREQ, a_procedureq, f_procedureq},
    {s_oidq, h_OIDQ, a_oidq, f_oidq},
    {s_objectq, h_OBJECTQ, a_objectq, f_objectq},
    {s_dateq, h_DATEQ, a_dateq, f_dateq},
    {s_length, h_LENGTH, a_length, f_length},
    {s_list_tail, h_LISTTAIL, a_list_tail, f_list_tail},
    {s_list_ref, h_LISTREF, a_list_ref, f_list_ref},
    {s_sym2str, h_SYM2STR, a_sym2str, f_sym2str},
    {s_str2sym, h_STR2SYM, a_str2sym, f_str2sym},
    {s_type, h_TYPE, a_type, f_type},
    {s_date2str, h_DATE2STR, a_date2str, f_date2str},
    {s_str2date, h_STR2DATE, a_str2date, f_str2date},
    {s_cur_time, h_CURTIME, a_cur_time, f_cur_time},
    {s_display, h_DISPLAY, a_display, f_display},
    {s_list2code, h_LIST2CODE, a_list2code, f_list2code},
    {NULL, -1, NULL, NULL}
  };
  Functiontable *ft = functbl;
  int i;
  
  for (i = 0; (ft+i)->fname != NULL ; i++)
    make_fset ((ft+i)->fname, (ft+i)->hashcode, (ft+i)->args, (ft+i)->fnc);
}

