/*
  
  This file is part of the Kaenguru Database System
  Copyright (c) 1997,98 by Gregor Klinke
  
  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.
  
  This program ist distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public Lincense for more details.

  */

#ifndef _KDBS_DBFUNC_H
#define _KDBS_DBFUNC_H

#include "kdbs.h"

#include "kscm.h"
#include "sm.h"
#include "server.h"
#include "lock.h"

/* ----------------------------------------------------------------------
   Variables
   ---------------------------------------------------------------------- */

/* from dbfunc.c */
extern Database database;
extern int func_status;
extern int forceindex;

/* from main.c */
extern int connectid;
extern char *connkey;
extern char *client_usrname;
extern Uid clientuid;
extern Gid clientgid;
extern ACode accmask;

extern int timeoutval;

/* ----------------------------------------------------------------------
   Prototypes
   ---------------------------------------------------------------------- */
/* from index.c */
extern int search_index (Database *db, Fid iid, char *find_key,
			 Searchinfo **sinfo);
extern int search_index_regexp (Database *db, Fid iid, char *regexp,
				Searchinfo **sinfo, bool scan_oids_q,
				bool no_string_q);

/* from dbfunc.c */
extern char *convert_object_to_buffer (Vector *objv, int *length);
extern Atom convert_buffer_to_object (Oid oid, char *buf, int len,
				      Objstat *objstat);
extern void merge_iid (Atom list, int keylist[], int *keylistsize);
extern int insert_keylist (Atom newkeys, Oid oid);
extern int delete_keylist (Atom oldkeys, Oid oid);
extern int look_up_index (char *indxname);
extern Oid get_oid_by_index (char *key, int indxno);
extern Atom read_object (Oid oid);
extern Atom insert_object (Atom target_obj, int target_fid, Atom keylist);
extern Atom begin_update_object (Oid target_oid);
extern Atom esc_update_object ();
extern Atom update_object (Atom old_keylist, Atom new_keylist);
extern Atom begin_delete_object (Oid target_oid);
extern Atom delete_object (Atom keylist);
extern Atom begin_undelete_object (Oid target_oid);
extern Atom undelete_object (Atom keylist);
extern Atom begin_kill_object (Oid target_oid);
extern Atom kill_object (Atom keylist);

/* func-status */
#define func_NONE             0
#define func_UPDATE           1
#define func_INSERT           2
#define func_DELETE           3
#define func_READ             4
#define func_READ_INDEX       5
#define func_KILL             6
#define func_UNDELETE         7
#define func_CHUSR            8
#define func_CHGRP            9
#define func_CHACCESS        10

/* from access.c */
extern int lock_update (Oid oid, Fid fid, int *indxlist, int indxlistsize,
			Dbid, int lockid);
extern int begin_insert (Oid oid, Fid fid, int *indxlist, int indxlistsize,
			 Dbid);
extern int verify_opendb (char *dbname, VOretval **voretval);
extern int lock_database (Database *db, int lockmode);
extern int lock_delete (int *indxlist, int indxlistsize,
			Dbid databaseid, int lockid);
extern int lock_undelete (int *indxlist, int indxlistsize, 
			  Dbid databaseid, int lockid);
extern int lock_kill (Fid fid, int *indxlist, int indxlistsize, 
		      Dbid databaseid, int lockid);
     
extern int verify_permission (Uid uid, int owner, Uid itemuid, Gid itemgid,
			      ACode acode, int func);

#define GETRESOURCES(FUNC, LOCKID, RESSTR)		\
({ 							\
  getresources (daemonsock, connectid, connkey, FUNC,	\
		LOCKID, RESSTR, timeoutval);		\
})
#define FREERESOURCES(LOCKID)					\
({								\
  freeresources (daemonsock, connectid, connkey, LOCKID,	\
		 timeoutval);					\
})
#define TESTRES(retval)				\
({						\
  int _retval = (retval);			\
  switch (_retval) {				\
  case -1:					\
  case -2:					\
    return -1;					\
  case -3:					\
    eoserver = true;				\
    return -1;					\
  case 0:					\
    return 0;					\
  }						\
  _retval;					\
})

#define begin_update(oid, databaseid)					 \
({									 \
  char _resstr[MAXMSG];							 \
  resstrcpy (_resstr, lock_RESTRICTED, lock_DATA, (databaseid), (oid));	 \
  GETRESOURCES (KCP_BEGINTRANS, 0, _resstr);				 \
})
#define end_update(lockid) ({ FREERESOURCES (lockid); })

#define begin_read(oid, databaseid)					\
({									\
  char _resstr[MAXMSG];							\
  resstrcpy (_resstr, lock_SHARED, lock_DATA, (databaseid), (oid));	\
  GETRESOURCES (KCP_BEGINTRANS, 0, _resstr);				\
})
#define end_read(lockid) ({ FREERESOURCES (lockid);})

#define end_insert(lockid) ({ FREERESOURCES (lockid);})

#define begin_read_index(indexno, databaseid)				 \
({									 \
  char _resstr[MAXMSG];							 \
  resstrcpy (_resstr, lock_SHARED, lock_INDEX, (databaseid), (indexno)); \
  GETRESOURCES (KCP_BEGINTRANS, 0, _resstr);				 \
})
#define end_read_index(lockid) ({ FREERESOURCES (lockid);})

#define begin_delete(oid, databaseid)					\
({									\
  char _resstr[MAXMSG];							\
  resstrcpy (_resstr, lock_LOCKED, lock_DATA, (databaseid), (oid));	\
  GETRESOURCES (KCP_BEGINTRANS,	0, _resstr);				\
})
#define end_delete(lockid) ({ FREERESOURCES (lockid); })

#define begin_undelete(oid, databaseid)					\
({									\
  char _resstr[MAXMSG];							\
  resstrcpy (_resstr, lock_LOCKED, lock_DATA, (databaseid), (oid));	\
  GETRESOURCES (KCP_BEGINTRANS, 0, _resstr);				\
})
#define end_undelete(lockid) ({ FREERESOURCES (lockid); })

#define begin_kill(oid, databaseid)					\
({									\
  char _resstr[MAXMSG];							\
  resstrcpy (_resstr, lock_LOCKED, lock_DATA, (databaseid), (oid));	\
  GETRESOURCES (KCP_BEGINTRANS, 0, _resstr);				\
})
#define end_kill(lockid) ({ FREERESOURCES (lockid); })

#define free_all_resources() ({ FREERESOURCES (0);})

#define begin_opendb(databaseid)					\
({									\
  char _resstr[MAXMSG];							\
  resstrcpy (_resstr, lock_SHARED, lock_OPENDB, (databaseid), 0);	\
  GETRESOURCES (KCP_BEGINTRANS,	0, _resstr);				\
})
#define end_opendb(lockid) ({ FREERESOURCES (lockid); })

#define begin_change_flags(oid,databaseid)				\
({									\
  char _resstr[MAXMSG];							\
  resstrcpy (_resstr, lock_LOCKED, lock_DATA, (databaseid), (oid));	\
  GETRESOURCES (KCP_BEGINTRANS,	0, _resstr);				\
})
#define end_change_flags(lockid) ({ FREERESOURCES (lockid); })


/* ---------------------------------------------------------------------- */
#define WORDLNG             254
#define WORDFLAG            0xfe
#define LONGLNG             65535
#define LONGFLAG            0xff

extern char * rb_getln(char *bp, int *stringlength);

#endif
